/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.tuc.manager.widget;

import com.metratec.lib.tuc.types.TUCConfiguration;
import com.metratec.lib.tuc.types.TUCPortConfiguration;
import com.metratec.tuc.manager.widget.IPHBox;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class PortSettingsGridPane
extends GridPane {
    private final List<Integer> baudrateList = Arrays.asList(110, 300, 600, 1200, 2400, 4800, 9600, 14400, 19200, 38400, 57600, 115200, 230400, 460800, 1024000);
    private final Label[] portLabel;
    private final ChoiceBox<String>[] portType;
    private final ChoiceBox<Integer>[] baudRate;
    private final ChoiceBox<Integer>[] dataSize;
    private final ChoiceBox<String>[] parity;
    private final ChoiceBox<Integer>[] stopBits;
    private final ChoiceBox<String>[] flowControl;
    private final ChoiceBox<String>[] protocol;
    private final TextField[] tcpPort;
    private final TextField[] connectionTimeout;
    private final ChoiceBox<String>[] tcpMode;
    private final IPHBox[] remoteServerIp;
    private final TextField[] remoteServerPort;

    public PortSettingsGridPane() {
        Label portTypeLabel = new Label("Port Type:");
        Label baudRateLabel = new Label("Baud Rate:");
        Label dataSizeLabel = new Label("Data Size:");
        Label parityLabel = new Label("Parity:");
        Label stopBitsLabel = new Label("Stop Bits:");
        Label flowControlLabel = new Label("Flow Control:");
        Label protocolLabel = new Label("Protocol:");
        Label tcpPortLabel = new Label("TCP Port:");
        Label connectionTimeoutLabel = new Label("Connection Timeout:");
        Label tcpModeLabel = new Label("TCP Mode:");
        Label remoteServerIpLabel = new Label("Remote Server IP:");
        Label remoteServerPortLabel = new Label("Remote Server Port:");
        String bold = "-fx-font-weight: bold;";
        String boldPadded = bold + " -fx-padding: 0 0 0 10px;";
        portTypeLabel.setStyle(bold);
        baudRateLabel.setStyle(bold);
        dataSizeLabel.setStyle(bold);
        parityLabel.setStyle(bold);
        stopBitsLabel.setStyle(bold);
        flowControlLabel.setStyle(bold);
        protocolLabel.setStyle(bold);
        tcpPortLabel.setStyle(bold);
        connectionTimeoutLabel.setStyle(bold);
        tcpModeLabel.setStyle(bold);
        remoteServerIpLabel.setStyle(boldPadded);
        remoteServerPortLabel.setStyle(boldPadded);
        this.portLabel = new Label[2];
        this.portType = new ChoiceBox[2];
        this.baudRate = new ChoiceBox[2];
        this.dataSize = new ChoiceBox[2];
        this.parity = new ChoiceBox[2];
        this.stopBits = new ChoiceBox[2];
        this.flowControl = new ChoiceBox[2];
        this.protocol = new ChoiceBox[2];
        this.tcpPort = new TextField[2];
        this.connectionTimeout = new TextField[2];
        this.tcpMode = new ChoiceBox[2];
        this.remoteServerIp = new IPHBox[2];
        this.remoteServerPort = new TextField[2];
        super.add((Node)portTypeLabel, 0, 1);
        super.add((Node)baudRateLabel, 0, 2);
        super.add((Node)dataSizeLabel, 0, 3);
        super.add((Node)parityLabel, 0, 4);
        super.add((Node)stopBitsLabel, 0, 5);
        super.add((Node)flowControlLabel, 0, 6);
        super.add((Node)protocolLabel, 0, 7);
        super.add((Node)tcpPortLabel, 0, 8);
        super.add((Node)connectionTimeoutLabel, 0, 9);
        super.add((Node)tcpModeLabel, 0, 10);
        super.add((Node)remoteServerIpLabel, 0, 11);
        super.add((Node)remoteServerPortLabel, 0, 12);
        String prefWidth = "-fx-pref-width: 200;";
        for (int i = 0; i < 2; ++i) {
            this.portLabel[i] = new Label(String.format("Port %d", i));
            this.portLabel[i].setStyle(bold);
            this.portType[i] = new ChoiceBox(FXCollections.observableArrayList((Object[])new String[]{"UART", "GPIO"}));
            this.portType[i].setStyle(prefWidth);
            this.portType[i].getSelectionModel().selectedItemProperty().addListener((ov, oldVal, newVal) -> this.onPortTypeChanged());
            this.tcpMode[i] = new ChoiceBox(FXCollections.observableArrayList((Object[])new String[]{"CLIENT", "SERVER"}));
            this.tcpMode[i].setStyle(prefWidth);
            this.tcpMode[i].getSelectionModel().selectedItemProperty().addListener((ov, oldVal, newVal) -> this.modifyServerSettingsFields());
            this.baudRate[i] = new ChoiceBox(FXCollections.observableArrayList(this.baudrateList));
            this.baudRate[i].setStyle(prefWidth);
            this.dataSize[i] = new ChoiceBox(FXCollections.observableArrayList((Object[])new Integer[]{5, 6, 7, 8}));
            this.dataSize[i].setStyle(prefWidth);
            this.parity[i] = new ChoiceBox(FXCollections.observableArrayList((Object[])new String[]{"NONE", "ODD", "EVEN", "MARK", "SPACE"}));
            this.parity[i].setStyle(prefWidth);
            this.stopBits[i] = new ChoiceBox(FXCollections.observableArrayList((Object[])new Integer[]{1, 2}));
            this.stopBits[i].setStyle(prefWidth);
            this.flowControl[i] = new ChoiceBox(FXCollections.observableArrayList((Object[])new String[]{"NONE", "HARDWARE"}));
            this.flowControl[i].setStyle(prefWidth);
            this.protocol[i] = new ChoiceBox(FXCollections.observableArrayList((Object[])new String[]{"TELNET", "RAW"}));
            this.protocol[i].setStyle(prefWidth);
            this.tcpPort[i] = new TextField();
            this.connectionTimeout[i] = new TextField();
            this.remoteServerIp[i] = new IPHBox();
            this.remoteServerPort[i] = new TextField();
            super.add((Node)this.portLabel[i], i + 1, 0);
            super.add(this.portType[i], i + 1, 1);
            super.add(this.baudRate[i], i + 1, 2);
            super.add(this.dataSize[i], i + 1, 3);
            super.add(this.parity[i], i + 1, 4);
            super.add(this.stopBits[i], i + 1, 5);
            super.add(this.flowControl[i], i + 1, 6);
            super.add(this.protocol[i], i + 1, 7);
            super.add((Node)this.tcpPort[i], i + 1, 8);
            super.add((Node)this.connectionTimeout[i], i + 1, 9);
            super.add(this.tcpMode[i], i + 1, 10);
            super.add((Node)this.remoteServerIp[i], i + 1, 11);
            super.add((Node)this.remoteServerPort[i], i + 1, 12);
        }
    }

    private int parseBaudrate(int baudrate) {
        for (int count = 1; count < this.baudrateList.size(); ++count) {
            int high;
            int low = this.baudrateList.get(count - 1);
            if (baudrate > (low + (high = this.baudrateList.get(count).intValue())) / 2) continue;
            return low;
        }
        return this.baudrateList.get(this.baudrateList.size() - 1);
    }

    public void updateLabels(TUCConfiguration config) throws UnknownHostException {
        for (int i = 0; i < 2; ++i) {
            TUCPortConfiguration port = (TUCPortConfiguration)config.getPortConfiguration().get(i);
            if (port.getPinType().equals("UART")) {
                this.portType[i].setValue((Object)"UART");
                this.baudRate[i].setValue((Object)this.parseBaudrate(port.getPortBaudrate()));
                this.dataSize[i].setValue((Object)port.getPortDatasize());
                this.parity[i].setValue((Object)port.getPortParity());
                this.stopBits[i].setValue((Object)port.getPortStopbits());
                this.flowControl[i].setValue((Object)port.getPortFlowcontrol());
                this.protocol[i].setValue((Object)port.getTcpProtocol());
                this.tcpPort[i].setText(Integer.toString(port.getTcpPort()));
                this.connectionTimeout[i].setText(Integer.toString(port.getTcpTimeout()));
                this.tcpMode[i].setValue((Object)port.getTcpMode());
                if (!port.getTcpMode().equals("CLIENT")) continue;
                this.remoteServerIp[i].setValue(port.getTcpRemoteServerIP());
                this.remoteServerPort[i].setText(Integer.toString(port.getTcpRemoteServerPort()));
                continue;
            }
            this.portType[i].setValue((Object)"GPIO");
        }
    }

    public void resetLabels() {
        for (int i = 0; i < 2; ++i) {
            this.portType[i].setValue(null);
            this.baudRate[i].setValue(null);
            this.dataSize[i].setValue(null);
            this.parity[i].setValue(null);
            this.stopBits[i].setValue(null);
            this.flowControl[i].setValue(null);
            this.protocol[i].setValue(null);
            this.tcpPort[i].setText("");
            this.connectionTimeout[i].setText("");
            this.tcpMode[i].setValue(null);
            this.remoteServerIp[i].reset();
            this.remoteServerPort[i].setText("");
        }
    }

    public String getPortType(int port) {
        return (String)this.portType[port].getSelectionModel().getSelectedItem();
    }

    public Integer getBaudRate(int port) {
        return (Integer)this.baudRate[port].getSelectionModel().getSelectedItem();
    }

    public Integer getDataSize(int port) {
        return (Integer)this.dataSize[port].getSelectionModel().getSelectedItem();
    }

    public String getParity(int port) {
        return (String)this.parity[port].getSelectionModel().getSelectedItem();
    }

    public Integer getStopBits(int port) {
        return (Integer)this.stopBits[port].getSelectionModel().getSelectedItem();
    }

    public String getFlowControl(int port) {
        return (String)this.flowControl[port].getSelectionModel().getSelectedItem();
    }

    public int getTcpPort(int port) {
        int ret;
        try {
            ret = Integer.parseInt(this.tcpPort[port].getText(), 10);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid TCP Port", ex);
        }
        return ret;
    }

    public String getProtocol(int port) {
        return (String)this.protocol[port].getSelectionModel().getSelectedItem();
    }

    public String getTcpMode(int port) {
        return (String)this.tcpMode[port].getSelectionModel().getSelectedItem();
    }

    public String getRemoteServerIp(int port) {
        return this.remoteServerIp[port].getAddress();
    }

    public int getRemoteServerPort(int port) {
        int ret;
        try {
            ret = Integer.parseInt(this.remoteServerPort[port].getText(), 10);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid Remote Server Port", ex);
        }
        return ret;
    }

    public int getConnectionTimeout(int port) {
        int ret;
        try {
            ret = Integer.parseInt(this.connectionTimeout[port].getText(), 10);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid Connection Timeout", ex);
        }
        return ret;
    }

    private void onPortTypeChanged() {
        for (int port = 0; port < 2; ++port) {
            boolean disable = true;
            boolean disable2 = true;
            if ("UART".equals(this.portType[port].getSelectionModel().getSelectedItem())) {
                disable = false;
                if ("CLIENT".equals(this.tcpMode[port].getSelectionModel().getSelectedItem())) {
                    disable2 = false;
                }
            }
            this.baudRate[port].setDisable(disable);
            this.dataSize[port].setDisable(disable);
            this.parity[port].setDisable(disable);
            this.stopBits[port].setDisable(disable);
            this.flowControl[port].setDisable(disable);
            this.protocol[port].setDisable(disable);
            this.tcpPort[port].setDisable(disable);
            this.connectionTimeout[port].setDisable(disable);
            this.tcpMode[port].setDisable(disable);
            this.remoteServerIp[port].setDisable(disable2);
            this.remoteServerPort[port].setDisable(disable2);
        }
    }

    private void modifyServerSettingsFields() {
        for (int port = 0; port < 2; ++port) {
            boolean disable = true;
            if ("CLIENT".equals(this.tcpMode[port].getSelectionModel().getSelectedItem())) {
                disable = false;
            }
            this.remoteServerIp[port].setDisable(disable);
            this.remoteServerPort[port].setDisable(disable);
        }
    }
}

