/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.tuc.manager.widget;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;

public class IPHBox
extends HBox {
    private final IPTextField[] field = new IPTextField[4];
    private final Label label1;
    private final Label label2;
    private final Label label3;

    public IPHBox() {
        for (int i = 0; i < 4; ++i) {
            this.field[i] = new IPTextField();
            this.field[i].setId("field" + i);
        }
        this.registerListener(this.field[0], this.field[1]);
        this.registerListener(this.field[1], this.field[2]);
        this.registerListener(this.field[2], this.field[3]);
        this.label1 = new Label(".");
        this.label2 = new Label(".");
        this.label3 = new Label(".");
        super.getChildren().addAll((Object[])new Node[]{this.field[0], this.label1, this.field[1], this.label2, this.field[2], this.label3, this.field[3]});
    }

    public void setMaxValue(int value) {
        int maxValue = value;
        if (maxValue > 255) {
            maxValue = 255;
        } else if (maxValue < 0) {
            maxValue = 0;
        }
        for (int i = 0; i < 4; ++i) {
            this.field[i].setMaxValue(maxValue);
        }
    }

    public void setValue(byte[] b) {
        for (int i = 0; i < 4; ++i) {
            this.field[i].setText(Integer.toString(b[i] & 0xFF));
        }
    }

    public void setValue(String ip) throws UnknownHostException {
        InetAddress inetAddr = InetAddress.getByName(ip);
        byte[] b = inetAddr.getAddress();
        this.setValue(b);
    }

    public byte[] getValue() {
        byte[] b = new byte[4];
        try {
            for (int i = 0; i < 4; ++i) {
                b[i] = (byte)Integer.parseInt(this.field[i].getText(), 10);
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("IP field can not be empty", ex);
        }
        return b;
    }

    public String getAddress() {
        return this.field[0].getText() + "." + this.field[1].getText() + "." + this.field[2].getText() + "." + this.field[3].getText();
    }

    public void reset() {
        for (int i = 0; i < 4; ++i) {
            this.field[i].setText("0");
        }
    }

    private void registerListener(TextField tf1, TextField tf2) {
        tf1.textProperty().addListener((obs, oldText, newText) -> {
            if (oldText.length() < 3 && newText.length() >= 3 || newText.length() > 0 && Integer.parseInt(newText) > 25) {
                tf2.requestFocus();
            }
        });
    }

    private class IPTextField
    extends TextField {
        private int maxValue = 254;

        private IPTextField() {
        }

        public void replaceText(int start, int end, String text) {
            if (this.validate(text)) {
                super.replaceText(start, end, text);
            }
            this.verify();
        }

        public void replaceSelection(String text) {
            if (this.validate(text)) {
                super.replaceSelection(text);
            }
            this.verify();
        }

        private boolean validate(String text) {
            return "".equals(text) || text.matches("[0-9]");
        }

        private void setMaxValue(int maxValue) {
            this.maxValue = maxValue;
        }

        private void verify() {
            String text = this.getText();
            int len = text.length();
            int ip = 0;
            if (!text.equals("")) {
                ip = Integer.parseInt(text);
                this.setText(Integer.toString(ip));
                this.positionCaret(3);
            } else {
                this.setText("0");
                this.positionCaret(1);
            }
            if (ip > this.maxValue) {
                this.setText(text.substring(0, len - 1));
                this.positionCaret(len - 1);
            } else if (len > 3) {
                this.setText(text.substring(0, 3));
                this.positionCaret(3);
            } else if (len == 3) {
                this.positionCaret(0);
            }
        }
    }
}

