/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.tuc.manager.widget;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;

public class IP6HBox
extends HBox {
    private final IPTextField[] field = new IPTextField[8];
    private final Label[] label;

    public IP6HBox() {
        int i;
        for (i = 0; i < 8; ++i) {
            this.field[i] = new IPTextField();
            this.field[i].setId("field" + i);
        }
        for (i = 0; i < 7; ++i) {
            this.registerListener(this.field[i], this.field[i + 1]);
        }
        this.label = new Label[7];
        for (i = 0; i < 7; ++i) {
            this.label[i] = new Label(":");
        }
        super.getChildren().addAll((Object[])new Node[]{this.field[0], this.label[0], this.field[1], this.label[1], this.field[2], this.label[2], this.field[3], this.label[3], this.field[4], this.label[4], this.field[5], this.label[5], this.field[6], this.label[6], this.field[7]});
    }

    public void setValue(byte[] b) {
        for (int i = 0; i < 8; ++i) {
            String b1 = String.format("%02x", b[i * 2]);
            String b2 = String.format("%02x", b[i * 2 + 1]);
            this.field[i].setText(b1 + b2);
        }
    }

    public void setValue(String ip) throws UnknownHostException {
        if (ip == null || ip.isEmpty()) {
            ip = "::1";
        }
        InetAddress inetAddr = InetAddress.getByName(ip);
        byte[] b = inetAddr.getAddress();
        this.setValue(b);
    }

    public byte[] getValue() {
        byte[] b = new byte[16];
        try {
            for (int i = 0; i < 16; ++i) {
                b[i] = (byte)Integer.parseInt(this.field[i].getText(), 16);
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("IP field can not be empty", ex);
        }
        return b;
    }

    public String getAddress() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.field[0].getText());
        for (int i = 1; i < 8; ++i) {
            sb.append(":");
            sb.append(this.field[i].getText());
        }
        return sb.toString();
    }

    public void reset() {
        for (int i = 0; i < 8; ++i) {
            this.field[i].setText("0");
        }
    }

    private void registerListener(TextField tf1, TextField tf2) {
        tf1.textProperty().addListener((obs, oldText, newText) -> {
            if (oldText.length() < 4 && newText.length() >= 4) {
                tf2.requestFocus();
            }
        });
    }

    private static class IPTextField
    extends TextField {
        private IPTextField() {
        }

        public void replaceText(int start, int end, String text) {
            if (this.validate(text)) {
                super.replaceText(start, end, text);
            }
            this.verify();
        }

        public void replaceSelection(String text) {
            if (this.validate(text)) {
                super.replaceSelection(text);
            }
            this.verify();
        }

        private boolean validate(String text) {
            return "".equals(text) || text.matches("[0-9a-fA-F]");
        }

        private void verify() {
            String text = this.getText();
            int len = text.length();
            int ip = 0;
            if (!text.equals("")) {
                ip = Integer.parseInt(text, 16);
                this.positionCaret(3);
            } else {
                this.setText("0");
                this.positionCaret(1);
            }
            if (ip > 65535) {
                this.setText(text.substring(0, len - 1));
                this.positionCaret(len - 1);
            } else if (len > 4) {
                this.setText(text.substring(0, 4));
                this.positionCaret(4);
            } else if (len == 4) {
                this.positionCaret(0);
            }
        }
    }
}

