/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.tuc.manager.widget;

import com.metratec.tuc.manager.DeviceInfo;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;

public class DeviceInfoGridPane
extends GridPane {
    private final Label nameLabel = new Label("Name:");
    private final Label firmwareVersionLabel = new Label("Firmware:");
    private final Label hardwareVersionLabel = new Label("Hardware:");
    private final Label IPAddressLabel = new Label("IP Address:");
    private final Label MACAddressLabel = new Label("MAC Address:");
    private final Label SerialNumberLabel = new Label("Serial Number:");
    private final Label name;
    private final Label firmwareVersion;
    private final Label hardwareVersion;
    private final Label IPAddress;
    private final Label MACAddress;
    private final Label SerialNumber;

    public DeviceInfoGridPane() {
        this.nameLabel.setStyle("-fx-font-weight: bold;");
        this.firmwareVersionLabel.setStyle("-fx-font-weight: bold;");
        this.hardwareVersionLabel.setStyle("-fx-font-weight: bold;");
        this.IPAddressLabel.setStyle("-fx-font-weight: bold;");
        this.MACAddressLabel.setStyle("-fx-font-weight: bold;");
        this.SerialNumberLabel.setStyle("-fx-font-weight: bold;");
        this.name = new Label();
        this.firmwareVersion = new Label();
        this.hardwareVersion = new Label();
        this.IPAddress = new Label();
        this.MACAddress = new Label();
        this.SerialNumber = new Label();
        this.name.setId("name");
        this.firmwareVersion.setId("firmwareVersion");
        this.hardwareVersion.setId("hardwareVersion");
        this.IPAddress.setId("ipAddress");
        this.MACAddress.setId("macAddress");
        this.SerialNumber.setId("serialNumber");
        super.add((Node)this.nameLabel, 0, 0);
        super.add((Node)this.name, 1, 0);
        super.add((Node)this.firmwareVersionLabel, 0, 1);
        super.add((Node)this.firmwareVersion, 1, 1);
        super.add((Node)this.hardwareVersionLabel, 0, 2);
        super.add((Node)this.hardwareVersion, 1, 2);
        super.add((Node)this.IPAddressLabel, 0, 3);
        super.add((Node)this.IPAddress, 1, 3);
        super.add((Node)this.MACAddressLabel, 0, 4);
        super.add((Node)this.MACAddress, 1, 4);
        super.add((Node)this.SerialNumberLabel, 0, 5);
        super.add((Node)this.SerialNumber, 1, 5);
    }

    public void updateLabels(DeviceInfo info) {
        this.name.setText(info.getName());
        this.firmwareVersion.setText((String)(null != info.getFirmwareName() && !info.getFirmwareName().isEmpty() ? info.getFirmwareName() + " " : "") + info.getFirmwareVersion());
        this.hardwareVersion.setText((String)(null != info.getHardwareName() && !info.getHardwareName().isEmpty() ? info.getHardwareName() + " " : "") + info.getHardwareVersion());
        this.IPAddress.setText(info.getIpAddress());
        this.MACAddress.setText(info.getMacAddress());
        this.SerialNumber.setText(info.getSerialNumber());
        if (null != info.getSerialNumber() && !info.getSerialNumber().isEmpty()) {
            this.SerialNumber.setVisible(true);
            this.SerialNumberLabel.setVisible(true);
        } else {
            this.SerialNumber.setVisible(false);
            this.SerialNumberLabel.setVisible(false);
        }
    }

    public void resetLabels() {
        this.name.setText("");
        this.firmwareVersion.setText("");
        this.hardwareVersion.setText("");
        this.IPAddress.setText("");
        this.MACAddress.setText("");
        this.SerialNumber.setText("");
    }
}

