/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.tuc.manager.utils;

import com.metratec.tuc.manager.utils.ExceptionAlert;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.stage.Window;

public class AlertDialog {
    private static Window window = null;

    public static void initOwner(Window owner) {
        window = owner;
    }

    public static boolean showConfirmation(String title, String message) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.initOwner(window);
        alert.setTitle(title);
        alert.setHeaderText(null);
        Label label = new Label(message);
        label.setWrapText(true);
        alert.getDialogPane().setContent((Node)label);
        Optional result = alert.showAndWait();
        return ((ButtonType)result.get()).equals(ButtonType.OK);
    }

    public static void showAlert(String title, String message, Alert.AlertType alertType) {
        Alert alert = new Alert(alertType);
        alert.initOwner(window);
        alert.setResizable(true);
        alert.setTitle(title);
        alert.setHeaderText(null);
        Label label = new Label(message);
        label.setWrapText(true);
        alert.getDialogPane().setContent((Node)label);
        alert.showAndWait();
    }

    public static void showException(Throwable ex) {
        ExceptionAlert alert = new ExceptionAlert(ex);
        alert.initOwner(window);
        alert.setTitle("An Exception Occurred");
        alert.setHeaderText(ex.getMessage());
        alert.setContentText(null);
        alert.showAndWait();
    }
}

