/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.tuc.manager.control;

import com.metratec.tuc.manager.TUCConfigManager;
import com.metratec.tuc.manager.TUCDeviceModel;
import com.metratec.tuc.manager.utils.AlertDialog;
import com.metratec.tuc.manager.utils.AuthentificationListener;
import com.metratec.tuc.manager.utils.HttpAuthenticator;
import java.io.IOException;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.html.HTMLFormElement;

public class WebViewPaneController
implements Initializable {
    @FXML
    private WebView webView;
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private GridPane gridPane;
    @FXML
    private TextField username;
    @FXML
    private PasswordField password;
    @FXML
    private ProgressBar progressBar;
    private String version;
    private WebEngine webEngine;
    private String url;
    private TUCDeviceModel activeDevice;
    private Logger logger = TUCConfigManager.getLogger();
    private AuthentificationListener authListener;
    private boolean loginNeeded = false;
    private final WebsiteLogBridge logBridge = new WebsiteLogBridge();

    public void initialize(URL url, ResourceBundle rb) {
        this.webEngine = this.webView.getEngine();
        this.progressBar.progressProperty().bind((ObservableValue)this.webEngine.getLoadWorker().progressProperty());
        this.authListener = () -> {
            if (this.loginNeeded) {
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("update credentials");
            }
            this.loginNeeded = true;
            Platform.runLater(() -> this.webEngine.load(null));
        };
        this.showAuthDialog(false);
        Authenticator.setDefault(new HttpAuthenticator(TUCConfigManager.getConfig().getTuc2().getUsernameOrDefault(), TUCConfigManager.getConfig().getTuc2().getPasswordOrDefault(), this.authListener));
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setActiveDevice(TUCDeviceModel activeDevice) {
        this.activeDevice = activeDevice;
        this.load();
    }

    public void load() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.activeDevice.getDeviceInformation() + " load");
        }
        this.progressBar.progressProperty().unbind();
        this.anchorPane.getChildren().remove((Object)this.webView);
        this.webView = new WebView();
        AnchorPane.setTopAnchor((Node)this.webView, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.webView, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.webView, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.webView, (Double)20.0);
        this.anchorPane.getChildren().add((Object)this.webView);
        this.webEngine = this.webView.getEngine();
        this.webEngine.setUserAgent(this.webEngine.getUserAgent() + " TUC-Config-Manager/" + this.version);
        this.progressBar.progressProperty().bind((ObservableValue)this.webEngine.getLoadWorker().progressProperty());
        this.webEngine.setJavaScriptEnabled(true);
        if (null != this.activeDevice.getTucUpnpDevice()) {
            if (!this.activeDevice.isReachable()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.activeDevice.getDeviceInformation() + " upnp device is not reachable");
                }
                return;
            }
            this.url = this.activeDevice.getTucUpnpDevice().getDescription().getPresentationURL();
            this.webEngine.setOnAlert(event -> this.showAlert((String)event.getData()));
            this.webEngine.setConfirmHandler(message -> this.showConfirm((String)message));
            this.webEngine.setOnError(event -> this.showError(event.getException()));
            this.webEngine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
                JSObject window = (JSObject)this.webEngine.executeScript("window");
                window.setMember("java", this.logBridge);
                this.webEngine.executeScript("console.log = function(message)\n{\n    java.log(message);\n};");
            });
            this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                    if (WebViewPaneController.this.logger.isDebugEnabled()) {
                        WebViewPaneController.this.logger.debug("changed to - " + newValue);
                    }
                    if (newValue == Worker.State.SUCCEEDED) {
                        Document doc = WebViewPaneController.this.webView.getEngine().getDocument();
                        if (null == doc) {
                            if (WebViewPaneController.this.logger.isDebugEnabled()) {
                                WebViewPaneController.this.logger.debug(WebViewPaneController.this.activeDevice.getDeviceInformation() + " no document");
                            }
                            return;
                        }
                        Element el = doc.getElementById("deviceName");
                        if (null == el) {
                            double firmwareVersion = WebViewPaneController.this.getFirmwareVersion();
                            if (WebViewPaneController.this.logger.isDebugEnabled()) {
                                WebViewPaneController.this.logger.debug(WebViewPaneController.this.activeDevice.getDeviceInformation() + " Login required (V" + firmwareVersion + ")");
                            }
                            if (firmwareVersion >= 2.0 && firmwareVersion < 2.14) {
                                WebViewPaneController.this.onShowLogin();
                            } else {
                                Element eUsername = doc.getElementById("username");
                                Element ePassword = doc.getElementById("password");
                                HTMLFormElement form = (HTMLFormElement)doc.getElementById("form");
                                if (null != WebViewPaneController.this.username && null != WebViewPaneController.this.password && null != form) {
                                    if (WebViewPaneController.this.logger.isDebugEnabled()) {
                                        WebViewPaneController.this.logger.debug(WebViewPaneController.this.activeDevice.getDeviceInformation() + " loging to webpage");
                                    }
                                    eUsername.setAttribute("value", WebViewPaneController.this.username.getText());
                                    ePassword.setAttribute("value", WebViewPaneController.this.password.getText());
                                    form.submit();
                                } else {
                                    WebViewPaneController.this.onShowLogin();
                                }
                            }
                        } else {
                            if (WebViewPaneController.this.logger.isDebugEnabled()) {
                                WebViewPaneController.this.logger.debug(WebViewPaneController.this.activeDevice.getDeviceInformation() + " Webpage loaded");
                            }
                            WebViewPaneController.this.loginNeeded = false;
                        }
                    }
                }
            });
        } else {
            this.url = "http://" + this.activeDevice.getTucDevice().getInetAddress().getHostAddress();
        }
        this.webEngine.load(this.url);
    }

    private boolean showConfirm(String message) {
        System.err.println("showConfirm " + message);
        try {
            return AlertDialog.showConfirmation("Confirm", message);
        }
        catch (Exception e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.activeDevice.getDeviceInformation() + " Error showConfirm '" + message + "' - returning true as default - " + e.getMessage());
            }
            return true;
        }
    }

    private void showAlert(String message) {
        block4: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.activeDevice.getDeviceInformation() + " Alert - " + message);
            }
            if (this.loginNeeded) {
                this.onShowLogin();
                return;
            }
            try {
                AlertDialog.showAlert("Alert", message, Alert.AlertType.WARNING);
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.info(this.activeDevice.getDeviceInformation() + " Error showConfirm '" + message + "' - returning true as default - " + e.getMessage());
            }
        }
    }

    private void showError(Throwable e) {
        block4: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.activeDevice.getDeviceInformation() + " Error - " + e.toString());
            }
            try {
                if (e.getClass().toString().contains("DirectoryAlreadyInUseException")) {
                    return;
                }
                AlertDialog.showException(e);
            }
            catch (Exception e1) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.info(this.activeDevice.getDeviceInformation() + " Error -" + e.getMessage() + " - Exception - " + e1.toString() + " - returning true as default ");
            }
        }
    }

    private double getFirmwareVersion() {
        try {
            return Double.parseDouble(this.activeDevice.getInfo().getFirmwareVersion());
        }
        catch (NullPointerException | NumberFormatException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.activeDevice.getDeviceInformation() + " Error get firmware version " + e.toString());
            }
            return 1.0;
        }
    }

    private void showAuthDialog(boolean show) {
        this.gridPane.setVisible(show);
        this.webView.setVisible(!show);
        if (show) {
            this.username.requestFocus();
        }
    }

    @FXML
    public void onShowLogin() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.activeDevice.getDeviceInformation() + " show login");
        }
        this.showAuthDialog(true);
    }

    @FXML
    public void onLogin() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.activeDevice.getDeviceInformation() + " loggin clicked");
        }
        this.showAuthDialog(false);
        Authenticator.setDefault(new HttpAuthenticator(this.username.getText(), this.password.getText(), this.authListener));
        this.webEngine.load(this.url);
    }

    @FXML
    public void onOpenInBrowser() {
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.indexOf("win") >= 0) {
                Runtime rt = Runtime.getRuntime();
                rt.exec("rundll32 url.dll,FileProtocolHandler " + this.url);
            } else if (os.indexOf("mac") >= 0) {
                Runtime rt = Runtime.getRuntime();
                rt.exec("open " + this.url);
            } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
                Runtime rt = Runtime.getRuntime();
                String[] browsers = new String[]{"firefox", "chromium-browser", "google-chrome", "mozilla", "konqueror", "netscape", "epiphany", "opera", "links", "lynx"};
                StringBuffer cmd = new StringBuffer();
                for (int i = 0; i < browsers.length; ++i) {
                    if (i == 0) {
                        cmd.append(String.format("%s \"%s\"", browsers[i], this.url));
                        continue;
                    }
                    cmd.append(String.format(" || %s \"%s\"", browsers[i], this.url));
                }
                rt.exec(new String[]{"sh", "-c", cmd.toString()});
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String documentToString(Document newDoc) throws Exception {
        DOMSource domSource = new DOMSource(newDoc);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        transformer.transform(domSource, sr);
        return sw.toString();
    }

    public class WebsiteLogBridge {
        public void log(String logMessage) {
            if (WebViewPaneController.this.logger.isDebugEnabled()) {
                WebViewPaneController.this.logger.debug(WebViewPaneController.this.activeDevice.getDeviceInformation() + " Website log - " + logMessage);
            }
        }
    }
}

