/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.tuc.manager.control;

import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import com.metratec.lib.connection.TcpConnection;
import com.metratec.lib.connection.UdpConnection;
import com.metratec.lib.firmware.DeviceFirmware;
import com.metratec.lib.tuc.TUCException;
import com.metratec.lib.tuc.TUCManager;
import com.metratec.lib.tuc.handler.TUCUDPControl;
import com.metratec.lib.tuc.types.TUCDevice;
import com.metratec.lib.upnp.Device;
import com.metratec.lib.upnp.Discovery;
import com.metratec.tuc.manager.DeviceInfo;
import com.metratec.tuc.manager.TUCConfigManager;
import com.metratec.tuc.manager.TUCDeviceModel;
import com.metratec.tuc.manager.control.AboutWindowController;
import com.metratec.tuc.manager.control.FirmwareUpdatePaneController;
import com.metratec.tuc.manager.control.OverviewPaneController;
import com.metratec.tuc.manager.control.WebViewPaneController;
import com.metratec.tuc.manager.utils.AlertDialog;
import com.metratec.tuc.manager.utils.Utils;
import java.io.IOException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

public final class TUCConfigManagerController
implements Initializable {
    private static final String[] DEFAULT_SEARCH_TARGETS = new String[]{"urn:www-metratec-com:device:TUC:2"};
    private TUCDeviceModel activeDevice;
    private List<TUCDevice> devices = new ArrayList<TUCDevice>();
    private static List<Device> upnpDevices = null;
    private List<TUCDeviceModel> deviceModels = new ArrayList<TUCDeviceModel>();
    private Hashtable<String, DeviceInfo> deviceInfoByIp = new Hashtable();
    private String version;
    private String copyrightText;
    private Thread upnpThread;
    @FXML
    WebViewPaneController webViewPaneController;
    @FXML
    private OverviewPaneController overviewPaneController;
    @FXML
    private FirmwareUpdatePaneController firmwareUpdatePaneController;
    @FXML
    private TableColumn<TUCDeviceModel, String> deviceIPCol;
    @FXML
    private TableColumn<TUCDeviceModel, String> deviceNameCol;
    @FXML
    private Label infoMessage;
    @FXML
    private Label copyrightLabel;
    @FXML
    private TableView<TUCDeviceModel> tableView;
    @FXML
    private Button scanButton;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab overviewTab;
    @FXML
    private Tab firmwareUpdateTab;
    @FXML
    private Tab webViewTab;
    private Stage stage;
    private Logger logger = TUCConfigManager.getLogger();

    public void setStage(Stage parent) {
        this.stage = parent;
        AlertDialog.initOwner((Window)this.stage);
        ExitApplicationEventHandler handler = new ExitApplicationEventHandler();
        this.stage.setOnCloseRequest((EventHandler)handler);
    }

    public void setVersion(String version) {
        this.version = version;
        this.webViewPaneController.setVersion(version);
    }

    public void setYear(String year) {
        this.copyrightText = "\u00c2\u00a9 Copyright " + year + ", metraTec GmbH";
        this.copyrightLabel.setText(this.copyrightText);
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.overviewPaneController.setParentController(this);
        this.firmwareUpdatePaneController.setParentController(this);
        this.scanButton.fire();
        Tooltip tooltip = new Tooltip();
        tooltip.setText("Search for TUC devices");
        this.scanButton.setTooltip(tooltip);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((ov, oldVal, newVal) -> this.onSelectionChanged());
    }

    private static boolean isOSX() {
        return System.getProperty("os.name").toLowerCase().contains("os x");
    }

    private void verifyActiveInterfaces() {
        block3: {
            try {
                List addresses = UdpConnection.getAllInterfaceInetAddresses();
                if (addresses.size() > 1) {
                    AlertDialog.showAlert("Multiple network interfaces found", "Please enable a single interface (e.g. ethernet) and disable the others. Communication to TUC Devices will not work reliably when multiple interfaces are active!", Alert.AlertType.WARNING);
                }
            }
            catch (SocketException ex) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug(ex.toString());
            }
        }
    }

    @FXML
    private void onRescanClicked(Event event) {
        if (TUCConfigManagerController.isOSX()) {
            this.verifyActiveInterfaces();
        }
        ScanDevicesTask task = new ScanDevicesTask();
        ScanDevicesTaskEventHandler handler = new ScanDevicesTaskEventHandler();
        task.setOnScheduled(handler);
        task.setOnFailed(handler);
        task.setOnSucceeded(handler);
        Thread th = new Thread((Runnable)((Object)task));
        th.setDaemon(true);
        th.start();
        ScanUpnpDevicesTask task2 = new ScanUpnpDevicesTask();
        ScanUpnpDevicesTaskEventHandler handler2 = new ScanUpnpDevicesTaskEventHandler();
        task2.setOnScheduled(handler2);
        task2.setOnFailed(handler2);
        task2.setOnSucceeded(handler2);
        this.upnpThread = new Thread((Runnable)((Object)task2));
        this.upnpThread.setDaemon(true);
        this.upnpThread.start();
    }

    @FXML
    public void onSelectionChanged() {
        TUCDeviceModel selectedModel;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("onSelectionChanged");
        }
        if (null != (selectedModel = (TUCDeviceModel)this.tableView.getSelectionModel().getSelectedItem())) {
            this.activeDevice = selectedModel;
            this.updateDevice(this.activeDevice);
        } else {
            this.resetLabels();
        }
    }

    public void updateSelectedDevice() {
        this.activeDevice.setInfo(null);
        this.onSelectionChanged();
    }

    void updateDevice(TUCDeviceModel device) {
        SelectionChangedTask task = new SelectionChangedTask(device);
        SelectionChangedTaskEventHandler handler = new SelectionChangedTaskEventHandler();
        task.setOnScheduled(handler);
        task.setOnFailed(handler);
        task.setOnSucceeded(handler);
        Thread th = new Thread((Runnable)((Object)task));
        th.setDaemon(true);
        th.start();
    }

    private String parseMacFromUsn(String usn) {
        usn = usn.split("::")[0];
        usn = usn.substring(usn.length() - 12).toUpperCase();
        StringBuilder sb = new StringBuilder(usn);
        for (int i = 10; i > 0; i -= 2) {
            sb.insert(i, ":");
        }
        return sb.toString();
    }

    private boolean isDeviceInBootloader() {
        return null != this.activeDevice && null != this.activeDevice.getTucDevice() && this.activeDevice.getTucDevice().isBootloader();
    }

    private static String convertRevisionToString(int revision) {
        String tmp = Integer.toString(revision);
        return "0" + tmp.substring(0, 1) + "." + tmp.substring(1);
    }

    protected static String convertRevisionToString(String revision) {
        try {
            return TUCConfigManagerController.convertRevisionToString(Integer.parseInt(revision));
        }
        catch (NumberFormatException e) {
            return revision;
        }
    }

    private void resetLabels() {
        this.tabPane.setDisable(true);
        this.showBootloaderWarnings(false);
        this.overviewPaneController.resetLabels();
        this.firmwareUpdatePaneController.resetLabels();
    }

    protected void onFirmwareUpdateStarted() {
        this.scanButton.setDisable(true);
        this.tableView.setDisable(true);
        this.overviewTab.setDisable(true);
        this.webViewTab.setDisable(true);
    }

    protected void onFirmwareUpdateCompleted() {
        this.scanButton.setDisable(false);
        this.overviewTab.setDisable(false);
        this.updateSelectedDevice();
    }

    protected void onIpUpdateStarted() {
        this.scanButton.setDisable(true);
        this.tableView.setDisable(true);
        this.firmwareUpdateTab.setDisable(true);
        this.webViewTab.setDisable(true);
    }

    protected void onIpUpdateCompleted() {
        this.scanButton.setDisable(false);
        this.firmwareUpdateTab.setDisable(false);
        this.updateSelectedDevice();
    }

    private void showBootloaderWarnings(boolean bool) {
        if (bool) {
            AlertDialog.showAlert("TUC Bootloader", "This device is running the TUC Bootloader which means it does not have a working firmware!\nThe IP Address  shown will be assigned for the bootloader only.\nPlease verify the IP address assignment and perform a  firmware upgrade.", Alert.AlertType.WARNING);
        }
        this.webViewTab.setDisable(bool);
    }

    @FXML
    private void onLogoClicked(MouseEvent event) throws IOException {
        Stage stage = new Stage();
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("AboutWindow.fxml"));
        Parent root = (Parent)fxmlLoader.load();
        AboutWindowController controller = (AboutWindowController)fxmlLoader.getController();
        controller.setVersionInfo(this.version);
        controller.setCopyrightText(this.copyrightText);
        Scene scene = new Scene(root);
        stage.setTitle("About TUC Config Manager");
        stage.getIcons().add((Object)new Image(this.getClass().getResource("wellen_metratec.gif").toString()));
        stage.setScene(scene);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.showAndWait();
    }

    private void populateTUCDeviceModels(List<TUCDevice> devices) {
        for (TUCDevice tuc : devices) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Add tuc device " + tuc.getIPAddress());
            }
            this.deviceModels.add(new TUCDeviceModel(tuc));
        }
    }

    private void populateTUCUpnpModels(List<Device> devices) {
        if (null == devices) {
            return;
        }
        for (Device tuc : devices) {
            TUCDeviceModel model = this.getTUCDeviceModel(tuc);
            if (null == model) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Add upnp tuc device " + tuc.getInetAddress());
                    }
                    this.deviceModels.add(new TUCDeviceModel(tuc));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("update tuc device " + tuc.getInetAddress() + " with upnp");
            }
            model.setTucUpnpDevice(tuc);
        }
    }

    private TUCDeviceModel getTUCDeviceModel(Device tuc) {
        for (TUCDeviceModel model : this.deviceModels) {
            if (!model.equals(tuc)) continue;
            return model;
        }
        return null;
    }

    private void clearARPCache(String ip) {
        try {
            Utils.executeSystemCommand("arp -d " + ip);
        }
        catch (IOException | InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private void onSelectionChangedTaskScheduled() {
        this.tableView.setDisable(true);
        this.resetLabels();
        if (null != this.activeDevice.getTucDevice()) {
            this.clearARPCache(this.activeDevice.getTucDevice().getInetAddress().getHostAddress());
            this.infoMessage.setText("Loading information for: " + this.activeDevice.getTucDevice().getMacAddressString());
        } else if (null != this.activeDevice.getTucUpnpDevice()) {
            this.clearARPCache(this.activeDevice.getTucUpnpDevice().getInetAddress().getHostAddress());
            this.infoMessage.setText("Loading information for: " + this.parseMacFromUsn(this.activeDevice.getTucUpnpDevice().getUsn()));
        }
    }

    private void onSelectionChangedTaskSuccess() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.activeDevice.getDeviceInformation() + " onSelectionChangedTaskSuccess");
        }
        this.webViewPaneController.setActiveDevice(this.activeDevice);
        this.overviewPaneController.setActiveDevice(this.activeDevice);
        this.firmwareUpdatePaneController.setActiveDevice(this.activeDevice);
        this.showBootloaderWarnings(this.isDeviceInBootloader());
        this.tableView.setDisable(false);
        this.tabPane.setDisable(false);
        if (null != this.activeDevice.getTucUpnpDevice()) {
            this.infoMessage.setText("Loaded information for: " + this.parseMacFromUsn(this.activeDevice.getTucUpnpDevice().getUsn()));
        } else if (null != this.activeDevice.getTucDevice()) {
            this.infoMessage.setText("Loaded information for: " + this.activeDevice.getTucDevice().getMacAddressString());
        }
    }

    private class ExitApplicationEventHandler
    implements EventHandler<WindowEvent> {
        private ExitApplicationEventHandler() {
        }

        public void handle(WindowEvent e) {
            TUCConfigManagerController.this.stage.close();
            TUCConfigManager.saveConfig();
        }
    }

    private class SelectionChangedTaskEventHandler
    implements EventHandler<WorkerStateEvent> {
        private SelectionChangedTaskEventHandler() {
        }

        public void handle(WorkerStateEvent e) {
            Worker selectionChangedTask = e.getSource();
            EventType type = e.getEventType();
            if (type.equals(WorkerStateEvent.WORKER_STATE_SCHEDULED)) {
                TUCConfigManagerController.this.onSelectionChangedTaskScheduled();
            } else if (type.equals(WorkerStateEvent.WORKER_STATE_SUCCEEDED)) {
                TUCConfigManagerController.this.onSelectionChangedTaskSuccess();
            } else {
                TUCConfigManagerController.this.tableView.setDisable(false);
                TUCConfigManagerController.this.tableView.getSelectionModel().clearSelection();
                TUCConfigManagerController.this.infoMessage.setText("An error occurred. Please try again later.");
                Exception ex = (Exception)selectionChangedTask.getException();
                AlertDialog.showException(ex);
            }
        }
    }

    private static class SelectionChangedTask
    extends Task<Void> {
        private TUCDeviceModel model;
        private Logger logger = TUCConfigManager.getLogger();

        SelectionChangedTask(TUCDeviceModel tucDevice) {
            this.model = tucDevice;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void call() throws IOException, TUCException, Exception {
            Object device;
            if (null != this.model.getInfo()) {
                return null;
            }
            String name = "";
            String firmwareName = "";
            String firmwareVersion = "00.00";
            String hardwareName = "";
            String hardwareVersion = "00.00";
            String ipAddress = "unknown";
            String macAddress = "";
            String serialNumber = "";
            if (null != this.model.getTucDevice()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("get legacy information from " + this.model.getTucDevice().getInetAddress());
                }
                device = this.model.getTucDevice();
                TUCUDPControl control = new TUCUDPControl((TUCDevice)device);
                control.setTimeout(2000);
                control.updateTUCDevice();
                device = control.getDevice();
                try {
                    control.addTUCSetting();
                }
                catch (TUCException | IOException e) {
                    this.logger.warn(this.model.getDeviceInformation() + " Error adding TUC Settings - " + e.getMessage());
                    device.setIP(device.getInetAddress().getAddress());
                    device.setGateway(new byte[]{0, 0, 0, 0});
                    device.setSubnetMask(new byte[]{0, 0, 0, 0});
                    device.setFirmwareRevision(200);
                    device.setHardwareRevision(203);
                }
                name = device.getName();
                firmwareVersion = device.getFirmwareRevision() == 0 ? "---" : TUCConfigManagerController.convertRevisionToString(device.getFirmwareRevision());
                hardwareVersion = device.getHardwareRevision() == 0 ? "---" : TUCConfigManagerController.convertRevisionToString(device.getHardwareRevision());
                ipAddress = null == device.getInetAddress() || device.getInetAddress().isAnyLocalAddress() ? "---" : device.getInetAddress().getHostAddress();
                macAddress = device.getMacAddressString();
            }
            if (null != this.model.getTucUpnpDevice()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("get additional information from upnp device " + this.model.getTucUpnpDevice().getInetAddress());
                }
                ipAddress = this.model.getTucUpnpDevice().getInetAddress().getHostAddress();
                if (this.model.isReachable()) {
                    device = this.model.getTucUpnpDevice();
                    TcpConnection connection = new TcpConnection(((Device)device).getInetAddress().getHostAddress(), 40001);
                    DeviceFirmware deviceFirmware = new DeviceFirmware((ICommConnection)connection);
                    try {
                        com.metratec.lib.firmware.DeviceInfo deviceInfo = deviceFirmware.getInfo();
                        name = ((Device)device).getDescription().getFriendlyName();
                        firmwareName = deviceInfo.firmwareName;
                        firmwareVersion = TUCConfigManagerController.convertRevisionToString(deviceInfo.firmwareRevision);
                        hardwareName = deviceInfo.hardwareName;
                        hardwareVersion = TUCConfigManagerController.convertRevisionToString(deviceInfo.hardwareRevision);
                        serialNumber = deviceInfo.serialNumber;
                    }
                    catch (CommConnectionException e) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(this.model.getDeviceInformation() + " Unable to get device info from " + ((Device)device).getInetAddress().getHostAddress());
                        }
                        firmwareVersion = "0.0";
                        if (hardwareVersion.equals("00.00")) {
                            hardwareVersion = "02.00";
                        }
                        ipAddress = ((Device)device).getInetAddress().getHostAddress();
                    }
                    finally {
                        try {
                            connection.disconnect();
                        }
                        catch (CommConnectionException commConnectionException) {}
                    }
                } else if (null == this.model.getTucDevice()) {
                    name = "Unknown - device not reachable";
                    firmwareName = "TUC2";
                    firmwareVersion = ">= 02.00";
                    hardwareName = "TUC2";
                    hardwareVersion = ">= 02.00";
                    ipAddress = "unknown";
                }
            }
            this.model.setInfo(new DeviceInfo(name, firmwareName, firmwareVersion, hardwareName, hardwareVersion, ipAddress, macAddress, serialNumber));
            this.model.updateModel();
            return null;
        }
    }

    private class ScanUpnpDevicesTaskEventHandler
    implements EventHandler<WorkerStateEvent> {
        private ScanUpnpDevicesTaskEventHandler() {
        }

        public void handle(WorkerStateEvent e) {
            Worker scanUpnpDevicesTask = e.getSource();
            EventType type = e.getEventType();
            if (type.equals(WorkerStateEvent.WORKER_STATE_SCHEDULED)) {
                upnpDevices = null;
            } else if (!type.equals(WorkerStateEvent.WORKER_STATE_SUCCEEDED)) {
                TUCConfigManagerController.this.infoMessage.setText("An error occurred. Please try again later.");
                Exception ex = (Exception)scanUpnpDevicesTask.getException();
                AlertDialog.showException(ex);
            }
        }
    }

    private static class ScanUpnpDevicesTask
    extends Task<Void> {
        private ScanUpnpDevicesTask() {
        }

        protected Void call() throws IOException, InterruptedException, ParserConfigurationException, SAXException, UnknownHostException {
            Discovery discovery = new Discovery(3000, DEFAULT_SEARCH_TARGETS);
            discovery.setIpv6Enabled(true);
            upnpDevices = discovery.discover();
            return null;
        }
    }

    private class ScanDevicesTaskEventHandler
    implements EventHandler<WorkerStateEvent> {
        private ScanDevicesTaskEventHandler() {
        }

        public void handle(WorkerStateEvent event) {
            Worker scanDevicesTask = event.getSource();
            EventType type = event.getEventType();
            if (type.equals(WorkerStateEvent.WORKER_STATE_SCHEDULED)) {
                TUCConfigManagerController.this.resetLabels();
                TUCConfigManagerController.this.tableView.setItems(null);
                TUCConfigManagerController.this.scanButton.setDisable(true);
                TUCConfigManagerController.this.tableView.setDisable(true);
                TUCConfigManagerController.this.infoMessage.setText("Looking for TUC Devices...");
                TUCConfigManagerController.this.tableView.getSelectionModel().clearSelection();
                TUCConfigManagerController.this.deviceModels.clear();
                TUCConfigManagerController.this.deviceInfoByIp.clear();
                TUCConfigManagerController.this.devices.clear();
            } else if (type.equals(WorkerStateEvent.WORKER_STATE_SUCCEEDED)) {
                TUCConfigManagerController.this.devices = (List)scanDevicesTask.getValue();
                TUCConfigManagerController.this.populateTUCDeviceModels(TUCConfigManagerController.this.devices);
                try {
                    TUCConfigManagerController.this.upnpThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                TUCConfigManagerController.this.populateTUCUpnpModels(upnpDevices);
                TUCConfigManagerController.this.deviceModels.sort(null);
                ObservableList data = FXCollections.observableArrayList(TUCConfigManagerController.this.deviceModels);
                TUCConfigManagerController.this.deviceIPCol.setCellValueFactory((Callback)new PropertyValueFactory("ipAddress"));
                TUCConfigManagerController.this.deviceNameCol.setCellValueFactory((Callback)new PropertyValueFactory("name"));
                TUCConfigManagerController.this.tableView.setItems(data);
                TUCConfigManagerController.this.scanButton.setDisable(false);
                TUCConfigManagerController.this.tableView.setDisable(false);
                TUCConfigManagerController.this.infoMessage.setText("Found " + TUCConfigManagerController.this.deviceModels.size() + " devices.");
            } else {
                TUCConfigManagerController.this.scanButton.setDisable(false);
                TUCConfigManagerController.this.tableView.setDisable(true);
                TUCConfigManagerController.this.infoMessage.setText("An error occurred. Please try again later.");
                Exception ex = (Exception)scanDevicesTask.getException();
                AlertDialog.showException(ex);
            }
        }
    }

    private static class ScanDevicesTask
    extends Task<List<TUCDevice>> {
        private ScanDevicesTask() {
        }

        protected List<TUCDevice> call() throws IOException, InterruptedException {
            return TUCManager.scanDevices((int)3000);
        }
    }
}

