/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.tuc.manager.control;

import com.metratec.lib.tuc.TUCException;
import com.metratec.lib.tuc.handler.TUCUDPControl;
import com.metratec.lib.tuc.types.TUCDevice;
import com.metratec.lib.upnp.Device;
import com.metratec.tuc.manager.DeviceInfo;
import com.metratec.tuc.manager.TUCConfigManager;
import com.metratec.tuc.manager.TUCConfigManagerException;
import com.metratec.tuc.manager.TUCDeviceModel;
import com.metratec.tuc.manager.control.TUCConfigManagerController;
import com.metratec.tuc.manager.utils.AlertDialog;
import com.metratec.tuc.manager.widget.DeviceInfoGridPane;
import com.metratec.tuc.manager.widget.IPHBox;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;

public class OverviewPaneController
implements Initializable {
    private static final int additionalWaitTimeTUC2 = 2000;
    private static final int waitingTimeRestartDHCP = 6500;
    private static final int waitingTimeRestartStatic = 4500;
    private static final String password = "tucadmin";
    @FXML
    private Label overviewLabel;
    @FXML
    private DeviceInfoGridPane overviewInfoPane;
    @FXML
    private ProgressBar overviewProgress;
    @FXML
    private GridPane overviewSettingsPane;
    @FXML
    private GridPane overviewSettingsSubPane;
    @FXML
    private ChoiceBox<String> addressType;
    @FXML
    private IPHBox ip;
    @FXML
    private IPHBox mask;
    @FXML
    private IPHBox gateway;
    @FXML
    private Button buttonUpdateIPSettings;
    @FXML
    private Label overviewTabWarn;
    private TUCDeviceModel device;
    private TUCConfigManagerController parentController;
    private Logger logger = TUCConfigManager.getLogger();

    public void initialize(URL url, ResourceBundle rb) {
        this.mask.setMaxValue(255);
        this.addressType.setItems(FXCollections.observableArrayList((Object[])new String[]{"Static IP", "DHCP/Auto IP"}));
        this.addressType.getSelectionModel().selectedItemProperty().addListener((ov, oldVal, newVal) -> this.onAddressTypeChanged());
    }

    protected void setParentController(TUCConfigManagerController parentController) {
        this.parentController = parentController;
    }

    protected void setActiveDevice(TUCDeviceModel activeDevice) {
        this.device = activeDevice;
        this.updateLabels(this.device.getInfo());
    }

    private void updateLabels(DeviceInfo info) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(info.getIpAddress() + " update labels");
        }
        this.overviewInfoPane.setDisable(false);
        this.addressType.setDisable(false);
        this.buttonUpdateIPSettings.setDisable(false);
        this.overviewSettingsPane.setDisable(false);
        this.overviewInfoPane.updateLabels(info);
        if (null != this.device.getTucDevice()) {
            TUCDevice tuc = this.device.getTucDevice();
            this.addressType.setDisable(false);
            this.ip.setDisable(false);
            this.mask.setDisable(false);
            this.gateway.setDisable(false);
            this.buttonUpdateIPSettings.setDisable(false);
            this.overviewTabWarn.setVisible(tuc.isBootloader());
            if (tuc.isDHCP()) {
                this.addressType.setValue((Object)"DHCP/Auto IP");
            } else {
                this.addressType.setValue((Object)"Static IP");
            }
            this.ip.setValue(tuc.getIP());
            this.mask.setValue(tuc.getSubnetMask());
            this.gateway.setValue(tuc.getGateway());
        } else {
            Device tuc = this.device.getTucUpnpDevice();
            this.addressType.setDisable(true);
            this.ip.setDisable(true);
            this.mask.setDisable(true);
            this.gateway.setDisable(true);
            this.buttonUpdateIPSettings.setDisable(true);
            this.overviewTabWarn.setVisible(false);
            this.addressType.setValue((Object)"Unknown");
            this.ip.setValue(tuc.getInetAddress().getAddress());
            this.mask.setValue(new byte[]{0, 0, 0, 0});
            this.gateway.setValue(new byte[]{0, 0, 0, 0});
        }
    }

    protected void resetLabels() {
        this.overviewInfoPane.setDisable(true);
        this.addressType.setDisable(true);
        this.buttonUpdateIPSettings.setDisable(true);
        this.overviewSettingsPane.setDisable(true);
        this.overviewInfoPane.resetLabels();
        this.ip.reset();
        this.mask.reset();
        this.gateway.reset();
        this.overviewTabWarn.setVisible(false);
    }

    private boolean isDHCPSelected() {
        return "DHCP/Auto IP".equals(this.addressType.getValue());
    }

    private void onAddressTypeChanged() {
        if ("DHCP/Auto IP".equals(this.addressType.getSelectionModel().getSelectedItem())) {
            this.overviewSettingsSubPane.setDisable(true);
        } else {
            this.overviewSettingsSubPane.setDisable(false);
        }
    }

    @FXML
    private void updateIPSettings(ActionEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.device.getDeviceInformation() + " updateIPSettings");
        }
        try {
            TUCDevice tucDevice = this.device.getTucDevice();
            if (this.ip.getAddress().equals("0.0.0.0")) {
                throw new TUCConfigManagerException("IP address can not be 0.0.0.0");
            }
            InetAddress newIp = InetAddress.getByAddress(this.ip.getValue());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.device.getDeviceInformation() + " updateIPSettings check reachable");
            }
            if (tucDevice.getInetAddress().equals(newIp) || !newIp.isReachable(250)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.device.getDeviceInformation() + " updateIPSettings reachable");
                }
                this.buttonUpdateIPSettings.setDisable(true);
                if (!tucDevice.isBootloader()) {
                    long restartTime;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(this.device.getDeviceInformation() + "update ip setting " + tucDevice.getIPAddress() + " to " + (String)(this.isDHCPSelected() ? "dhcp" : this.ip.getAddress() + "," + this.mask.getAddress() + "," + this.gateway.getAddress()));
                    }
                    long l = restartTime = tucDevice.isDHCP() ? 6500L : 4500L;
                    if (null != this.device.getTucUpnpDevice()) {
                        restartTime += 2000L;
                    }
                    UpdateIPSettingsTask task = new UpdateIPSettingsTask(tucDevice, this.isDHCPSelected(), this.ip.getValue(), this.mask.getValue(), this.gateway.getValue(), restartTime);
                    UpdateIPSettingsTaskEventHandler handler = new UpdateIPSettingsTaskEventHandler();
                    task.setOnFailed(handler);
                    task.setOnSucceeded(handler);
                    this.overviewLabel.textProperty().bind((ObservableValue)task.messageProperty());
                    this.overviewProgress.progressProperty().bind((ObservableValue)task.progressProperty());
                    this.parentController.onIpUpdateStarted();
                    Thread th = new Thread((Runnable)((Object)task));
                    th.setDaemon(true);
                    th.start();
                } else {
                    AlertDialog.showAlert("Success.", "Successfully updated the IP Settings.", Alert.AlertType.INFORMATION);
                    this.buttonUpdateIPSettings.setDisable(false);
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.device.getDeviceInformation() + "error update ip setting " + tucDevice.getIPAddress() + " to " + (String)(this.isDHCPSelected() ? "dhcp" : this.ip.getAddress() + "," + this.mask.getAddress() + "," + this.gateway.getAddress()) + " - ip address is in use");
                }
                AlertDialog.showAlert("Failed.", "The IP address is already in use.", Alert.AlertType.WARNING);
            }
        }
        catch (Exception ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.device.getDeviceInformation() + "error update ip setting " + this.device.getTucDevice().getIPAddress() + " to " + (String)(this.isDHCPSelected() ? "dhcp" : this.ip.getAddress() + "," + this.mask.getAddress() + "," + this.gateway.getAddress()) + " - " + ex.toString());
            }
            AlertDialog.showException(ex);
        }
    }

    private class UpdateIPSettingsTaskEventHandler
    implements EventHandler<WorkerStateEvent> {
        private UpdateIPSettingsTaskEventHandler() {
        }

        public void handle(WorkerStateEvent e) {
            if (OverviewPaneController.this.logger.isDebugEnabled()) {
                OverviewPaneController.this.logger.debug(OverviewPaneController.this.device.getDeviceInformation() + "UpdateIPSettingsTaskEventHandler ");
            }
            Worker updateIPSettingsTask = e.getSource();
            EventType type = e.getEventType();
            OverviewPaneController.this.overviewLabel.textProperty().unbind();
            OverviewPaneController.this.overviewLabel.setText("");
            OverviewPaneController.this.overviewProgress.progressProperty().unbind();
            OverviewPaneController.this.overviewProgress.setProgress(0.0);
            OverviewPaneController.this.parentController.onIpUpdateCompleted();
            if (type.equals(WorkerStateEvent.WORKER_STATE_SUCCEEDED)) {
                OverviewPaneController.this.device.setInfo(null);
                OverviewPaneController.this.buttonUpdateIPSettings.setDisable(false);
                AlertDialog.showAlert("Success.", "Successfully updated the IP Settings.", Alert.AlertType.INFORMATION);
                OverviewPaneController.this.parentController.onSelectionChanged();
            } else {
                OverviewPaneController.this.buttonUpdateIPSettings.setDisable(false);
                Exception ex = (Exception)updateIPSettingsTask.getException();
                if (OverviewPaneController.this.logger.isDebugEnabled()) {
                    OverviewPaneController.this.logger.debug(OverviewPaneController.this.device.getDeviceInformation() + "error update ip setting " + OverviewPaneController.this.device.getTucDevice().getIPAddress() + " to " + (String)(OverviewPaneController.this.isDHCPSelected() ? "dhcp" : OverviewPaneController.this.ip.getAddress() + "," + OverviewPaneController.this.mask.getAddress() + "," + OverviewPaneController.this.gateway.getAddress() + " - " + ex.getMessage()));
                }
                AlertDialog.showException(new TUCConfigManagerException("Error setting the ip address  - please check the configuration", ex));
            }
        }
    }

    private static class UpdateIPSettingsTask
    extends Task<Void> {
        private TUCDevice tucDevice;
        private boolean isDHCP;
        private byte[] newIp;
        private byte[] newSubnet;
        private byte[] newGateway;
        private long restartTime;
        private Logger logger = TUCConfigManager.getLogger();

        UpdateIPSettingsTask(TUCDevice tuc, boolean isDHCP, byte[] newIp, byte[] newSubnet, byte[] newGateway, long restartTime) {
            this.tucDevice = tuc;
            this.isDHCP = isDHCP;
            this.newIp = newIp;
            this.newSubnet = newSubnet;
            this.newGateway = newGateway;
            this.restartTime = restartTime;
        }

        protected Void call() throws TUCException, IOException, InterruptedException {
            int i;
            this.updateMessage("Updating IP settings for: " + this.tucDevice.toString());
            this.updateProgress(-1L, 0L);
            TUCUDPControl control = new TUCUDPControl(this.tucDevice);
            control.setTimeout(2000);
            control.setPassword(OverviewPaneController.password);
            if (this.isDHCP) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.tucDevice.toString() + " UpdateIPSettingsTask configIPAddressDHCP");
                }
                control.configIPAddressDHCP();
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.tucDevice.toString() + " UpdateIPSettingsTask configIPAddressStatic");
                }
                control.configIPAddressStatic(this.newIp, this.newSubnet, this.newGateway);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.tucDevice.toString() + " UpdateIPSettingsTask wait");
            }
            this.updateMessage("Waiting for device to restart");
            this.updateProgress(0L, 50L);
            long sleepTime = this.restartTime / 50L;
            for (i = 1; i <= 50; ++i) {
                Thread.sleep(sleepTime);
                this.updateProgress(i, 50L);
            }
            this.updateMessage("Try to reach the device");
            this.updateProgress(-1L, 50L);
            for (i = 1; i <= 3; ++i) {
                try {
                    control.updateTUCDevice();
                    control.addTUCSetting();
                    return null;
                }
                catch (TUCException | IOException e) {
                    if (i != 3) continue;
                    throw e;
                }
            }
            return null;
        }
    }
}

