/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.tuc.manager.control;

import com.metratec.lib.METJFlash.METJFlash;
import com.metratec.lib.METJFlash.ReleaseArchive;
import com.metratec.lib.METJFlash.UserInterface;
import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import com.metratec.lib.connection.TcpConnection;
import com.metratec.lib.tuc.TUCException;
import com.metratec.lib.tuc.handler.TUCUDPControl;
import com.metratec.lib.tuc.types.TUCDevice;
import com.metratec.lib.tuc.update.CallbackInterface;
import com.metratec.lib.tuc.update.FirmwareInformation;
import com.metratec.lib.tuc.update.Flash;
import com.metratec.lib.tuc.update.FlashException;
import com.metratec.lib.upnp.Device;
import com.metratec.tuc.manager.DeviceInfo;
import com.metratec.tuc.manager.TUCConfigManager;
import com.metratec.tuc.manager.TUCConfigManagerException;
import com.metratec.tuc.manager.TUCDeviceModel;
import com.metratec.tuc.manager.control.TUCConfigManagerController;
import com.metratec.tuc.manager.utils.AlertDialog;
import com.metratec.tuc.manager.widget.DeviceInfoGridPane;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import org.slf4j.Logger;

public class FirmwareUpdatePaneController
implements Initializable {
    @FXML
    private Label updateLabel;
    @FXML
    private Label updateTabWarn;
    @FXML
    private TextField firmwareFilePath;
    @FXML
    private Button startUpdateButton;
    @FXML
    private Button cancelUpdateButton;
    @FXML
    private ProgressBar updateProgress;
    @FXML
    private DeviceInfoGridPane deviceInfoPane;
    @FXML
    private GridPane firmwareDetailsPane;
    @FXML
    private Label firmwareName;
    @FXML
    private Label firmwareRevision;
    @FXML
    private Label hardwareName;
    @FXML
    private Label hardwareRevision;
    private Thread firmwareUpdateThread;
    private TUCDeviceModel activeDevice;
    private boolean isTuc2 = false;
    private TUCConfigManagerController parentController;
    private Logger logger = TUCConfigManager.getLogger();

    public void initialize(URL url, ResourceBundle rb) {
    }

    protected void setParentController(TUCConfigManagerController parentController) {
        this.parentController = parentController;
    }

    protected void setActiveDevice(TUCDeviceModel activeDevice) {
        this.activeDevice = activeDevice;
        this.isTuc2 = activeDevice.getInfo().getHardwareVersion().startsWith("02");
        this.updateLabels(activeDevice.getInfo());
    }

    private void updateLabels(DeviceInfo info) {
        this.deviceInfoPane.setDisable(false);
        this.startUpdateButton.setDisable(this.firmwareDetailsPane.isDisable());
        this.deviceInfoPane.updateLabels(info);
        if (this.activeDevice.getTucDevice() != null) {
            this.updateTabWarn.setVisible(this.activeDevice.getTucDevice().isBootloader());
        }
        if (!this.firmwareFilePath.getText().isEmpty()) {
            try {
                this.checkTucFirmwareFile();
                this.startUpdateButton.setDisable(false);
                this.firmwareDetailsPane.setDisable(false);
            }
            catch (TUCConfigManagerException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.activeDevice.getDeviceInformation() + " Wrong firmware file loaded " + e.getMessage());
                }
                this.startUpdateButton.setDisable(true);
                this.firmwareDetailsPane.setDisable(true);
            }
        } else {
            this.startUpdateButton.setDisable(true);
            this.firmwareDetailsPane.setDisable(true);
        }
    }

    protected void resetLabels() {
        this.deviceInfoPane.setDisable(true);
        this.startUpdateButton.setDisable(true);
        this.updateLabel.textProperty().unbind();
        this.updateLabel.setText("");
        this.deviceInfoPane.resetLabels();
        this.updateTabWarn.setVisible(false);
    }

    private void setFirmwareInfo(FirmwareInformation fInfo) {
        this.firmwareRevision.setText(TUCConfigManagerController.convertRevisionToString(fInfo.getFirmwareRevision()));
        this.hardwareRevision.setText(TUCConfigManagerController.convertRevisionToString(fInfo.getHardwareReqRevision()));
        this.firmwareName.setText(fInfo.getFirmwareName());
        this.hardwareName.setText(fInfo.getHardwareReqName());
    }

    private void setFirmwareInfo(METJFlash fInfo) {
        if (!fInfo.isLoaded()) {
            this.firmwareName.setText("");
            this.firmwareRevision.setText("");
            this.hardwareName.setText("");
            this.hardwareRevision.setText("");
        } else {
            this.firmwareName.setText(fInfo.getFirmwareName());
            this.firmwareRevision.setText(null != fInfo.getFirmwareRevision() ? TUCConfigManagerController.convertRevisionToString(fInfo.getFirmwareRevision()) : "---");
            this.hardwareName.setText(fInfo.getHardwareName());
            this.hardwareRevision.setText(null != fInfo.getHardwareRevision() ? TUCConfigManagerController.convertRevisionToString(fInfo.getHardwareRevision()) : "---");
        }
    }

    @FXML
    private void onOpenFileClicked(ActionEvent event) {
        if (this.isTuc2) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Open Firmware File");
            fileChooser.setInitialDirectory(TUCConfigManager.getConfig().getWorkingDirOrDefault());
            fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("TUC Firmware", new String[]{"*.metj", "*.zip"}), new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
            File file = fileChooser.showOpenDialog(null);
            if (file != null) {
                this.firmwareFilePath.setText(file.getPath());
                TUCConfigManager.getConfig().setWorkingDir(file.getParentFile());
                try {
                    this.checkTucFirmwareFile();
                    this.startUpdateButton.setDisable(false);
                    this.firmwareDetailsPane.setDisable(false);
                }
                catch (Exception ex) {
                    this.startUpdateButton.setDisable(true);
                    this.firmwareDetailsPane.setDisable(true);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(this.activeDevice.getDeviceInformation() + " Error load firmware file " + file.getAbsolutePath() + " - " + ex.getMessage());
                    }
                    AlertDialog.showAlert("Problem with firmware file.", ex.getMessage(), Alert.AlertType.INFORMATION);
                }
            }
        } else {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Open Firmware File");
            fileChooser.setInitialDirectory(TUCConfigManager.getConfig().getWorkingDirOrDefault());
            fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("TUC Firmware", new String[]{"*.bin"}), new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
            File file = fileChooser.showOpenDialog(null);
            if (file != null) {
                this.firmwareFilePath.setText(file.getPath());
                TUCConfigManager.getConfig().setWorkingDir(file.getParentFile());
                try {
                    this.checkTucFirmwareFile();
                    this.startUpdateButton.setDisable(false);
                    this.firmwareDetailsPane.setDisable(false);
                }
                catch (Exception ex) {
                    this.startUpdateButton.setDisable(true);
                    this.firmwareDetailsPane.setDisable(true);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(this.activeDevice.getDeviceInformation() + " Error load firmware file " + file.getAbsolutePath() + " - " + ex.getMessage());
                    }
                    AlertDialog.showAlert("Problem with firmware file.", ex.getMessage(), Alert.AlertType.INFORMATION);
                }
            }
        }
    }

    private void checkTucFirmwareFile() throws TUCConfigManagerException {
        block18: {
            if (this.isTuc2) {
                try {
                    InputStream metjStream;
                    File file = this.getFirmwareFile();
                    if (file.getName().toLowerCase().endsWith(".zip")) {
                        ReleaseArchive archive = new ReleaseArchive(file);
                        metjStream = archive.getMetj();
                    } else {
                        metjStream = new FileInputStream(file);
                    }
                    METJFlash flash = new METJFlash();
                    flash.load(metjStream);
                    this.setFirmwareInfo(flash);
                }
                catch (Exception e) {
                    throw new TUCConfigManagerException("Wrong firmware file " + this.getFirmwareFile().getName() + "\n(" + e.getMessage() + ")", e);
                }
                if (null == this.activeDevice.getInfo().getHardwareName()) {
                    throw new TUCConfigManagerException("TUC is not reachable and cannot be updated.");
                }
                if (!this.activeDevice.getInfo().getHardwareName().isEmpty() && !this.hardwareName.getText().equals(this.activeDevice.getInfo().getHardwareName())) {
                    throw new TUCConfigManagerException("Wrong firmware file. Firmware for hardware " + this.hardwareName.getText() + "expected.");
                }
                if (Double.valueOf(this.hardwareRevision.getText()) > Double.valueOf(this.activeDevice.getInfo().getHardwareVersion())) {
                    throw new TUCConfigManagerException("Wrong firmware file. Firmware is only for hardware version " + this.hardwareRevision.getText() + " and higher.");
                }
                if (TUCConfigManager.getConfig().getTuc2().getCompareFirmwareNameOrDefault().booleanValue() && !this.activeDevice.getInfo().getFirmwareName().isEmpty() && !this.activeDevice.getInfo().getFirmwareName().trim().equals(this.firmwareName.getText().trim())) {
                    throw new TUCConfigManagerException("Wrong firmware name. '" + this.activeDevice.getInfo().getFirmwareName() + "' expected.");
                }
                if (null == this.activeDevice.getTucUpnpDevice()) {
                    throw new TUCConfigManagerException("TUC must be reachable for the update");
                }
            } else {
                try {
                    FirmwareInformation fInfo = FirmwareInformation.getFirmwareFileInformation((File)this.getFirmwareFile());
                    this.setFirmwareInfo(fInfo);
                }
                catch (Exception e) {
                    throw new TUCConfigManagerException("Wrong firmware file " + this.getFirmwareFile().getName() + "\n(" + e.getMessage() + ")", e);
                }
                if (this.firmwareName.getText().startsWith("TCP_UART_CONV")) {
                    double href = Double.valueOf(this.hardwareRevision.getText());
                    try {
                        if (href >= 2.0 || href > Double.valueOf(this.activeDevice.getInfo().getHardwareVersion())) {
                            throw new TUCConfigManagerException("Wrong firmware file. Firmware for Hardware Version " + this.activeDevice.getInfo().getHardwareVersion() + " needed.");
                        }
                        break block18;
                    }
                    catch (NumberFormatException e) {
                        if (!this.activeDevice.getInfo().getName().equals("TUC Bootloader") || this.activeDevice.getInfo().getFirmwareName().equals("TUC Bootloader")) {
                            throw e;
                        }
                        break block18;
                    }
                }
                throw new TUCConfigManagerException("Wrong firmware file. Firmware Name TUC expected.");
            }
        }
    }

    private File getFirmwareFile() {
        return new File(this.firmwareFilePath.getText());
    }

    @FXML
    private void startUpdate(ActionEvent event) throws UnknownHostException {
        try {
            this.checkTucFirmwareFile();
            this.startUpdateButton.setDisable(false);
            this.firmwareDetailsPane.setDisable(false);
        }
        catch (Exception ex) {
            this.startUpdateButton.setDisable(true);
            this.firmwareDetailsPane.setDisable(true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.activeDevice.getDeviceInformation() + " Error load firmware file " + this.getFirmwareFile().getName() + " - " + ex.getMessage());
            }
            AlertDialog.showAlert("Problem with firmware file.", ex.getMessage(), Alert.AlertType.INFORMATION);
            return;
        }
        Task task = this.isTuc2 ? new Tuc2FirmwareUpdateTask(this.activeDevice.getTucUpnpDevice(), this.getFirmwareFile().getAbsolutePath()) : new TucFirmwareUpdateTask(this.activeDevice.getTucDevice(), this.getFirmwareFile().getAbsolutePath());
        FirmwareUpdateTaskEventHandler handler = new FirmwareUpdateTaskEventHandler();
        task.setOnFailed((EventHandler)handler);
        task.setOnSucceeded((EventHandler)handler);
        this.updateProgress.progressProperty().bind((ObservableValue)task.progressProperty());
        this.updateLabel.textProperty().bind((ObservableValue)task.messageProperty());
        this.startUpdateButton.setVisible(false);
        this.startUpdateButton.setDisable(true);
        this.cancelUpdateButton.setVisible(true);
        this.cancelUpdateButton.setDisable(false);
        this.parentController.onFirmwareUpdateStarted();
        this.firmwareUpdateThread = new Thread((Runnable)task);
        this.firmwareUpdateThread.setDaemon(true);
        this.firmwareUpdateThread.start();
    }

    @FXML
    private void cancelUpdate(ActionEvent event) {
        boolean result = AlertDialog.showConfirmation("Cancel Firmware Update", "Are you sure you want to cancel the Firmware Update?");
        if (result) {
            this.firmwareUpdateThread.interrupt();
        }
    }

    private class FirmwareUpdateTaskEventHandler
    implements EventHandler<WorkerStateEvent> {
        private FirmwareUpdateTaskEventHandler() {
        }

        public void handle(WorkerStateEvent e) {
            Worker firmwareUpdateTask = e.getSource();
            EventType type = e.getEventType();
            if (type.equals(WorkerStateEvent.WORKER_STATE_SUCCEEDED)) {
                AlertDialog.showAlert("Update success.", "Successfully updated the firmware.", Alert.AlertType.INFORMATION);
            } else {
                Exception ex = (Exception)firmwareUpdateTask.getException();
                FirmwareUpdatePaneController.this.logger.warn(FirmwareUpdatePaneController.this.activeDevice.getDeviceInformation() + " " + ex.getMessage(), (Object)e);
                if (ex instanceof InterruptedException) {
                    AlertDialog.showAlert("Cancelled.", "Firmware update process was interrupted.", Alert.AlertType.INFORMATION);
                } else if (ex instanceof CommConnectionException) {
                    CommConnectionException ce = (CommConnectionException)ex;
                    if (ce.getErrorCode() == 49) {
                        AlertDialog.showAlert("Update problem", "TUC is not reachable. Please check the connection settings.", Alert.AlertType.WARNING);
                    } else {
                        AlertDialog.showException(new TUCConfigManagerException(ce.getErrorDescription(), (Throwable)ce));
                    }
                } else {
                    AlertDialog.showException(ex);
                }
            }
            FirmwareUpdatePaneController.this.updateLabel.textProperty().unbind();
            FirmwareUpdatePaneController.this.updateLabel.setText("");
            FirmwareUpdatePaneController.this.updateProgress.progressProperty().unbind();
            FirmwareUpdatePaneController.this.updateProgress.setProgress(0.0);
            FirmwareUpdatePaneController.this.startUpdateButton.setVisible(true);
            FirmwareUpdatePaneController.this.startUpdateButton.setDisable(false);
            FirmwareUpdatePaneController.this.cancelUpdateButton.setVisible(false);
            FirmwareUpdatePaneController.this.cancelUpdateButton.setDisable(true);
            FirmwareUpdatePaneController.this.parentController.onFirmwareUpdateCompleted();
        }
    }

    private class Tuc2FirmwareUpdateTask
    extends Task<Void>
    implements UserInterface {
        private String firmware;
        private Device tuc;

        public Tuc2FirmwareUpdateTask(Device tuc, String firmware) {
            this.firmware = firmware;
            this.tuc = tuc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void call() throws Exception {
            InputStream metjStream;
            TcpConnection connection = new TcpConnection(this.tuc.getInetAddress().getHostAddress(), 40001);
            connection.connect();
            if (this.firmware.toLowerCase().endsWith(".zip")) {
                ReleaseArchive archive = new ReleaseArchive(new File(this.firmware));
                metjStream = archive.getMetj();
            } else {
                metjStream = new FileInputStream(this.firmware);
            }
            METJFlash flash = new METJFlash();
            flash.load(metjStream);
            FirmwareUpdatePaneController.this.setFirmwareInfo(flash);
            flash.setConnection((ICommConnection)connection);
            try {
                flash.flash(this);
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
            }
            finally {
                Thread.interrupted();
                flash.getConnection().disconnect();
            }
            if (FirmwareUpdatePaneController.this.logger.isDebugEnabled()) {
                FirmwareUpdatePaneController.this.logger.debug(FirmwareUpdatePaneController.this.activeDevice.getDeviceInformation() + " FirmwareUpdateTask wait");
            }
            this.updateMessage("Waiting for the device to restart");
            this.updateProgress(1.0, 2.0);
            long waitTime = 12000L;
            long startTime = System.currentTimeMillis();
            long waitUntil = startTime + waitTime;
            while (System.currentTimeMillis() < waitUntil) {
                this.updateProgress(1.0 + (double)(System.currentTimeMillis() - startTime) / (double)waitTime, 2.0);
                Thread.sleep(10L);
            }
            this.updateMessage("Try to reach the device");
            this.updateProgress(-1L, 100L);
            int i = 4;
            while (--i >= 0) {
                try {
                    this.tuc.updateDevice();
                    FirmwareUpdatePaneController.this.parentController.updateSelectedDevice();
                    return null;
                }
                catch (Exception e) {
                    if (i == 0 || InterruptedException.class.isInstance(e)) {
                        throw e;
                    }
                    ++i;
                }
            }
            return null;
        }

        @Override
        public void initializingBootloader() {
            this.updateProgress(-1.0, 1.0);
            this.updateMessage("Initializing bootloader...");
        }

        @Override
        public void initializedBootloader() {
        }

        @Override
        public boolean sendingMetlet(int current, int max) {
            this.updateProgress(((double)current - 1.0) / (double)max, 2.0);
            this.updateMessage("Sending metlet " + current + " of " + max + "...");
            return Thread.currentThread().isInterrupted();
        }

        @Override
        public void retryingMetlet() {
            this.updateMessage("Retrying metlet...");
        }

        @Override
        public void flushingRecvBuffer() {
            this.updateProgress(-1.0, 0.0);
            this.updateMessage("Flushing receive buffer...");
        }

        @Override
        public void flushedRecvBuffer() {
        }
    }

    private class TucFirmwareUpdateTask
    extends Task<Void>
    implements CallbackInterface {
        private TUCDevice device;
        private String firmwareFile;

        TucFirmwareUpdateTask(TUCDevice tuc, String firmware) {
            this.device = tuc;
            this.firmwareFile = firmware;
        }

        protected Void call() throws TUCException, FlashException, IOException, CommConnectionException, InterruptedException, TUCConfigManagerException {
            this.updateMessage("Updating Firmware...");
            TUCDevice tucDevice = FirmwareUpdatePaneController.this.activeDevice.getTucDevice();
            InetAddress assignIP = tucDevice.isBootloader() ? InetAddress.getByAddress(tucDevice.getIP()) : tucDevice.getInetAddress();
            String ipAddress = assignIP.getHostAddress();
            String macAddress = tucDevice.getMacAddressString();
            String localAddress = tucDevice.getLocalHost().getHostAddress();
            FirmwareInformation fInfo = FirmwareInformation.getFirmwareFileInformation((File)new File(this.firmwareFile));
            FirmwareUpdatePaneController.this.setFirmwareInfo(fInfo);
            Flash fl = new Flash((CallbackInterface)this, ipAddress, macAddress, localAddress, this.firmwareFile);
            fl.flashFirmware();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.updateProgress(-1L, 0L);
            this.updateMessage("Trying to ping the device...");
            this.pingDevice();
            this.updateMessage("Success");
            return null;
        }

        private void pingDevice() throws TUCException, IOException {
            for (int i = 0; i <= 4; ++i) {
                try {
                    TUCUDPControl control = new TUCUDPControl(this.device);
                    control.setTimeout(2000);
                    control.updateTUCDevice();
                    FirmwareUpdatePaneController.this.parentController.updateSelectedDevice();
                    break;
                }
                catch (TUCException | IOException ex) {
                    if (i < 4) continue;
                    throw ex;
                }
            }
        }

        public void showProgress(int progress) {
            this.updateProgress(progress, 100L);
        }

        public void showMessage(String message) {
            this.updateMessage(message);
        }

        public boolean gotCancelled() {
            return Thread.currentThread().isInterrupted();
        }
    }
}

