/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.tuc.manager;

import com.metratec.lib.tuc.types.TUCDevice;
import com.metratec.lib.upnp.Device;
import com.metratec.tuc.manager.DeviceInfo;
import com.metratec.tuc.manager.TUCConfigManager;
import java.io.IOException;
import java.net.InetAddress;
import javafx.beans.property.SimpleStringProperty;

public class TUCDeviceModel
implements Comparable<TUCDeviceModel> {
    private TUCDevice tucDevice;
    private Device tucUpnpDevice;
    private boolean reachable = false;
    private DeviceInfo info;
    private SimpleStringProperty name = new SimpleStringProperty();
    private SimpleStringProperty ipAddress = new SimpleStringProperty();

    public TUCDeviceModel(TUCDevice tucDevice) {
        this.setTucDevice(tucDevice);
    }

    public TUCDeviceModel(Device tucUpnp) {
        this.setTucUpnpDevice(tucUpnp);
    }

    private String inetAddressToString(InetAddress addr) {
        String ret = "Unassigned IP";
        if (null != addr && !addr.isAnyLocalAddress()) {
            ret = addr.getHostAddress();
        }
        return ret;
    }

    public void updateModel() {
        try {
            if (this.tucDevice != null) {
                this.setReachable(this.tucDevice.getInetAddress().isReachable(200));
                this.name.set(this.tucDevice.getName());
                this.ipAddress.set(this.inetAddressToString(this.tucDevice.getInetAddress()));
            } else if (this.tucUpnpDevice != null) {
                this.setReachable(this.tucUpnpDevice.getInetAddress().isReachable(200));
                if (this.isReachable()) {
                    this.name.set(this.tucUpnpDevice.getDescription().getFriendlyName());
                } else {
                    this.name.set("unknown");
                }
                this.ipAddress.set(this.inetAddressToString(this.tucUpnpDevice.getInetAddress()));
            }
            if (TUCConfigManager.getLogger().isDebugEnabled()) {
                TUCConfigManager.getLogger().debug(this.name.getValue() + " reachable: " + this.isReachable());
            }
        }
        catch (IOException e) {
            TUCConfigManager.getLogger().warn(e.getMessage(), (Throwable)e);
        }
    }

    public SimpleStringProperty nameProperty() {
        return this.name;
    }

    public SimpleStringProperty ipAddressProperty() {
        return this.ipAddress;
    }

    public TUCDevice getTucDevice() {
        return this.tucDevice;
    }

    public void setTucDevice(TUCDevice tucDevice) {
        this.tucDevice = tucDevice;
        this.updateModel();
    }

    public Device getTucUpnpDevice() {
        return this.tucUpnpDevice;
    }

    public void setTucUpnpDevice(Device tucUpnpDevice) {
        this.tucUpnpDevice = tucUpnpDevice;
        this.updateModel();
    }

    public boolean equals(Object obj) {
        if (TUCDevice.class.isInstance(obj)) {
            if (null != this.getTucDevice()) {
                return this.getTucDevice().equals(obj);
            }
            return this.getTucUpnpDevice().getInetAddress().equals(((TUCDevice)obj).getInetAddress());
        }
        if (Device.class.isInstance(obj)) {
            if (null != this.getTucUpnpDevice()) {
                return this.getTucUpnpDevice().equals(obj);
            }
            Device device = (Device)obj;
            return this.getTucDevice().getInetAddress().equals(device.getInetAddress());
        }
        return super.equals(obj);
    }

    public String getDeviceInformation() {
        if (null != this.tucDevice) {
            return this.tucDevice.getIPAddress() + " (" + this.tucDevice.getMacAddressString() + ")";
        }
        if (null != this.tucUpnpDevice) {
            return this.tucUpnpDevice.getInetAddress().getHostName();
        }
        return "unknown";
    }

    public String getProperties() {
        return this.ipAddressProperty().getValue() + " - " + this.nameProperty().getValue();
    }

    public String getIpAddress() {
        return this.ipAddressProperty().getValue();
    }

    public DeviceInfo getInfo() {
        return this.info;
    }

    public void setInfo(DeviceInfo info) {
        this.info = info;
    }

    public boolean isReachable() {
        return this.reachable;
    }

    public void setReachable(boolean reachable) {
        this.reachable = reachable;
    }

    @Override
    public int compareTo(TUCDeviceModel o) {
        if (null == this.ipAddress || null == this.ipAddress.get()) {
            return -1;
        }
        if (null == o.ipAddress || null == o.ipAddress.get()) {
            return 1;
        }
        return this.ipAddress.get().compareTo(o.ipAddress.get());
    }
}

