/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.tuc.manager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.metratec.tuc.manager.TUCConfigManagerConfig;
import com.metratec.tuc.manager.control.TUCConfigManagerController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Properties;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TUCConfigManager
extends Application {
    private static File SETTING_ROOT;
    private static final String CONFIG_FILE = "TUCConfigManagerConfig.json";
    private static final String PROGRAM_PROPERTY_FILENAME = "program.properties";
    private static Properties programProperties;
    private static Logger LOGGER;
    private static final String LOG4J = "log4j.properties";
    private static TUCConfigManagerConfig config;

    private static Properties getBuildProperties() {
        if (null == programProperties) {
            programProperties = new Properties();
            InputStream inputStream = TUCConfigManager.class.getResourceAsStream(PROGRAM_PROPERTY_FILENAME);
            try {
                programProperties.load(inputStream);
            }
            catch (IOException e) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An Exception Occurred");
                alert.setHeaderText("Can not load library properties.");
                alert.setContentText(e.getMessage());
                alert.showAndWait();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return programProperties;
    }

    public void start(Stage stage) throws Exception {
        Properties projectProperties = TUCConfigManager.getBuildProperties();
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("TUCConfigManager.fxml"));
        Parent root = (Parent)fxmlLoader.load();
        TUCConfigManagerController controller = (TUCConfigManagerController)fxmlLoader.getController();
        controller.setStage(stage);
        controller.setVersion("Version " + projectProperties.getProperty("version"));
        controller.setYear(projectProperties.getProperty("build.year"));
        Scene scene = new Scene(root);
        stage.setMinWidth(1000.0);
        stage.setMinHeight(600.0);
        String title = projectProperties.getProperty("name") + " V" + projectProperties.getProperty("version");
        stage.setTitle(title);
        Image icon = new Image(((Object)((Object)this)).getClass().getResource("wellen_metratec.gif").toString());
        stage.getIcons().add((Object)icon);
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        System.setProperty("sun.net.http.retryPost", "false");
        TUCConfigManager.prepareConfigurationFolder();
        TUCConfigManager.loadLog4j();
        try {
            config = (TUCConfigManagerConfig)new ObjectMapper().readValue(new File(SETTING_ROOT, CONFIG_FILE), TUCConfigManagerConfig.class);
        }
        catch (IOException e) {
            if (TUCConfigManager.getLogger().isDebugEnabled()) {
                TUCConfigManager.getLogger().debug("Load default configuration - " + e.toString());
            }
            config = new TUCConfigManagerConfig();
        }
        TUCConfigManager.launch((String[])args);
    }

    private static void prepareConfigurationFolder() {
        if (new File(LOG4J).exists() || new File(CONFIG_FILE).exists()) {
            SETTING_ROOT = new File(".");
        } else {
            File home = new File(System.getProperty("user.home"));
            String os = System.getProperty("os.name").toLowerCase();
            String folderName = "metraTec/TUCConfigManager";
            if (os.indexOf("win") >= 0) {
                File local = new File(home, "Appdata/Local");
                SETTING_ROOT = local.exists() ? new File(local, folderName) : new File(home, "." + folderName);
            } else if (os.indexOf("mac") >= 0) {
                SETTING_ROOT = new File(home, "." + folderName);
            } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0) {
                SETTING_ROOT = new File(home, "." + folderName);
            }
            if (!SETTING_ROOT.exists()) {
                SETTING_ROOT.mkdirs();
            }
        }
        System.setProperty("setting.root", SETTING_ROOT.getAbsolutePath());
        ArrayList<String> filesToCheck = new ArrayList<String>();
        filesToCheck.add(LOG4J);
        filesToCheck.add(CONFIG_FILE);
        for (String name : filesToCheck) {
            File file = new File(SETTING_ROOT, name);
            if (file.exists()) continue;
            try {
                Files.copy(TUCConfigManager.class.getResourceAsStream("/config/" + name), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static String getSettingRoot() {
        return SETTING_ROOT.getAbsolutePath();
    }

    public static void loadLog4j() {
        LOGGER = LoggerFactory.getLogger(TUCConfigManager.class);
        File logConfig = new File(SETTING_ROOT, LOG4J);
        PropertyConfigurator.configure((String)logConfig.getAbsolutePath());
        LOGGER.info("Loading log4j.properties");
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static TUCConfigManagerConfig getConfig() {
        return config;
    }

    public static void saveConfig() {
        block2: {
            try {
                new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue(new File(SETTING_ROOT, CONFIG_FILE), (Object)TUCConfigManager.getConfig());
            }
            catch (IOException e) {
                if (!TUCConfigManager.getLogger().isDebugEnabled()) break block2;
                TUCConfigManager.getLogger().debug("Save configuration error - " + e.toString());
            }
        }
    }

    static {
        programProperties = null;
    }
}

