/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection.server;

import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import com.metratec.lib.connection.SslTcpConnection;
import com.metratec.lib.connection.server.AbstractSocketServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

public class SslSocketServer
extends AbstractSocketServer {
    public static void setKeyStoreFile(String keyStoreFile) {
        System.setProperty("javax.net.ssl.keyStore", keyStoreFile);
    }

    public static void setKeyStorePassword(String keyStorePassword) {
        System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
    }

    @Override
    protected ServerSocket createServerSocket(int serverPort) throws CommConnectionException {
        SSLServerSocketFactory sslServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        try {
            return sslServerSocketFactory.createServerSocket(serverPort);
        }
        catch (IOException e) {
            throw new CommConnectionException(7, e.getMessage());
        }
    }

    @Override
    protected ServerSocket createServerSocket(int serverPort, int backlog, InetAddress bindAddr) throws CommConnectionException {
        SSLServerSocketFactory sslServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        try {
            return sslServerSocketFactory.createServerSocket(serverPort, backlog, bindAddr);
        }
        catch (IOException e) {
            throw new CommConnectionException(7, e.getMessage());
        }
    }

    @Override
    protected ICommConnection createClientCommConnection(Socket socket) throws CommConnectionException {
        if (socket instanceof SSLSocket) {
            return new SslTcpConnection((SSLSocket)socket, true);
        }
        throw new CommConnectionException(5, "Socket is not an instance of SSLSocket");
    }
}

