/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection.server;

import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import com.metratec.lib.connection.server.ClientConnectionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSocketServer {
    private AcceptNewConnectionsThread acceptNewConnectionsThread;
    private final Logger logger = LoggerFactory.getLogger(AbstractSocketServer.class);

    public boolean isRunning() {
        return null != this.acceptNewConnectionsThread ? this.acceptNewConnectionsThread.isAlive() : false;
    }

    public void start(int serverPort, int backlog, InetAddress bindAddr, ClientConnectionListener listener) throws CommConnectionException {
        if (this.isRunning()) {
            return;
        }
        this.acceptNewConnectionsThread = new AcceptNewConnectionsThread(this.createServerSocket(serverPort, backlog, bindAddr), listener);
        this.acceptNewConnectionsThread.start();
    }

    public void start(int serverPort, ClientConnectionListener listener) throws CommConnectionException {
        if (this.isRunning()) {
            return;
        }
        this.acceptNewConnectionsThread = new AcceptNewConnectionsThread(this.createServerSocket(serverPort), listener);
        this.acceptNewConnectionsThread.start();
    }

    protected abstract ServerSocket createServerSocket(int var1) throws CommConnectionException;

    protected abstract ServerSocket createServerSocket(int var1, int var2, InetAddress var3) throws CommConnectionException;

    protected abstract ICommConnection createClientCommConnection(Socket var1) throws CommConnectionException;

    public void stop() {
        if (null == this.acceptNewConnectionsThread) {
            return;
        }
        this.acceptNewConnectionsThread.halt();
        this.waitForShutDown();
    }

    private void waitForShutDown() {
        if (null != this.acceptNewConnectionsThread && this.acceptNewConnectionsThread.isAlive()) {
            while (this.acceptNewConnectionsThread.isAlive()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int getPort() {
        if (this.isRunning()) {
            return this.acceptNewConnectionsThread.getPort();
        }
        return -1;
    }

    private class AcceptNewConnectionsThread
    extends Thread {
        private int port;
        private ClientConnectionListener listener;
        private boolean isRunning;
        private ServerSocket serverSocket;

        AcceptNewConnectionsThread(ServerSocket serverSocket, ClientConnectionListener listener) {
            this.serverSocket = serverSocket;
            this.listener = listener;
        }

        @Override
        public void run() {
            this.isRunning = true;
            while (this.isRunning) {
                try {
                    Socket socket = this.serverSocket.accept();
                    try {
                        this.callListener(AbstractSocketServer.this.createClientCommConnection(socket));
                    }
                    catch (CommConnectionException e) {
                        if (AbstractSocketServer.this.logger.isDebugEnabled()) {
                            String message = this.serverSocket + " error create client connection " + e.getMessage();
                            if (AbstractSocketServer.this.logger.isTraceEnabled()) {
                                AbstractSocketServer.this.logger.trace(message, (Throwable)e);
                            } else {
                                AbstractSocketServer.this.logger.debug(message);
                            }
                        }
                        socket.close();
                    }
                }
                catch (IOException e) {
                    String message = this.serverSocket + " io error " + e.getMessage();
                    if (AbstractSocketServer.this.logger.isDebugEnabled()) {
                        if (AbstractSocketServer.this.logger.isTraceEnabled()) {
                            AbstractSocketServer.this.logger.trace(message, (Throwable)e);
                        } else {
                            AbstractSocketServer.this.logger.debug(message);
                        }
                    }
                    if (!this.isRunning) continue;
                    if (this.serverSocket.isClosed()) {
                        this.isRunning = false;
                    }
                    this.listener.serverError(e);
                }
            }
        }

        private void callListener(final ICommConnection connection) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            AcceptNewConnectionsThread.this.listener.clientConnected(connection);
                        }
                        catch (Exception e) {
                            if (!AbstractSocketServer.this.logger.isDebugEnabled()) break block3;
                            String message = AcceptNewConnectionsThread.this.serverSocket + " error call client connection listener " + e.getMessage();
                            if (AbstractSocketServer.this.logger.isTraceEnabled()) {
                                AbstractSocketServer.this.logger.trace(message, (Throwable)e);
                            }
                            AbstractSocketServer.this.logger.debug(message);
                        }
                    }
                }
            }).start();
        }

        public int getPort() {
            return this.port;
        }

        public void halt() {
            block3: {
                this.isRunning = false;
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    if (!AbstractSocketServer.this.logger.isDebugEnabled()) break block3;
                    String message = this.serverSocket + " error close socket " + e.getMessage();
                    if (AbstractSocketServer.this.logger.isTraceEnabled()) {
                        AbstractSocketServer.this.logger.trace(message, (Throwable)e);
                    }
                    AbstractSocketServer.this.logger.debug(message);
                }
            }
        }
    }
}

