/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection;

import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.SerialConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import jd2xx.JD2XX;
import jd2xx.JD2XXInputStream;
import jd2xx.JD2XXOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsbConnection
extends SerialConnection {
    private final Logger logger = LoggerFactory.getLogger(UsbConnection.class);
    protected OutputStream outputstream = null;
    protected InputStream inputstream = null;
    private String usbDeviceSerialNumber;
    private JD2XX jd = null;
    private int recvTimeout = 500;
    private int sendTimeout = 500;
    private int connectTimeout = 1000;
    private static List<VidPid> additionalVidPids = new ArrayList<VidPid>(4);

    public UsbConnection(JD2XX.DeviceInfo usbDevice) {
        this(usbDevice.serial, 115200, 8, 1, 0, 0);
    }

    public UsbConnection(JD2XX.DeviceInfo usbDevice, int baudrate) {
        this(usbDevice.serial, baudrate, 8, 1, 0, 0);
    }

    public UsbConnection(JD2XX.DeviceInfo usbDevice, int baudrate, int dataBit, int stopBit, int parity, int flowControl) {
        this(usbDevice.serial, baudrate, dataBit, stopBit, parity, flowControl);
    }

    public UsbConnection(String usbDeviceSerialNumber) {
        this(usbDeviceSerialNumber, 115200, 8, 1, 0, 0);
    }

    public UsbConnection(String usbDeviceSerialNumber, int baudrate) {
        this(usbDeviceSerialNumber, baudrate, 8, 1, 0, 0);
    }

    public UsbConnection(String usbDeviceSerialNumber, int baudrate, int dataBit, int stopBit, int parity, int flowControl) {
        super(baudrate, dataBit, stopBit, parity, flowControl);
        this.usbDeviceSerialNumber = usbDeviceSerialNumber;
    }

    public static void addVIDPID(int vid, int pid) {
        additionalVidPids.add(new VidPid(vid, pid));
    }

    private static JD2XX initJD2XX() throws CommConnectionException {
        JD2XX ret;
        try {
            ret = new JD2XX();
        }
        catch (UnsatisfiedLinkError e) {
            throw new CommConnectionException(2, e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            throw new CommConnectionException(2, e.getMessage());
        }
        return ret;
    }

    public static ArrayList<JD2XX.DeviceInfo> getUSBDevices() throws CommConnectionException {
        HashSet<String> serials = new HashSet<String>();
        ArrayList<JD2XX.DeviceInfo> devices = new ArrayList<JD2XX.DeviceInfo>();
        JD2XX jdtmp = UsbConnection.initJD2XX();
        for (VidPid pair : additionalVidPids) {
            try {
                jdtmp.setVIDPID(pair.vid, pair.pid);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int number = jdtmp.createDeviceInfoList();
            for (int i = 0; i < number; ++i) {
                try {
                    JD2XX.DeviceInfo device = jdtmp.getDeviceInfoDetail(i);
                    if (serials.contains(device.serial)) continue;
                    serials.add(device.serial);
                    devices.add(device);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return devices;
    }

    public static LinkedList<String> getUSBDevicesList() throws CommConnectionException {
        LinkedList<String> ret = new LinkedList<String>();
        for (JD2XX.DeviceInfo device : UsbConnection.getUSBDevices()) {
            if (device.description.isEmpty()) continue;
            ret.add(device.description);
        }
        return ret;
    }

    @Override
    public void disconnect() throws CommConnectionException {
        if (this.inputstream != null) {
            try {
                this.jd.close();
                this.inputstream = null;
                this.outputstream = null;
            }
            catch (IOException e) {
                throw new CommConnectionException(1, e.getMessage());
            }
        }
    }

    @Override
    public void connect() throws CommConnectionException {
        boolean connected = false;
        if (this.inputstream != null) {
            return;
        }
        this.jd = UsbConnection.initJD2XX();
        for (VidPid pair : additionalVidPids) {
            try {
                this.jd.setVIDPID(pair.vid, pair.pid);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.jd.openBySerialNumber(this.usbDeviceSerialNumber);
                connected = true;
                break;
            }
            catch (IOException e) {
                if (!e.getMessage().startsWith("invalid handle")) continue;
                throw new CommConnectionException(4, e.getMessage());
            }
        }
        if (!connected) {
            throw new CommConnectionException(3, "No device found with serial number " + this.usbDeviceSerialNumber);
        }
        try {
            try {
                this.jd.setBaudRate(this.getBaudrate());
            }
            catch (IOException e) {
                throw new CommConnectionException(34, e.getMessage());
            }
            try {
                int jd2xxStopBits;
                switch (this.getStopBit()) {
                    case 1: {
                        jd2xxStopBits = 0;
                        break;
                    }
                    case 2: {
                        jd2xxStopBits = 2;
                        break;
                    }
                    default: {
                        jd2xxStopBits = 1;
                    }
                }
                this.jd.setDataCharacteristics(this.getDataBit(), jd2xxStopBits, this.getParity());
            }
            catch (IOException e) {
                throw new CommConnectionException(35, e.getMessage());
            }
            try {
                this.jd.setFlowControl(this.getFlowControl(), 0, 0);
            }
            catch (IOException e) {
                throw new CommConnectionException(36, e.getMessage());
            }
            try {
                this.jd.setTimeouts(this.recvTimeout, this.sendTimeout);
            }
            catch (IOException e) {
                throw new CommConnectionException(37, e.getMessage());
            }
        }
        catch (CommConnectionException e) {
            try {
                this.jd.close();
            }
            catch (IOException ioex) {
                throw new CommConnectionException(e.getErrorCode(), ioex.getMessage());
            }
            throw e;
        }
        this.inputstream = new BufferedInputStream((InputStream)new JD2XXInputStream(this.jd));
        this.outputstream = new BufferedOutputStream((OutputStream)new JD2XXOutputStream(this.jd));
    }

    @Override
    public InputStream getInputStream() {
        return this.inputstream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputstream;
    }

    @Override
    public boolean isConnected() {
        return this.inputstream != null;
    }

    @Override
    public int recv() throws CommConnectionException {
        try {
            return this.inputstream.read();
        }
        catch (NullPointerException e) {
            throw new CommConnectionException(7, "not initialize");
        }
        catch (IOException e) {
            if (e.getMessage().equals("io error")) {
                return -1;
            }
            if (e.getMessage().equals("io error (4)")) {
                throw new CommConnectionException(6, e.getMessage());
            }
            throw new CommConnectionException(1, e.getMessage());
        }
    }

    @Override
    public void send(byte[] senddata) throws CommConnectionException {
        try {
            this.outputstream.write(senddata);
            this.outputstream.flush();
        }
        catch (NullPointerException e) {
            if (senddata == null) {
                throw new CommConnectionException(5, "data are null");
            }
            throw new CommConnectionException(7, "not initialize");
        }
        catch (IOException e) {
            if (e.getMessage().equals("io error (4)")) {
                throw new CommConnectionException(6, e.getMessage());
            }
            throw new CommConnectionException(1, e.getMessage());
        }
    }

    @Override
    public int dataAvailable() throws CommConnectionException {
        try {
            return this.jd.getQueueStatus();
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("invalid handle (1)")) {
                throw new CommConnectionException(7, "not initialize");
            }
            throw new CommConnectionException(6, e.getMessage());
        }
    }

    @Override
    public Hashtable<String, Object> getInfo() {
        Hashtable<String, Object> info;
        block3: {
            info = new Hashtable<String, Object>();
            info.put("type", "usb");
            try {
                JD2XX.DeviceInfo deviceinfo = this.jd.getDeviceInfo();
                info.put("device", deviceinfo.description);
                info.put("serialnumber", deviceinfo.serial);
                info.put("baudrate", this.getBaudrate());
            }
            catch (IOException e) {
                if (!this.logger.isDebugEnabled()) break block3;
                String message = this.toString() + " error get device info " + e.getMessage();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(message, (Throwable)e);
                }
                this.logger.debug(message);
            }
        }
        return info;
    }

    @Override
    public void setSettings(Hashtable<String, String> settings) {
        String baudrate = settings.get("baudrate");
        if (null != baudrate) {
            try {
                this.setBaudrate(Integer.parseInt(baudrate));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Baudrate should be a number");
            }
        }
    }

    @Override
    public int getRecvTimeout() {
        return this.recvTimeout;
    }

    @Override
    public void setRecvTimeout(int timeout) throws CommConnectionException {
        if (0 >= timeout) {
            throw new CommConnectionException(9, "Timeout must be greater than 0");
        }
        this.recvTimeout = timeout;
        if (this.jd != null) {
            try {
                this.jd.setTimeouts(this.recvTimeout, this.sendTimeout);
            }
            catch (IOException e) {
                throw new CommConnectionException(9, e.getMessage());
            }
        }
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int timeout) throws CommConnectionException {
        if (0 >= timeout) {
            throw new CommConnectionException(9, "Timeout must be greater than 0");
        }
        this.sendTimeout = timeout;
        if (this.jd == null) {
            return;
        }
        try {
            this.jd.setTimeouts(this.recvTimeout, this.sendTimeout);
        }
        catch (IOException e) {
            throw new CommConnectionException(9, e.getMessage());
        }
    }

    @Override
    public void setConnectionTimeout(int time) {
        this.connectTimeout = time;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectTimeout;
    }

    public String getSerialNumber() {
        return this.usbDeviceSerialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.usbDeviceSerialNumber = serialNumber;
    }

    public JD2XX getJD2XX() {
        return this.jd;
    }

    public String toString() {
        return "Usb " + this.usbDeviceSerialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recv(byte[] b, int off, int len) throws CommConnectionException {
        try {
            super.recv(b, off, len);
        }
        finally {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace(this.toString() + " recv " + DatatypeConverter.printHexBinary((byte[])b) + "(" + new String(b) + ")");
            }
        }
    }

    @Override
    public StringBuilder receive(int ... terminators) throws CommConnectionException {
        StringBuilder s = super.receive(terminators);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(this.toString() + " recv " + s.toString());
        }
        return s;
    }

    private Logger getLogger() {
        return this.logger;
    }

    static {
        for (int pid = 45056; pid < 45060; ++pid) {
            UsbConnection.addVIDPID(1027, pid);
        }
    }

    private static class VidPid {
        public int vid;
        public int pid;

        VidPid(int vid, int pid) {
            this.vid = vid;
            this.pid = pid;
        }
    }
}

