/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection;

import com.metratec.lib.connection.EthernetDevice;
import com.metratec.lib.connection.UdpBroadcastHandlerInterface;
import com.metratec.lib.upnp.Device;
import com.metratec.lib.upnp.Discovery;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UdpConnection {
    private static Logger logger = LoggerFactory.getLogger(UdpConnection.class);
    private static InetAddress BROADCAST_ADDR;

    public static List<InetAddress> getAllInterfaceInetAddresses() throws SocketException {
        LinkedList<InetAddress> ret = new LinkedList<InetAddress>();
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface iface = e.nextElement();
            if (iface.isLoopback() || !iface.isUp()) continue;
            for (InetAddress addr : Collections.list(iface.getInetAddresses())) {
                if (!(addr instanceof Inet4Address)) continue;
                ret.add(addr);
            }
        }
        return ret;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    private static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("os x");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBroadcastRecvOnUnicast(DatagramPacket sendPacket, int srcPort, int recvLength, int timeout, List<InetAddress> addresses, UdpBroadcastHandlerInterface handler) throws IOException {
        if (sendPacket != null) {
            sendPacket.setAddress(BROADCAST_ADDR);
        }
        for (InetAddress localAddr : addresses) {
            DatagramSocket socket;
            block12: {
                socket = new DatagramSocket(srcPort, localAddr);
                try {
                    socket.setBroadcast(true);
                    socket.setSoTimeout(timeout);
                    if (sendPacket == null) break block12;
                    if (logger.isTraceEnabled()) {
                        logger.trace("broadcast send from " + localAddr.getHostAddress() + ":" + srcPort + " - " + UdpConnection.toHexString(sendPacket.getData()));
                    }
                    socket.send(sendPacket);
                }
                catch (IOException e) {
                    socket.close();
                    continue;
                }
            }
            if (recvLength <= 0) {
                socket.close();
                continue;
            }
            try {
                DatagramPacket recvPacket;
                do {
                    recvPacket = new DatagramPacket(new byte[recvLength], recvLength);
                    socket.receive(recvPacket);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("broadcast recv from  " + recvPacket.getAddress().getHostAddress() + ":" + recvPacket.getPort() + " - " + UdpConnection.toHexString(recvPacket.getData()));
                } while (handler.handle(localAddr, recvPacket, socket));
                return;
            }
            catch (SocketTimeoutException socketTimeoutException) {}
            continue;
            finally {
                socket.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static void sendBroadcastRecvOnBroadcast(DatagramPacket sendPacket, int srcPort, int recvLength, int timeout, List<InetAddress> addresses, UdpBroadcastHandlerInterface handler) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.utils.finalhelp.FinalAnalyzer.identifyFinally(FinalAnalyzer.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.FinallyRewriter.identifyFinally(FinallyRewriter.java:40)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:548)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendBroadcastRecvOnAny(DatagramPacket sendPacket, int srcPort, int recvLength, int timeout, List<InetAddress> addresses, UdpBroadcastHandlerInterface handler) throws IOException {
        for (InetAddress localAddr : addresses) {
            DatagramSocket socket;
            block11: {
                socket = new DatagramSocket(srcPort);
                try {
                    socket.setBroadcast(true);
                    socket.setSoTimeout(timeout);
                    if (sendPacket == null) break block11;
                    sendPacket.setAddress(BROADCAST_ADDR);
                    if (logger.isTraceEnabled()) {
                        logger.trace("broadcast send from " + localAddr.getHostAddress() + ":" + srcPort + " - " + UdpConnection.toHexString(sendPacket.getData()));
                    }
                    socket.send(sendPacket);
                }
                catch (IOException e) {
                    socket.close();
                    continue;
                }
            }
            if (recvLength <= 0) {
                socket.close();
                continue;
            }
            try {
                DatagramPacket recvPacket;
                do {
                    recvPacket = new DatagramPacket(new byte[recvLength], recvLength);
                    socket.receive(recvPacket);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("broadcast recv from  " + recvPacket.getAddress().getHostAddress() + ":" + recvPacket.getPort() + " - " + UdpConnection.toHexString(recvPacket.getData()));
                } while (handler.handle(localAddr, recvPacket, socket));
                return;
            }
            catch (SocketTimeoutException socketTimeoutException) {}
            continue;
            finally {
                socket.close();
            }
        }
    }

    public static void sendRecvBroadcast(DatagramPacket sendPacket, int srcPort, int recvLength, int timeout, UdpBroadcastHandlerInterface handler) throws IOException {
        List<InetAddress> addresses = UdpConnection.getAllInterfaceInetAddresses();
        UdpConnection.sendRecvBroadcast(sendPacket, srcPort, recvLength, timeout, addresses, handler);
    }

    public static void sendRecvBroadcast(DatagramPacket sendPacket, int srcPort, int recvLength, int timeout, InetAddress addr, UdpBroadcastHandlerInterface handler) throws IOException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(1);
        addresses.add(addr);
        UdpConnection.sendRecvBroadcast(sendPacket, srcPort, recvLength, timeout, addresses, handler);
    }

    public static void sendRecvBroadcast(DatagramPacket sendPacket, int srcPort, int recvLength, int timeout, List<InetAddress> addresses, UdpBroadcastHandlerInterface handler) throws IOException {
        if (UdpConnection.isWindows()) {
            UdpConnection.sendBroadcastRecvOnUnicast(sendPacket, srcPort, recvLength, timeout, addresses, handler);
        } else if (UdpConnection.isMac()) {
            UdpConnection.sendBroadcastRecvOnAny(sendPacket, srcPort, recvLength, timeout, addresses, handler);
        } else {
            UdpConnection.sendBroadcastRecvOnBroadcast(sendPacket, srcPort, recvLength, timeout, addresses, handler);
        }
    }

    public static List<EthernetDevice> getLantronixEthernetDevices(int timeout) throws IOException {
        List<InetAddress> addresses = UdpConnection.getAllInterfaceInetAddresses();
        return UdpConnection.getLantronixEthernetDevices(timeout, addresses);
    }

    public static List<EthernetDevice> getLantronixEthernetDevices(int timeout, InetAddress addr) throws IOException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(1);
        addresses.add(addr);
        return UdpConnection.getLantronixEthernetDevices(timeout, addresses);
    }

    public static List<EthernetDevice> getLantronixEthernetDevices(final int timeout, List<InetAddress> addresses) throws IOException {
        final TreeSet deviceSet = new TreeSet();
        byte[] sendData = new byte[]{0, 0, 0, -10};
        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, BROADCAST_ADDR, 30718);
        UdpConnection.sendBroadcastRecvOnUnicast(sendPacket, 41000, 30, timeout, addresses, new UdpBroadcastHandlerInterface(){

            @Override
            public boolean handle(InetAddress localAddress, DatagramPacket recvPacket, DatagramSocket socket) throws IOException {
                EthernetDevice dev = new EthernetDevice();
                InetAddress srcAddr = recvPacket.getAddress();
                byte[] recvData = recvPacket.getData();
                if (recvData[0] != 0 || recvData[1] != 0 || recvData[2] != 0 || recvData[3] != -9) {
                    return true;
                }
                StringBuffer mac = new StringBuffer();
                for (int i = 24; i < 30; ++i) {
                    mac.append(String.format(":%02X", recvData[i]));
                }
                dev.setMACAddress(mac.toString().substring(1));
                dev.setIPAddress(srcAddr.getHostAddress());
                dev.setDeviceName(srcAddr.getHostAddress());
                dev.setReachable(srcAddr.isReachable(timeout));
                deviceSet.add(dev);
                return true;
            }
        });
        return new ArrayList<EthernetDevice>(deviceSet);
    }

    public static List<EthernetDevice> getMetratecEthernetDevices(int timeout) throws IOException {
        List<InetAddress> addresses = UdpConnection.getAllInterfaceInetAddresses();
        return UdpConnection.getMetratecEthernetDevices(timeout, addresses);
    }

    public static List<EthernetDevice> getMetratecEthernetDevices(int timeout, InetAddress addr) throws IOException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(1);
        addresses.add(addr);
        return UdpConnection.getMetratecEthernetDevices(timeout, addresses);
    }

    public static List<EthernetDevice> getMetratecEthernetDevices(final int timeout, List<InetAddress> addresses) throws IOException {
        final TreeSet<EthernetDevice> deviceSet = new TreeSet<EthernetDevice>();
        byte[] sendData = new byte[52];
        sendData[0] = 1;
        sendData[1] = 19;
        sendData[2] = 55;
        sendData[3] = 10;
        sendData[4] = -1;
        sendData[5] = -1;
        sendData[6] = -1;
        sendData[7] = -1;
        sendData[8] = -1;
        sendData[9] = -1;
        sendData[16] = 1;
        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, BROADCAST_ADDR, 42000);
        UdpConnection.sendRecvBroadcast(sendPacket, 41000, 52, timeout, addresses, new UdpBroadcastHandlerInterface(){

            @Override
            public boolean handle(InetAddress localAddr, DatagramPacket recvPacket, DatagramSocket socket) throws IOException {
                EthernetDevice dev = new EthernetDevice();
                InetAddress srcAddr = recvPacket.getAddress();
                byte[] recvData = recvPacket.getData();
                StringBuffer mac = new StringBuffer();
                for (int i = 10; i < 16; ++i) {
                    mac.append(String.format(":%02X", recvData[i]));
                }
                dev.setMACAddress(mac.toString().substring(1));
                dev.setIPAddress(srcAddr.getHostAddress());
                dev.setDeviceName(new String(recvData, 17, 32, Charset.forName("ISO-8859-1")).trim());
                dev.setReachable(srcAddr.isReachable(timeout));
                deviceSet.add(dev);
                return true;
            }
        });
        String[] searchTargets = new String[]{"urn:www-metratec-com:device:TUC:2"};
        Discovery discovery = new Discovery(3000, searchTargets);
        List upnpDevices = new ArrayList();
        try {
            upnpDevices = discovery.discover();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (Device upnpDevice : upnpDevices) {
            EthernetDevice dev = new EthernetDevice();
            dev.setIPAddress(upnpDevice.getInetAddress().getHostAddress());
            dev.setDeviceName(upnpDevice.getDescription().getFriendlyName());
            dev.setReachable(true);
            deviceSet.add(dev);
        }
        return new ArrayList<EthernetDevice>(deviceSet);
    }

    private static String toHexString(byte[] data) {
        StringBuilder strbuf = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            if ((data[i] & 0xFF) < 16) {
                strbuf.append('0');
            }
            strbuf.append(Integer.toHexString(data[i] & 0xFF).toUpperCase());
        }
        return strbuf.toString();
    }

    static {
        byte[] addr = new byte[]{-1, -1, -1, -1};
        try {
            BROADCAST_ADDR = InetAddress.getByAddress(addr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

