/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection;

import com.metratec.lib.connection.AbstractTcpConnection;
import com.metratec.lib.connection.CommConnectionException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpConnection
extends AbstractTcpConnection {
    private final Logger logger = LoggerFactory.getLogger(TcpConnection.class);

    public TcpConnection(String ip, int port) {
        super(ip, port);
    }

    public TcpConnection(Socket socket) throws CommConnectionException {
        super(socket);
    }

    public TcpConnection(Socket socket, boolean isServerConnection) throws CommConnectionException {
        super(socket, isServerConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recv(byte[] b, int off, int len) throws CommConnectionException {
        try {
            super.recv(b, off, len);
        }
        finally {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace(this.toString() + " recv " + DatatypeConverter.printHexBinary((byte[])b) + "(" + new String(b) + ")");
            }
        }
    }

    @Override
    public void send(String senddata) throws CommConnectionException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(this.toString() + " send " + senddata);
        }
        super.send(senddata);
    }

    @Override
    public StringBuilder receive(int ... terminators) throws CommConnectionException {
        StringBuilder s = super.receive(terminators);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(this.toString() + " recv " + s.toString());
        }
        return s;
    }

    @Override
    protected Socket createNewSocket(String ipAddress, int port) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(ipAddress, port), this.getConnectionTimeout());
        return socket;
    }

    public String toString() {
        return "Tcp " + this.getIPAddress() + ":" + this.getPort();
    }

    private Logger getLogger() {
        return this.logger;
    }
}

