/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection;

import com.metratec.lib.connection.AbstractTcpConnection;
import com.metratec.lib.connection.CommConnectionException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslTcpConnection
extends AbstractTcpConnection {
    private final Logger logger = LoggerFactory.getLogger(SslTcpConnection.class);

    public static void setTrustStoreFile(String trustStoreFile) {
        System.setProperty("javax.net.ssl.trustStore", trustStoreFile);
    }

    public static void setTrustStorePassword(String trustStorePassword) {
        System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
    }

    public SslTcpConnection(String ip, int port) {
        super(ip, port);
    }

    public SslTcpConnection(SSLSocket socket) throws CommConnectionException {
        super(socket);
    }

    public SslTcpConnection(SSLSocket socket, boolean isServerConnection) throws CommConnectionException {
        super(socket, isServerConnection);
    }

    @Override
    protected SSLSocket createNewSocket(String ipAddress, int port) throws UnknownHostException, IOException {
        SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket socket = (SSLSocket)sslsocketfactory.createSocket();
        socket.connect(new InetSocketAddress(ipAddress, port), this.getConnectionTimeout());
        socket.setSoTimeout(this.getConnectionTimeout());
        socket.startHandshake();
        return socket;
    }

    public String toString() {
        return "TcpSsl " + this.getIPAddress() + ":" + this.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recv(byte[] b, int off, int len) throws CommConnectionException {
        try {
            super.recv(b, off, len);
        }
        finally {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace(this.toString() + " recv " + DatatypeConverter.printHexBinary((byte[])b) + "(" + new String(b) + ")");
            }
        }
    }

    @Override
    public StringBuilder receive(int ... terminators) throws CommConnectionException {
        StringBuilder s = super.receive(terminators);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(this.toString() + " recv " + s.toString());
        }
        return s;
    }

    private Logger getLogger() {
        return this.logger;
    }
}

