/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection;

import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.SerialConnection;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rs232Connection
extends SerialConnection {
    private final Logger logger = LoggerFactory.getLogger(Rs232Connection.class);
    protected OutputStream outputstream = null;
    protected InputStream inputstream = null;
    private CommPortIdentifier portId = null;
    private SerialPort serialPort = null;
    private String portName;
    private int recvTimeout = 500;
    private int connectTimeout = 1000;

    public Rs232Connection(String portName, int baudrate, int dataBit, int stopBit, int parity, int flowControl) {
        super(baudrate, dataBit, stopBit, parity, flowControl);
        this.portName = portName;
    }

    public static String[] getSerialPorts() throws CommConnectionException {
        try {
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            StringBuilder tmp = new StringBuilder();
            while (portList.hasMoreElements()) {
                CommPortIdentifier serialPortId = (CommPortIdentifier)portList.nextElement();
                if (serialPortId.getPortType() != 1) continue;
                tmp.append(serialPortId.getName());
                tmp.append("\r");
            }
            if (0 == tmp.length()) {
                return new String[0];
            }
            return tmp.toString().split("\r");
        }
        catch (UnsatisfiedLinkError e) {
            throw new CommConnectionException(2, e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            throw new CommConnectionException(2, e.getMessage());
        }
    }

    @Override
    public void connect() throws CommConnectionException {
        try {
            CommPortIdentifier.getPortIdentifiers();
            this.portId = CommPortIdentifier.getPortIdentifier((String)this.portName);
            this.serialPort = this.portId.open("metratec", this.connectTimeout);
            this.serialPort.enableReceiveTimeout(this.recvTimeout);
            this.outputstream = new BufferedOutputStream(this.serialPort.getOutputStream());
            this.inputstream = new BufferedInputStream(this.serialPort.getInputStream());
            this.serialPort.setSerialPortParams(this.getBaudrate(), this.getDataBit(), this.getStopBit(), this.getParity());
        }
        catch (UnsatisfiedLinkError e) {
            throw new CommConnectionException(2, e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            throw new CommConnectionException(2, e.getMessage());
        }
        catch (NoSuchPortException e) {
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            StringBuilder tmp = new StringBuilder();
            while (portList.hasMoreElements()) {
                CommPortIdentifier serialPortId = (CommPortIdentifier)portList.nextElement();
                if (serialPortId.getPortType() != 1) continue;
                tmp.append(serialPortId.getName());
                tmp.append(" ");
            }
            throw new CommConnectionException(17, "Specified Serial port " + this.portName + " does not exist, available " + tmp.toString());
        }
        catch (UnsupportedCommOperationException e) {
            throw new CommConnectionException(18, "Could not set interface parameter " + e.getMessage());
        }
        catch (PortInUseException e) {
            throw new CommConnectionException(4, "Serial Port in use " + e.getMessage());
        }
        catch (IOException e) {
            throw new CommConnectionException(19, "No access to Output-/InputStream " + e.getMessage());
        }
        catch (Exception e) {
            throw new CommConnectionException(20, "Could not initialise RS232 connection " + e.getMessage());
        }
    }

    @Override
    public void disconnect() throws CommConnectionException {
        if (this.serialPort != null) {
            this.serialPort.close();
        }
        this.serialPort = null;
        this.inputstream = null;
        this.outputstream = null;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputstream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputstream;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    @Override
    public boolean isConnected() {
        return this.inputstream != null;
    }

    @Override
    public int recv() throws CommConnectionException {
        try {
            return this.inputstream.read();
        }
        catch (NullPointerException e) {
            throw new CommConnectionException(7, "not initialize");
        }
        catch (IOException e) {
            if (null == e.getMessage()) {
                throw new CommConnectionException(6, "Input/output error");
            }
            if (e.getMessage().equals("No error in readByte")) {
                throw new CommConnectionException(6, "Input/output error");
            }
            throw new CommConnectionException(1, e.getMessage());
        }
    }

    @Override
    public void send(byte[] senddata) throws CommConnectionException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(this.toString() + " send " + DatatypeConverter.printHexBinary((byte[])senddata) + "(" + new String(senddata) + ")");
        }
        try {
            this.outputstream.write(senddata);
            this.outputstream.flush();
        }
        catch (NullPointerException e) {
            if (senddata == null) {
                throw new CommConnectionException(5, "data are null");
            }
            throw new CommConnectionException(7, "not initialize");
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("Input/output error")) {
                this.serialPort.close();
                throw new CommConnectionException(6, e.getMessage());
            }
            throw new CommConnectionException(1, e.getMessage());
        }
    }

    @Override
    public int dataAvailable() throws CommConnectionException {
        try {
            return this.inputstream.available();
        }
        catch (NullPointerException e) {
            throw new CommConnectionException(7, "not initialize");
        }
        catch (IOException e) {
            throw new CommConnectionException(6, e.getMessage());
        }
    }

    @Override
    public Hashtable<String, Object> getInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("type", "rs232");
        info.put("baudrate", this.getBaudrate());
        info.put("portname", this.portName);
        info.put("databit", this.getDataBit());
        info.put("stopbit", this.getStopBit());
        info.put("parity", this.getParity());
        info.put("flowcontrol", this.getFlowControl());
        return info;
    }

    @Override
    public void setSettings(Hashtable<String, String> settings) {
        String portname;
        String baudrate;
        String flowcontrol;
        String parity;
        String stopbit;
        String databit = settings.get("databit");
        if (null != databit) {
            try {
                this.setDataBit(Integer.parseInt(databit));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Databit should be a number");
            }
        }
        if (null != (stopbit = settings.get("stopbit"))) {
            try {
                this.setStopBit(Integer.parseInt(stopbit));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Stopbit should be a number");
            }
        }
        if (null != (parity = settings.get("parity"))) {
            try {
                this.setParity(Integer.parseInt(parity));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Parity should be a number");
            }
        }
        if (null != (flowcontrol = settings.get("flowcontrol"))) {
            try {
                this.setFlowControl(Integer.parseInt(flowcontrol));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Flowcontrol should be a number");
            }
        }
        if (null != (baudrate = settings.get("baudrate"))) {
            try {
                this.setBaudrate(Integer.parseInt(baudrate));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Baudrate should be a number");
            }
        }
        if (null != (portname = settings.get("portname"))) {
            this.portName = portname;
        }
    }

    @Override
    public int getRecvTimeout() {
        return this.recvTimeout;
    }

    @Override
    public void setRecvTimeout(int timeout) throws CommConnectionException {
        this.recvTimeout = timeout;
        if (this.serialPort != null) {
            try {
                this.serialPort.enableReceiveTimeout(this.recvTimeout);
            }
            catch (UnsupportedCommOperationException e) {
                throw new CommConnectionException(9, e.getMessage());
            }
        }
    }

    @Override
    public void setConnectionTimeout(int time) {
        this.connectTimeout = time;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectTimeout;
    }

    public String toString() {
        return "Rs232 " + this.getPortName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recv(byte[] b, int off, int len) throws CommConnectionException {
        try {
            super.recv(b, off, len);
        }
        finally {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace(this.toString() + " recv " + DatatypeConverter.printHexBinary((byte[])b) + "(" + new String(b) + ")");
            }
        }
    }

    @Override
    public StringBuilder receive(int ... terminators) throws CommConnectionException {
        StringBuilder s = super.receive(terminators);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(this.toString() + " recv " + s.toString());
        }
        return s;
    }

    private Logger getLogger() {
        return this.logger;
    }
}

