/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection;

import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PrinterName;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrinterConnection
extends ICommConnection {
    private final Logger logger = LoggerFactory.getLogger(PrinterConnection.class);
    private String printerName;
    private PrintService printService;
    private int recvTimeout = 500;
    private int connectTimeout = 1000;

    public static List<String> getPrinterList() {
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
        ArrayList<String> ret = new ArrayList<String>(printServices.length);
        for (PrintService ps : printServices) {
            PrinterName psName = ps.getAttribute(PrinterName.class);
            ret.add(psName.getValue());
        }
        return ret;
    }

    public PrinterConnection(String name) {
        this.printerName = name;
    }

    @Override
    public void connect() throws CommConnectionException {
        this.printService = null;
        for (PrintService ps : PrintServiceLookup.lookupPrintServices(null, null)) {
            PrinterName psName = ps.getAttribute(PrinterName.class);
            if (!psName.getValue().equals(this.printerName)) continue;
            this.printService = ps;
            return;
        }
        throw new CommConnectionException(3, "Printer \"" + this.printerName + "\" not found.");
    }

    @Override
    public void disconnect() throws CommConnectionException {
        this.printService = null;
    }

    @Override
    public boolean isConnected() {
        return this.printService != null;
    }

    @Override
    public Hashtable<String, Object> getInfo() {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        ret.put("type", "printer");
        if (!this.isConnected()) {
            return ret;
        }
        for (Attribute attr : this.printService.getAttributes().toArray()) {
            ret.put(attr.getName(), attr);
        }
        return ret;
    }

    @Override
    public void setSettings(Hashtable<String, String> settings) {
    }

    @Override
    public void send(byte[] senddata) throws CommConnectionException {
        if (!this.isConnected()) {
            throw new CommConnectionException(7, "Not initialized");
        }
        SimpleDoc doc = new SimpleDoc(senddata, DocFlavor.BYTE_ARRAY.AUTOSENSE, null);
        HashPrintRequestAttributeSet reqAttrs = new HashPrintRequestAttributeSet();
        reqAttrs.add(new JobName(this.getClass().toString(), Locale.getDefault()));
        DocPrintJob job = this.printService.createPrintJob();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference jobEvent = new AtomicReference();
        job.addPrintJobListener(new PrintJobListener(){

            @Override
            public void printDataTransferCompleted(PrintJobEvent event) {
            }

            @Override
            public void printJobCompleted(PrintJobEvent event) {
                latch.countDown();
            }

            @Override
            public void printJobFailed(PrintJobEvent event) {
                jobEvent.set(event);
                latch.countDown();
            }

            @Override
            public void printJobCanceled(PrintJobEvent event) {
                jobEvent.set(event);
                latch.countDown();
            }

            @Override
            public void printJobRequiresAttention(PrintJobEvent event) {
                jobEvent.set(event);
                latch.countDown();
            }

            @Override
            public void printJobNoMoreEvents(PrintJobEvent event) {
                latch.countDown();
            }
        });
        try {
            job.print(doc, reqAttrs);
            latch.await();
        }
        catch (PrintException e) {
            throw new CommConnectionException(1, "Error spooling print job: " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new CommConnectionException(1, "Interruption: " + e.getMessage());
        }
        if (jobEvent.get() != null) {
            throw new CommConnectionException(1, ((PrintJobEvent)jobEvent.get()).toString());
        }
    }

    @Override
    public int recv() throws CommConnectionException {
        if (!this.isConnected()) {
            throw new CommConnectionException(7, "Not initialized");
        }
        try {
            Thread.sleep(this.recvTimeout);
        }
        catch (InterruptedException e) {
            throw new CommConnectionException(1, "Interruption: " + e.getMessage());
        }
        return -1;
    }

    @Override
    public int dataAvailable() throws CommConnectionException {
        if (!this.isConnected()) {
            throw new CommConnectionException(7, "Not initialized");
        }
        return 0;
    }

    @Override
    public void setRecvTimeout(int timeout) throws CommConnectionException {
        if (timeout <= 0) {
            throw new CommConnectionException(9, "Timeout must be greater than 0");
        }
        this.recvTimeout = timeout;
    }

    @Override
    public int getRecvTimeout() {
        return this.recvTimeout;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectTimeout;
    }

    @Override
    public InputStream getInputStream() {
        throw new UnsupportedOperationException("getInputStream() unsupported by PrinterConnection");
    }

    @Override
    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("getOutputStream() unsupported by PrinterConnection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recv(byte[] b, int off, int len) throws CommConnectionException {
        try {
            super.recv(b, off, len);
        }
        finally {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace(this.toString() + " recv " + DatatypeConverter.printHexBinary((byte[])b) + "(" + new String(b) + ")");
            }
        }
    }

    @Override
    public StringBuilder receive(int ... terminators) throws CommConnectionException {
        StringBuilder s = super.receive(terminators);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(this.toString() + " recv " + s.toString());
        }
        return s;
    }

    private Logger getLogger() {
        return this.logger;
    }
}

