/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection;

import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Hashtable;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpsTunnelConnection
extends ICommConnection {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ICommConnection masterConn;
    protected String slaveEID = null;
    protected CircularBuffer downstreamBuf = new CircularBuffer(102400);
    private OutputStream outStream = new BufferedOutputStream(new TunnelOutputStream());
    private InputStream inStream = new TunnelInputStream("BINXR ");
    private int linkTimeout = 11000;

    protected String masterConnRecvLine() throws IOException {
        int c;
        InputStream masterInStream = this.masterConn.getInputStream();
        StringBuilder data = new StringBuilder();
        do {
            try {
                c = masterInStream.read();
            }
            catch (SocketTimeoutException e) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace(this.toString() + " recv - TimeoutException " + e.getMessage());
                }
                return null;
            }
            if (c < 0) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace(this.toString() + " recv - no data (null)");
                }
                return null;
            }
            data.append((char)c);
        } while (c != 13);
        if (this.getLogger().isTraceEnabled()) {
            String recv = data.toString();
            try {
                this.getLogger().trace(this.toString() + " recv " + recv.substring(0, recv.length() - 1));
            }
            catch (IndexOutOfBoundsException e) {
                this.getLogger().trace(this.toString() + " recv " + recv);
            }
        }
        return data.toString();
    }

    protected void addDownstreamFrame(String line) throws IOException {
        assert (line.startsWith("BINXR "));
        this.downstreamBuf.write(DatatypeConverter.parseHexBinary((String)line.substring(6, line.length() - 1)));
    }

    public MpsTunnelConnection(ICommConnection connection, String slaveEID) {
        assert (connection != null);
        this.masterConn = connection;
        assert (slaveEID == null || slaveEID.length() == 16);
        this.slaveEID = slaveEID;
    }

    public MpsTunnelConnection(ICommConnection connection) {
        this(connection, null);
    }

    public int getLinkTimeout() {
        return this.linkTimeout;
    }

    public void setLinkTimeout(int linkTimeout) {
        this.linkTimeout = linkTimeout;
    }

    @Override
    public void connect() throws CommConnectionException {
        this.masterConn.connect();
        if (this.slaveEID == null) {
            return;
        }
        this.unlink();
        this.link();
    }

    protected void unlink() throws CommConnectionException {
        String response;
        long timeStamp = System.nanoTime();
        this.masterConn.send("ULK\r");
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(this.toString() + " send ULK");
        }
        do {
            response = this.masterConn.recv(13);
            if ((System.nanoTime() - timeStamp) / 1000000L < (long)this.linkTimeout) continue;
            throw new CommConnectionException(1, "Timeout during unlinking");
        } while (!response.startsWith("ULK "));
        if (!response.equals("ULK OK\r") && !response.equals("ULK ERR\r")) {
            throw new CommConnectionException(1, "Unexpected ULK response: " + response.substring(4, response.length() - 1));
        }
    }

    protected void link() throws CommConnectionException {
        String response;
        long timeStamp = System.nanoTime();
        if (this.slaveEID == null) {
            return;
        }
        this.masterConn.send("LNK " + this.slaveEID + "\r");
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(this.toString() + " send LNK " + this.slaveEID);
        }
        do {
            response = this.masterConn.recv(13);
            if ((System.nanoTime() - timeStamp) / 1000000L < (long)this.linkTimeout) continue;
            throw new CommConnectionException(1, "Timeout during linking to slave device");
        } while (!response.startsWith("LNK "));
        if (!response.equals("LNK " + this.slaveEID + " OK\r")) {
            throw new CommConnectionException(1, "Unexpected LNK response: " + response.substring(4, response.length() - 1));
        }
    }

    @Override
    public boolean isConnected() {
        return this.masterConn.isConnected();
    }

    @Override
    public void disconnect() throws CommConnectionException {
        this.masterConn.disconnect();
    }

    @Override
    public InputStream getInputStream() {
        return this.inStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outStream;
    }

    @Override
    public int dataAvailable() throws CommConnectionException {
        try {
            return this.getInputStream().available();
        }
        catch (IOException e) {
            throw new CommConnectionException(6, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recv(byte[] b, int off, int len) throws CommConnectionException {
        try {
            super.recv(b, off, len);
        }
        finally {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace(this.toString() + " recv " + DatatypeConverter.printHexBinary((byte[])b) + "(" + new String(b) + ")");
            }
        }
    }

    @Override
    public StringBuilder receive(int ... terminators) throws CommConnectionException {
        StringBuilder s = super.receive(terminators);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(this.toString() + " recv " + s.toString());
        }
        return s;
    }

    @Override
    public int recv() throws CommConnectionException {
        try {
            return this.getInputStream().read();
        }
        catch (IOException e) {
            if (e.getMessage() == null) {
                throw new CommConnectionException(6, "Input/output error");
            }
            throw new CommConnectionException(1, e.getMessage());
        }
    }

    @Override
    public void send(byte[] senddata) throws CommConnectionException {
        try {
            this.getOutputStream().write(senddata);
            this.getOutputStream().flush();
        }
        catch (NullPointerException e) {
            if (senddata == null) {
                throw new CommConnectionException(5, "senddata is null");
            }
            throw new CommConnectionException(7, "not initialized");
        }
        catch (IOException e) {
            throw new CommConnectionException(1, e.getMessage());
        }
    }

    @Override
    public Hashtable<String, Object> getInfo() {
        return this.masterConn.getInfo();
    }

    @Override
    public void setSettings(Hashtable<String, String> settings) {
        this.masterConn.setSettings(settings);
    }

    @Override
    public void setRecvTimeout(int timeout) throws CommConnectionException {
        this.masterConn.setRecvTimeout(timeout);
    }

    @Override
    public int getRecvTimeout() {
        return this.masterConn.getRecvTimeout();
    }

    @Override
    public void setConnectionTimeout(int time) {
        this.masterConn.setConnectionTimeout(time);
    }

    @Override
    public int getConnectionTimeout() {
        return this.masterConn.getConnectionTimeout();
    }

    public String toString() {
        return "Tunneled " + this.masterConn;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public ICommConnection getMasterConn() {
        return this.masterConn;
    }

    protected class TunnelInputStream
    extends InputStream {
        private final String responsePrefix;

        TunnelInputStream(String responsePrefix) {
            this.responsePrefix = responsePrefix;
        }

        @Override
        public int available() {
            return MpsTunnelConnection.this.downstreamBuf.available();
        }

        @Override
        public int read() throws IOException {
            if (MpsTunnelConnection.this.downstreamBuf.available() == 0) {
                String line;
                long timeStamp = System.nanoTime();
                do {
                    if ((line = MpsTunnelConnection.this.masterConnRecvLine()) == null || (System.nanoTime() - timeStamp) / 1000000L >= (long)MpsTunnelConnection.this.masterConn.getRecvTimeout()) {
                        return -1;
                    }
                    if (!line.equals("TOE\r")) continue;
                    throw new IOException("Broken link to slave device");
                } while (!line.startsWith(this.responsePrefix));
                MpsTunnelConnection.this.addDownstreamFrame(line);
            }
            return MpsTunnelConnection.this.downstreamBuf.read();
        }
    }

    private class TunnelOutputStream
    extends OutputStream {
        private static final int MAX_FRAME_SIZE = 96;

        private TunnelOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OutputStream masterOutStream = MpsTunnelConnection.this.masterConn.getOutputStream();
            while (len > 0) {
                byte[] frame = Arrays.copyOfRange(b, off, off + Math.min(len, 96));
                if (MpsTunnelConnection.this.getLogger().isTraceEnabled()) {
                    MpsTunnelConnection.this.getLogger().trace("Tunneled " + MpsTunnelConnection.this.masterConn + " send BINXT " + DatatypeConverter.printHexBinary((byte[])frame));
                }
                masterOutStream.write("BINXT ".getBytes());
                masterOutStream.write(DatatypeConverter.printHexBinary((byte[])frame).getBytes());
                masterOutStream.write(13);
                masterOutStream.flush();
                long timeStamp = System.nanoTime();
                while (true) {
                    String line;
                    if ((line = MpsTunnelConnection.this.masterConnRecvLine()) == null || (System.nanoTime() - timeStamp) / 1000000L >= (long)MpsTunnelConnection.this.masterConn.getRecvTimeout()) {
                        if (MpsTunnelConnection.this.getLogger().isTraceEnabled()) {
                            MpsTunnelConnection.this.getLogger().trace("Tunneled " + MpsTunnelConnection.this.masterConn + " TimeoutException - " + MpsTunnelConnection.this.masterConn.getRecvTimeout() + " " + (System.nanoTime() - timeStamp) / 1000000L);
                        }
                        throw new IOException("Timeout while receiving MPS frame ACK");
                    }
                    if (line.equals("BINXT OK\r")) break;
                    if (line.startsWith("BINXT ")) {
                        throw new IOException("Unexpected error while sending MPS frame (" + line.substring(6, line.length() - 1) + ")");
                    }
                    if (line.equals("TOE\r")) {
                        throw new IOException("Broken link to slave device");
                    }
                    if (!line.startsWith("BINXR ")) continue;
                    MpsTunnelConnection.this.addDownstreamFrame(line);
                }
                off += 96;
                len -= 96;
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }
    }

    protected class CircularBuffer {
        private byte[] buf;
        private int writePos = 0;
        private int readPos = 0;

        public CircularBuffer(int maxSize) {
            this.buf = new byte[maxSize];
        }

        public int available() {
            return this.writePos >= this.readPos ? this.writePos - this.readPos : this.buf.length - this.readPos + this.writePos;
        }

        public void write(byte b) throws IOException {
            this.buf[this.writePos] = b;
            this.writePos = (this.writePos + 1) % this.buf.length;
            if (this.writePos == this.readPos) {
                throw new IOException("Buffer overflow");
            }
        }

        public void write(byte[] data) throws IOException {
            for (byte b : data) {
                this.write(b);
            }
        }

        public int read() {
            if (this.readPos == this.writePos) {
                return -1;
            }
            byte b = this.buf[this.readPos];
            this.readPos = (this.readPos + 1) % this.buf.length;
            return b & 0xFF;
        }
    }
}

