/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection;

import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import com.metratec.lib.connection.MpsTunnelConnection;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class MpsLegacyTunnelConnection
extends MpsTunnelConnection {
    private OutputStream outStream = new BufferedOutputStream(new TunnelOutputStream());
    private InputStream inStream = new MpsTunnelConnection.TunnelInputStream("DAT ");
    private boolean linked = false;

    @Override
    protected void addDownstreamFrame(String line) throws IOException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(this.toString() + " recv " + line);
        }
        assert (line.startsWith("DAT "));
        String[] str = line.split(" ");
        if (str.length >= 3) {
            int start = this.linked ? 1 : 2;
            String resp = String.join((CharSequence)" ", Arrays.copyOfRange(str, start, str.length - 1));
            this.downstreamBuf.write(resp.getBytes());
            this.downstreamBuf.write((byte)13);
        } else {
            System.out.println("Debug: " + line);
            this.downstreamBuf.write(line.substring(4).getBytes());
        }
    }

    public MpsLegacyTunnelConnection(ICommConnection connection, String slaveEID) {
        super(connection, slaveEID);
    }

    public MpsLegacyTunnelConnection(ICommConnection connection) {
        super(connection);
    }

    public void setLinked(boolean linked) {
        this.linked = linked;
    }

    public boolean isLinked() {
        return this.linked;
    }

    @Override
    public void connect() throws CommConnectionException {
        if (!this.masterConn.isConnected()) {
            if (this.linked) {
                super.connect();
            } else {
                this.masterConn.connect();
                this.unlink();
            }
        }
    }

    @Override
    public void disconnect() throws CommConnectionException {
        if (this.linked) {
            this.unlink();
        }
        this.masterConn.disconnect();
    }

    @Override
    public InputStream getInputStream() {
        return this.inStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outStream;
    }

    @Override
    public void send(byte[] senddata) throws CommConnectionException {
        if (senddata[senddata.length - 1] != 13) {
            throw new CommConnectionException(1, "Data must be carriage return terminated");
        }
        super.send(senddata);
    }

    @Override
    public String toString() {
        return "Legacy Tunneled " + this.masterConn;
    }

    private class TunnelOutputStream
    extends OutputStream {
        private static final int MAX_FRAME_SIZE = 96;

        private TunnelOutputStream() {
        }

        private int indexOf(byte[] b, int off, int len, int c) {
            for (int i = off; i < len; ++i) {
                if (b[i] != c) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OutputStream masterOutStream = MpsLegacyTunnelConnection.this.masterConn.getOutputStream();
            while (len > 0) {
                int frameLength = Math.min(len, 96);
                int index = this.indexOf(b, off, off + frameLength, 13);
                if (index == -1) {
                    throw new IOException("CR not present in the frame");
                }
                byte[] frame = Arrays.copyOfRange(b, off, index);
                masterOutStream.write("DAT ".getBytes());
                if (MpsLegacyTunnelConnection.this.slaveEID != null && !MpsLegacyTunnelConnection.this.linked) {
                    masterOutStream.write((MpsLegacyTunnelConnection.this.slaveEID + " ").getBytes());
                }
                masterOutStream.write(frame);
                masterOutStream.write(13);
                if (MpsLegacyTunnelConnection.this.getLogger().isTraceEnabled()) {
                    MpsLegacyTunnelConnection.this.getLogger().trace("Tunneled " + MpsLegacyTunnelConnection.this.masterConn + " send DAT " + (MpsLegacyTunnelConnection.this.slaveEID != null ? MpsLegacyTunnelConnection.this.slaveEID + " " : " ") + new String(frame));
                }
                masterOutStream.flush();
                off += 96;
                len -= 96;
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }
    }
}

