/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection;

import com.metratec.lib.connection.CommConnectionException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Hashtable;

public abstract class ICommConnection {
    public static final int SERIAL_PORT_NOT_EXIST = 17;
    public static final int SERIAL_PARAMETER_NOT_SET = 18;
    public static final int SERIAL_NO_ACCESS = 19;
    public static final int SERIAL_NOT_INITIALISED = 20;
    public static final int USB_SET_BAUDRATE = 34;
    public static final int USB_SET_DATA_CHARACTERISTICS = 35;
    public static final int USB_SET_FLOWCONTROL = 36;
    public static final int USB_SET_TIMEOUTS = 37;
    public static final int ETHERNET_TIMEOUT = 49;
    public static final int ETHERNET_UNKNOWN_HOST = 50;
    public static final int USER_ERRORCODE_01 = 65;
    public static final int USER_ERRORCODE_02 = 66;
    public static final int USER_ERRORCODE_03 = 67;
    public static final int USER_ERRORCODE_04 = 68;
    public static final int USER_ERRORCODE_05 = 69;
    public static final int UNHANDLED_ERROR = 1;
    public static final int NO_LIBRARY_FOUND = 2;
    public static final int NO_DEVICES_FOUND = 3;
    public static final int DEVICE_IN_USE = 4;
    public static final int WRONG_PARAMETER = 5;
    public static final int CONNECTION_LOST = 6;
    public static final int SET_CONFIGURATION = 9;
    public static final int NOT_INITIALISED = 7;
    public static final int RECV_TIMEOUT = 8;
    public static final int NOT_AVAILABLE = 10;

    public abstract void connect() throws CommConnectionException;

    public abstract void disconnect() throws CommConnectionException;

    public void send(String senddata) throws CommConnectionException {
        this.send(senddata.getBytes(Charset.forName("ISO-8859-1")));
    }

    public abstract void send(byte[] var1) throws CommConnectionException;

    public String recv(int ... terminators) throws CommConnectionException {
        return this.receive(terminators).toString();
    }

    public StringBuilder receive(int ... terminators) throws CommConnectionException {
        int c;
        StringBuilder data = new StringBuilder();
        Arrays.sort(terminators);
        do {
            if ((c = this.recv()) < 0) {
                throw new CommConnectionException(8, data.toString());
            }
            data.append((char)c);
        } while (Arrays.binarySearch(terminators, c) < 0);
        return data;
    }

    public abstract int recv() throws CommConnectionException;

    public void recv(byte[] b, int off, int len) throws CommConnectionException {
        while (len > 0) {
            int c = this.recv();
            if (c < 0) {
                throw new CommConnectionException(8);
            }
            b[off++] = (byte)c;
            --len;
        }
    }

    public void recv(byte[] b) throws CommConnectionException {
        this.recv(b, 0, b.length);
    }

    public abstract boolean isConnected();

    public abstract Hashtable<String, Object> getInfo();

    public abstract void setSettings(Hashtable<String, String> var1);

    public abstract InputStream getInputStream();

    public abstract OutputStream getOutputStream();

    public abstract int dataAvailable() throws CommConnectionException;

    public abstract void setRecvTimeout(int var1) throws CommConnectionException;

    public abstract int getRecvTimeout();

    public abstract void setConnectionTimeout(int var1);

    public abstract int getConnectionTimeout();
}

