/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection;

import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class FileConnection
extends ICommConnection {
    protected OutputStream outputstream = null;
    protected InputStream inputstream = null;
    private String portName;
    private int recvTimeout = 2000;

    public FileConnection(String portName) {
        this.portName = portName;
    }

    @Override
    public void connect() throws CommConnectionException {
        File file = new File(this.portName);
        try {
            this.outputstream = new FileOutputStream(file);
            this.inputstream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new CommConnectionException(17, "Specified serial port " + this.portName + " could not be opened: " + e.getMessage());
        }
    }

    @Override
    public void disconnect() throws CommConnectionException {
        try {
            this.inputstream.close();
            this.inputstream = null;
            this.outputstream.close();
            this.outputstream = null;
        }
        catch (IOException e) {
            throw new CommConnectionException(19, "No access to Output-/InputStream " + e.getMessage());
        }
    }

    @Override
    public void send(byte[] senddata) throws CommConnectionException {
        try {
            this.outputstream.write(senddata);
            this.outputstream.flush();
        }
        catch (NullPointerException e) {
            if (senddata == null) {
                throw new CommConnectionException(5, "data is null");
            }
            throw new CommConnectionException(7, "not initialized");
        }
        catch (IOException e) {
            try {
                this.disconnect();
            }
            catch (CommConnectionException commConnectionException) {
                // empty catch block
            }
            throw new CommConnectionException(6, e.getMessage());
        }
    }

    @Override
    public int recv() throws CommConnectionException {
        try {
            long maxTimeMillis = System.currentTimeMillis() + (long)this.recvTimeout;
            while (this.inputstream.available() == 0 && System.currentTimeMillis() < maxTimeMillis) {
            }
            if (this.inputstream.available() == 0) {
                return -1;
            }
            int c = this.inputstream.read();
            if (c < 0) {
                try {
                    this.disconnect();
                }
                catch (CommConnectionException commConnectionException) {
                    // empty catch block
                }
                throw new CommConnectionException(6, "device closed");
            }
            return c;
        }
        catch (IOException e) {
            try {
                this.disconnect();
            }
            catch (CommConnectionException commConnectionException) {
                // empty catch block
            }
            throw new CommConnectionException(6, e.getMessage());
        }
    }

    @Override
    public boolean isConnected() {
        return this.inputstream != null;
    }

    @Override
    public Hashtable<String, Object> getInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("type", "file");
        info.put("portname", this.portName);
        return info;
    }

    @Override
    public void setSettings(Hashtable<String, String> settings) {
        String portname = settings.get("portname");
        if (null != portname) {
            this.portName = portname;
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputstream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputstream;
    }

    @Override
    public int dataAvailable() throws CommConnectionException {
        try {
            return this.inputstream.available();
        }
        catch (NullPointerException e) {
            throw new CommConnectionException(7, "not initialize");
        }
        catch (IOException e) {
            throw new CommConnectionException(6, e.getMessage());
        }
    }

    @Override
    public void setRecvTimeout(int timeout) {
        this.recvTimeout = timeout;
    }

    @Override
    public int getRecvTimeout() {
        return this.recvTimeout;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
    }

    @Override
    public int getConnectionTimeout() {
        return 0;
    }
}

