/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection;

import java.io.IOException;

public class CommConnectionException
extends IOException {
    private static final long serialVersionUID = 1L;
    private int errorcode = 0;

    public CommConnectionException() {
    }

    public CommConnectionException(String s) {
        super(s);
    }

    public CommConnectionException(int errorcode) {
        this.errorcode = errorcode;
    }

    public CommConnectionException(int errorcode, String s) {
        super(s);
        this.errorcode = errorcode;
    }

    public int getErrorCode() {
        return this.errorcode;
    }

    public String getErrorDescription() {
        switch (this.errorcode) {
            case 17: {
                return "Specified serial port does not exist.";
            }
            case 18: {
                return "Could not set interface parameter.";
            }
            case 19: {
                return "No access to the input/output stream.";
            }
            case 20: {
                return "Could not initialize the RS232 connection.";
            }
            case 34: {
                return "Setting baudrate for the USB connection failed.";
            }
            case 35: {
                return "Setting data characteristics for the USB connection failed.";
            }
            case 36: {
                return "Setting flow control for the USB connection failed.";
            }
            case 37: {
                return "Setting timeouts for the USB connection failed.";
            }
            case 49: {
                return "Ethernet connection timeout.";
            }
            case 50: {
                return "Host not found.";
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                return String.format("User-specified error (%d).", this.errorcode - 65);
            }
            case 1: {
                return "Unhandled Error: " + this.getMessage();
            }
            case 2: {
                return "Could not find the required Java library for the connection.";
            }
            case 3: {
                return "No devices for a connection found.";
            }
            case 4: {
                return "Device is in use, could no connect.";
            }
            case 5: {
                return "Wrong parameter.";
            }
            case 6: {
                return "Lost the connection.";
            }
            case 9: {
                return "Error while setting parameters.";
            }
            case 7: {
                return "Connection is not initialized.";
            }
            case 8: {
                return "Receiving data timed out.";
            }
        }
        return String.format("Unknown error (%d).", this.errorcode);
    }
}

