/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.connection;

import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTcpConnection
extends ICommConnection {
    private final Logger logger = LoggerFactory.getLogger(AbstractTcpConnection.class);
    private Socket socket = null;
    private String ipAddress = null;
    private int port = 0;
    private OutputStream outputstream = null;
    private InputStream inputstream = null;
    private int recvTimeout = 2000;
    private int connectTimeout = 1000;
    private boolean isServerConnection = false;

    protected AbstractTcpConnection(String ip, int port) {
        this.ipAddress = ip;
        this.port = port;
    }

    public AbstractTcpConnection(Socket socket) throws CommConnectionException {
        this(socket, false);
    }

    public AbstractTcpConnection(Socket socket, boolean isServerConnection) throws CommConnectionException {
        if (!socket.isConnected()) {
            throw new CommConnectionException(7, "Socket is not connected");
        }
        this.socket = socket;
        this.isServerConnection = isServerConnection;
        this.ipAddress = socket.getInetAddress().getHostAddress();
        this.port = socket.getPort();
        try {
            this.initializeSocket();
        }
        catch (IOException e) {
            throw new CommConnectionException(7, e.getMessage());
        }
    }

    @Override
    public void disconnect() throws CommConnectionException {
        if (this.inputstream != null) {
            try {
                try {
                    this.socket.shutdownOutput();
                    this.socket.shutdownInput();
                }
                catch (IOException | UnsupportedOperationException exception) {
                    // empty catch block
                }
                this.inputstream = null;
                this.outputstream = null;
                this.socket.close();
            }
            catch (IOException e) {
                throw new CommConnectionException(1, e.getMessage());
            }
        }
    }

    protected abstract Socket createNewSocket(String var1, int var2) throws IOException;

    public boolean isServerConnection() {
        return this.isServerConnection;
    }

    @Override
    public void connect() throws CommConnectionException {
        if (this.isConnected()) {
            return;
        }
        if (this.isServerConnection) {
            throw new CommConnectionException(10, "Connection was inialized by the client");
        }
        if (this.port == 0 || this.ipAddress == null) {
            throw new CommConnectionException(5, "ip-address and/or port is not set");
        }
        try {
            this.socket = this.createNewSocket(this.ipAddress, this.port);
            this.initializeSocket();
        }
        catch (UnknownHostException e) {
            throw new CommConnectionException(50, e.getMessage());
        }
        catch (IOException e) {
            throw new CommConnectionException(49, e.getMessage());
        }
    }

    private void initializeSocket() throws IOException {
        this.socket.setSoTimeout(this.recvTimeout);
        this.outputstream = new BufferedOutputStream(this.socket.getOutputStream());
        this.inputstream = new BufferedInputStream(this.socket.getInputStream());
    }

    public void setIPAddress(String ipaddress) {
        this.ipAddress = ipaddress;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isConnected() {
        if (null == this.socket || this.socket.isClosed()) {
            return false;
        }
        return this.socket.isConnected();
    }

    @Override
    public int recv() throws CommConnectionException {
        try {
            int c = this.inputstream.read();
            if (c < 0) {
                block11: {
                    try {
                        this.disconnect();
                    }
                    catch (CommConnectionException e) {
                        if (!this.logger.isDebugEnabled()) break block11;
                        String message = this.toString() + " error disconnect " + e.getMessage();
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace(message, (Throwable)e);
                        }
                        this.logger.debug(message);
                    }
                }
                throw new CommConnectionException(6, "socket closed");
            }
            return c;
        }
        catch (NullPointerException e) {
            throw new CommConnectionException(7, "not initialize");
        }
        catch (SocketTimeoutException e) {
            return -1;
        }
        catch (IOException e) {
            block12: {
                try {
                    this.disconnect();
                }
                catch (CommConnectionException e1) {
                    if (!this.logger.isDebugEnabled()) break block12;
                    String message = this.toString() + " error disconnect " + e.getMessage();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace(message, (Throwable)e);
                        break block12;
                    }
                    this.logger.debug(message);
                }
            }
            throw new CommConnectionException(6, e.getMessage());
        }
    }

    @Override
    public void setRecvTimeout(int timeout) throws CommConnectionException {
        this.recvTimeout = timeout;
        if (this.isConnected()) {
            try {
                this.socket.setSoTimeout(this.recvTimeout);
            }
            catch (SocketException e) {
                throw new CommConnectionException(9, e.getMessage());
            }
        }
    }

    @Override
    public void send(byte[] senddata) throws CommConnectionException {
        try {
            this.outputstream.write(senddata);
            this.outputstream.flush();
        }
        catch (NullPointerException e) {
            if (senddata == null) {
                throw new CommConnectionException(5, "data are null");
            }
            throw new CommConnectionException(7, "not initialize");
        }
        catch (IOException e) {
            block7: {
                try {
                    this.disconnect();
                }
                catch (CommConnectionException e1) {
                    if (!this.logger.isDebugEnabled()) break block7;
                    String message = this.toString() + " error disconnect " + e.getMessage();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace(message, (Throwable)e);
                        break block7;
                    }
                    this.logger.debug(message);
                }
            }
            throw new CommConnectionException(6, e.getMessage());
        }
    }

    @Override
    public int dataAvailable() throws CommConnectionException {
        try {
            return this.inputstream.available();
        }
        catch (NullPointerException e) {
            throw new CommConnectionException(7, "not initialize");
        }
        catch (IOException e) {
            throw new CommConnectionException(6, e.getMessage());
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputstream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputstream;
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public Hashtable<String, Object> getInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("type", "ethernet");
        info.put("ip", this.ipAddress);
        info.put("port", this.port);
        return info;
    }

    @Override
    public void setSettings(Hashtable<String, String> settings) throws IllegalArgumentException {
        String ip;
        String port = settings.get("port");
        if (null != port) {
            try {
                this.port = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Port should be a number");
            }
        }
        if (null != (ip = settings.get("ip"))) {
            this.ipAddress = ip;
        }
    }

    @Override
    public int getRecvTimeout() {
        return this.recvTimeout;
    }

    public static boolean isAlive(String ipAdress, int time) throws CommConnectionException {
        try {
            return InetAddress.getByName(ipAdress).isReachable(time);
        }
        catch (UnknownHostException e) {
            throw new CommConnectionException(50, e.getMessage());
        }
        catch (IOException e) {
            throw new CommConnectionException(1, e.getMessage());
        }
    }

    public boolean isAlive(int time) throws CommConnectionException {
        return AbstractTcpConnection.isAlive(this.ipAddress, time);
    }

    @Override
    public void setConnectionTimeout(int time) {
        this.connectTimeout = time;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectTimeout;
    }
}

