/*
 * Decompiled with CFR 0.152.
 */
package jd2xx;

import cz.adamh.utils.NativeUtils;
import java.io.IOException;
import java.util.TooManyListenersException;
import jd2xx.JD2XXEvent;
import jd2xx.JD2XXEventListener;

public class JD2XX
implements Runnable {
    public static final int OK = 0;
    public static final int INVALID_HANDLE = 1;
    public static final int DEVICE_NOT_FOUND = 2;
    public static final int DEVICE_NOT_OPENED = 3;
    public static final int IO_ERROR = 4;
    public static final int INSUFFICIENT_RESOURCES = 5;
    public static final int INVALID_PARAMETER = 6;
    public static final int INVALID_BAUD_RATE = 7;
    public static final int DEVICE_NOT_OPENED_FOR_ERASE = 8;
    public static final int DEVICE_NOT_OPENED_FOR_WRITE = 9;
    public static final int FAILED_TO_WRITE_DEVICE = 10;
    public static final int EEPROM_READ_FAILED = 11;
    public static final int EEPROM_WRITE_FAILED = 12;
    public static final int EEPROM_ERASE_FAILED = 13;
    public static final int EEPROM_NOT_PRESENT = 14;
    public static final int EEPROM_NOT_PROGRAMMED = 15;
    public static final int INVALID_ARGS = 16;
    public static final int NOT_SUPPORTED = 17;
    public static final int OTHER_ERROR = 18;
    public static final int DEVICE_LIST_NOT_READY = 19;
    public static final int OPEN_BY_SERIAL_NUMBER = 1;
    public static final int OPEN_BY_DESCRIPTION = 2;
    public static final int OPEN_BY_LOCATION = 4;
    public static final int LIST_NUMBER_ONLY = Integer.MIN_VALUE;
    public static final int LIST_BY_INDEX = 0x40000000;
    public static final int LIST_ALL = 0x20000000;
    public static final int LIST_MASK = -536870912;
    public static final int BAUD_300 = 300;
    public static final int BAUD_600 = 600;
    public static final int BAUD_1200 = 1200;
    public static final int BAUD_2400 = 2400;
    public static final int BAUD_4800 = 4800;
    public static final int BAUD_9600 = 9600;
    public static final int BAUD_14400 = 14400;
    public static final int BAUD_19200 = 19200;
    public static final int BAUD_38400 = 38400;
    public static final int BAUD_57600 = 57600;
    public static final int BAUD_115200 = 115200;
    public static final int BAUD_230400 = 230400;
    public static final int BAUD_460800 = 460800;
    public static final int BAUD_921600 = 921600;
    public static final int BITS_8 = 8;
    public static final int BITS_7 = 7;
    public static final int BITS_6 = 6;
    public static final int BITS_5 = 5;
    public static final int STOP_BITS_1 = 0;
    public static final int STOP_BITS_1_5 = 1;
    public static final int STOP_BITS_2 = 2;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_SPACE = 4;
    public static final int FLOW_NONE = 0;
    public static final int FLOW_RTS_CTS = 256;
    public static final int FLOW_DTR_DSR = 512;
    public static final int FLOW_XON_XOFF = 1024;
    public static final int PURGE_RX = 1;
    public static final int PURGE_TX = 2;
    public static final int EVENT_RXCHAR = 1;
    public static final int EVENT_MODEM_STATUS = 2;
    public static final int EVENT_LINE_STATUS = 4;
    public static final int DEFAULT_RX_TIMEOUT = 300;
    public static final int DEFAULT_TX_TIMEOUT = 300;
    public static final int DEVICE_BM = 0;
    public static final int DEVICE_AM = 1;
    public static final int DEVICE_100AX = 2;
    public static final int DEVICE_UNKNOWN = 3;
    public static final int DEVICE_2232C = 4;
    public static final int DEVICE_232R = 5;
    public static final int DEVICE_2232H = 6;
    public static final int DEVICE_4232H = 7;
    public static final int DEVICE_232H = 8;
    public static final int FLAGS_OPENED = 1;
    public static final int FLAGS_HISPEED = 2;
    public static final int BITMODE_RESET = 0;
    public static final int BITMODE_ASYNC_BITBANG = 1;
    public static final int BITMODE_MPSSE = 2;
    public static final int BITMODE_SYNC_BITBANG = 4;
    public static final int BITMODE_MCU_HOST = 8;
    public static final int BITMODE_FAST_SERIAL = 16;
    public static final int BITMODE_CBUS_BITBANG = 32;
    public static final int BITMODE_SYNC_FIFO = 64;
    public static final int FT232R_CBUS_TXDEN = 0;
    public static final int FT232R_CBUS_PWRON = 1;
    public static final int FT232R_CBUS_RXLED = 2;
    public static final int FT232R_CBUS_TXLED = 3;
    public static final int FT232R_CBUS_TXRXLED = 4;
    public static final int FT232R_CBUS_SLEEP = 5;
    public static final int FT232R_CBUS_CLK48 = 6;
    public static final int FT232R_CBUS_CLK24 = 7;
    public static final int FT232R_CBUS_CLK12 = 8;
    public static final int FT232R_CBUS_CLK6 = 9;
    public static final int FT232R_CBUS_IOMODE = 10;
    public static final int FT232R_CBUS_BITBANG_WR = 11;
    public static final int FT232R_CBUS_BITBANG_RD = 12;
    public static final int FT232H_CBUS_TRISTATE = 0;
    public static final int FT232H_CBUS_TXLED = 1;
    public static final int FT232H_CBUS_RXLED = 2;
    public static final int FT232H_CBUS_TXRXLED = 3;
    public static final int FT232H_CBUS_PWREN = 4;
    public static final int FT232H_CBUS_SLEEP = 5;
    public static final int FT232H_CBUS_DRIVE_0 = 6;
    public static final int FT232H_CBUS_DRIVE_1 = 7;
    public static final int FT232H_CBUS_IOMODE = 8;
    public static final int FT232H_CBUS_TXDEN = 9;
    public static final int FT232H_CBUS_CLK30 = 10;
    public static final int FT232H_CBUS_CLK15 = 11;
    public static final int FT232H_CBUS_CLK7_5 = 12;
    public static final int FT_X_SERIES_CBUS_TRISTATE = 0;
    public static final int FT_X_SERIES_CBUS_TXLED = 1;
    public static final int FT_X_SERIES_CBUS_RXLED = 2;
    public static final int FT_X_SERIES_CBUS_TXRXLED = 3;
    public static final int FT_X_SERIES_CBUS_PWREN = 4;
    public static final int FT_X_SERIES_CBUS_SLEEP = 5;
    public static final int FT_X_SERIES_CBUS_DRIVE_0 = 6;
    public static final int FT_X_SERIES_CBUS_DRIVE_1 = 7;
    public static final int FT_X_SERIES_CBUS_IOMODE = 8;
    public static final int FT_X_SERIES_CBUS_TXDEN = 9;
    public static final int FT_X_SERIES_CBUS_CLK21 = 10;
    public static final int FT_X_SERIES_CBUS_CLK12 = 11;
    public static final int FT_X_SERIES_CBUS_CLK6 = 12;
    public static final int FT_X_SERIES_CBUS_BCD_CHARGER = 13;
    public static final int FT_X_SERIES_CBUS_BCD_CHARGER_N = 14;
    public static final int FT_X_SERIES_CBUS_I2C_TXE = 15;
    public static final int FT_X_SERIES_CBUS_I2C_RXF = 16;
    public static final int FT_X_SERIES_CBUS_VBUS_SENSE = 17;
    public static final int FT_X_SERIES_CBUS_BITBANG_WR = 18;
    public static final int FT_X_SERIES_CBUS_BITBANG_RD = 19;
    public static final int FT_X_SERIES_CBUS_TIMESTAMP = 20;
    public static final int FT_X_SERIES_CBUS_KEEP_AWAKE = 21;
    protected long handle = -1L;
    protected int event = -1;
    protected int mask = 0;
    protected boolean kill = false;
    protected JD2XXEventListener listener = null;
    protected Thread notifier = null;

    public native int getLibraryVersion();

    public native void setVIDPID(int var1, int var2) throws IOException;

    public native int createDeviceInfoList();

    public native DeviceInfo getDeviceInfoDetail(int var1) throws IOException;

    public native void open(int var1) throws IOException;

    public native void close() throws IOException;

    public native Object[] listDevices(int var1) throws IOException;

    public native void openEx(String var1, int var2) throws IOException;

    public native void openEx(int var1, int var2) throws IOException;

    public native int read(byte[] var1, int var2, int var3) throws IOException;

    public native int write(byte[] var1, int var2, int var3) throws IOException;

    public native void setBaudRate(int var1) throws IOException;

    public native void setDivisor(int var1) throws IOException;

    public native void setDataCharacteristics(int var1, int var2, int var3) throws IOException;

    public native void setFlowControl(int var1, int var2, int var3) throws IOException;

    public native void resetDevice() throws IOException;

    public native void setDtr() throws IOException;

    public native void clrDtr() throws IOException;

    public native void setRts() throws IOException;

    public native void clrRts() throws IOException;

    public native int getModemStatus() throws IOException;

    public native void setChars(int var1, boolean var2, int var3, boolean var4) throws IOException;

    public native void purge(int var1) throws IOException;

    public native void setTimeouts(int var1, int var2) throws IOException;

    public native int getQueueStatus() throws IOException;

    public native void setBreakOn() throws IOException;

    public native void setBreakOff() throws IOException;

    public native int[] getStatus() throws IOException;

    public native void setEventNotification(int var1, int var2) throws IOException;

    public native void setWaitMask(int var1) throws IOException;

    public native int waitOnMask() throws IOException;

    public native int getEventStatus() throws IOException;

    public native short readEE(int var1) throws IOException;

    public native void writeEE(int var1, short var2) throws IOException;

    public native void eraseEE() throws IOException;

    public native void eeProgram(ProgramData var1) throws IOException;

    public native void eeProgramEx(ProgramData var1, String var2, String var3, String var4, String var5) throws IOException;

    public native ProgramData eeRead() throws IOException;

    public native ProgramData eeReadEx(String var1, String var2, String var3, String var4) throws IOException;

    public native int eeUASize() throws IOException;

    public native void eeUAWrite(byte[] var1) throws IOException;

    public native byte[] eeUARead(int var1) throws IOException;

    public native void setLatencyTimer(int var1) throws IOException;

    public native int getLatencyTimer() throws IOException;

    public native void setBitMode(int var1, int var2) throws IOException;

    public native int getBitMode() throws IOException;

    public native void setUSBParameters(int var1, int var2) throws IOException;

    public native void setDeadmanTimeout(int var1) throws IOException;

    public native DeviceInfo getDeviceInfo() throws IOException;

    public native void stopInTask() throws IOException;

    public native void restartInTask() throws IOException;

    public native void setResetPipeRetryCount(int var1) throws IOException;

    public native void resetPort() throws IOException;

    public native void cyclePort() throws IOException;

    public native int getDriverVersion();

    public native void rescan();

    public native void reload(int var1, int var2);

    public native int getComPortNumber() throws IOException;

    public native int eeReadConfig(int var1) throws IOException;

    public native void eeWriteConfig(int var1, int var2) throws IOException;

    public native int eeReadEcc(int var1) throws IOException;

    public native int getQueueStatusEx() throws IOException;

    public native void registerEvent(int var1) throws IOException;

    public synchronized native void signalEvent();

    public native int waitEvent();

    public JD2XX() {
    }

    public JD2XX(int n) throws IOException {
        this.open(n);
    }

    public JD2XX(String string, int n) throws IOException {
        this.openEx(string, n);
    }

    public JD2XX(int n, int n2) throws IOException {
        this.openEx(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void openBySerialNumber(String string) throws IOException {
        this.openEx(string, 1);
    }

    public void openByDescription(String string) throws IOException {
        this.openEx(string, 2);
    }

    public void openByLocation(int n) throws IOException {
        this.openEx(n, 4);
    }

    public Object[] listDevicesBySerialNumber() throws IOException {
        return this.listDevices(1);
    }

    public Object[] listDevicesByDescription() throws IOException {
        return this.listDevices(2);
    }

    public Object[] listDevicesByLocation() throws IOException {
        return this.listDevices(4);
    }

    public byte[] read(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = this.read(byArray);
        if (n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray) != 1) {
            throw new IOException("io error");
        }
        return byArray[0] & 0xFF;
    }

    public int write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        return this.write(byArray);
    }

    public int write(byte[] byArray) throws IOException {
        return this.write(byArray, 0, byArray.length);
    }

    public void addEventListener(JD2XXEventListener jD2XXEventListener) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = jD2XXEventListener;
    }

    public void removeEventListener() {
        this.listener = null;
    }

    public void dispatchEvent(int n) {
        if (this.listener != null) {
            this.listener.jd2xxEvent(new JD2XXEvent(this, n));
        }
    }

    public void notifyOnEvent(int n, boolean bl) throws IOException {
        int n2;
        int n3 = n2 = bl ? this.mask | n : this.mask & ~n;
        if (n2 != 0) {
            if (this.notifier != null) {
                return;
            }
            this.kill = false;
            this.notifier = new Thread(this);
            this.registerEvent(n2);
            this.notifier.start();
        } else {
            if (this.notifier == null) {
                return;
            }
            this.kill = true;
            this.signalEvent();
            while (this.notifier.isAlive()) {
            }
            this.registerEvent(0);
            this.notifier = null;
        }
        this.mask = n2;
    }

    public void notifyOnRxchar(boolean bl) throws IOException {
        this.notifyOnEvent(1, bl);
    }

    public void notifyOnModemStatus(boolean bl) throws IOException {
        this.notifyOnEvent(2, bl);
    }

    @Override
    public void run() {
        while (true) {
            int n = this.waitEvent();
            if (this.kill) break;
            this.dispatchEvent(n);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        JD2XX jD2XX = new JD2XX();
        Object[] objectArray = jD2XX.listDevicesBySerialNumber();
        for (n = 0; n < objectArray.length; ++n) {
            System.out.println(objectArray[n]);
        }
        objectArray = jD2XX.listDevicesByDescription();
        for (n = 0; n < objectArray.length; ++n) {
            System.out.println(objectArray[n]);
        }
        objectArray = jD2XX.listDevicesByLocation();
        for (n = 0; n < objectArray.length; ++n) {
            System.out.println(Integer.toHexString((Integer)objectArray[n]));
        }
        n = jD2XX.createDeviceInfoList();
        DeviceInfo deviceInfo = jD2XX.getDeviceInfoDetail(0);
        System.out.println(deviceInfo.toString());
        jD2XX.open(0);
        String string = "Hello dude. This is the message.";
        int n2 = jD2XX.write(string.getBytes());
        System.out.println(n2 + " bytes sent.");
        ProgramData programData = jD2XX.eeRead();
        System.out.println(programData.toString());
        deviceInfo = jD2XX.getDeviceInfo();
        System.out.println(deviceInfo.toString());
        try {
            jD2XX.addEventListener(new JD2XXEventListener(){

                @Override
                public void jd2xxEvent(JD2XXEvent jD2XXEvent) {
                    JD2XX jD2XX = (JD2XX)jD2XXEvent.getSource();
                    int n = jD2XXEvent.getEventType();
                    try {
                        if ((n & 1) != 0) {
                            int n2 = jD2XX.getQueueStatus();
                            System.out.println("RX event: " + new String(jD2XX.read(n2)));
                        } else if ((n & 2) != 0) {
                            System.out.println("Modem status event");
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        jD2XX.notifyOnEvent(3, true);
    }

    static {
        String string = System.getProperty("sun.arch.data.model");
        String string2 = System.getProperty("os.name").toLowerCase();
        StringBuilder stringBuilder = new StringBuilder("/jni/");
        if (string2.contains("win")) {
            stringBuilder.append("win/");
        } else if (string2.contains("linux")) {
            stringBuilder.append("linux/");
        } else if (string2.contains("os x")) {
            stringBuilder.append("mac/");
        } else {
            throw new UnsatisfiedLinkError("Loading JD2XX JNI: Unsupported operating system (" + string2 + ")");
        }
        if (string.equals("32")) {
            stringBuilder.append("x86_32/");
        } else if (string.equals("64")) {
            stringBuilder.append("x86_64/");
        } else {
            throw new UnsatisfiedLinkError("Loading JD2XX JNI: Unknown runtime data model (" + string + ")");
        }
        if (string2.contains("win")) {
            stringBuilder.append("jd2xx.dll");
        } else if (string2.contains("linux")) {
            stringBuilder.append("libjd2xx.so");
        } else if (string2.contains("os x")) {
            stringBuilder.append("libjd2xx.jnilib");
        }
        try {
            NativeUtils.loadLibraryFromJar(stringBuilder.toString());
        }
        catch (IOException iOException) {
            throw new UnsatisfiedLinkError(iOException.getMessage());
        }
    }

    public static class DeviceInfo {
        public int index;
        public int flags;
        public int type;
        public int id;
        public int location;
        public String serial;
        public String description;
        public long handle;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("index: " + Integer.toString(this.index));
            stringBuffer.append(", flags: 0x" + Integer.toHexString(this.flags));
            stringBuffer.append(", type: 0x" + Integer.toHexString(this.type));
            stringBuffer.append(", id: 0x" + Integer.toHexString(this.id));
            stringBuffer.append(", location: 0x" + Integer.toHexString(this.location));
            stringBuffer.append(", serial: " + this.serial);
            stringBuffer.append(", description: " + this.description);
            stringBuffer.append(", handle: 0x" + Long.toHexString(this.handle));
            return stringBuffer.toString();
        }
    }

    public static class ProgramData {
        public int signature1 = 0;
        public int signature2 = -1;
        public int version;
        public int vendorID;
        public int productID;
        public String manufacturer;
        public String manufacturerID;
        public String description;
        public String serialNumber;
        public int maxPower;
        public boolean pnp;
        public boolean selfPowered;
        public boolean remoteWakeup;
        public boolean rev4;
        public boolean isoIn;
        public boolean isoOut;
        public boolean pullDownEnable;
        public boolean serNumEnable;
        public boolean usbVersionEnable;
        public int usbVersion;
        public boolean rev5;
        public boolean isoInA;
        public boolean isoInB;
        public boolean isoOutA;
        public boolean isoOutB;
        public boolean pullDownEnable5;
        public boolean serNumEnable5;
        public boolean usbVersionEnable5;
        public int usbVersion5;
        public boolean aIsHighCurrent;
        public boolean bIsHighCurrent;
        public boolean ifAIsFifo;
        public boolean ifAIsFifoTar;
        public boolean ifAIsFastSer;
        public boolean aIsVCP;
        public boolean ifBIsFifo;
        public boolean ifBIsFifoTar;
        public boolean ifBIsFastSer;
        public boolean bIsVCP;
        public boolean useExtOsc;
        public boolean highDriveIOs;
        public int endpointSize;
        public boolean pullDownEnableR;
        public boolean serNumEnableR;
        public boolean invertTXD;
        public boolean invertRXD;
        public boolean invertRTS;
        public boolean invertCTS;
        public boolean invertDTR;
        public boolean invertDSR;
        public boolean invertDCD;
        public boolean invertRI;
        public int cbus0;
        public int cbus1;
        public int cbus2;
        public int cbus3;
        public int cbus4;
        public boolean rIsD2XX;
        public boolean pullDownEnable7;
        public boolean serNumEnable7;
        public boolean alSlowSlew;
        public boolean alSchmittInput;
        public int alDriveCurrent;
        public boolean ahSlowSlew;
        public boolean ahSchmittInput;
        public int ahDriveCurrent;
        public boolean blSlowSlew;
        public boolean blSchmittInput;
        public int blDriveCurrent;
        public boolean bhSlowSlew;
        public boolean bhSchmittInput;
        public int bhDriveCurrent;
        public boolean ifAIsFifo7;
        public boolean ifAIsFifoTar7;
        public boolean ifAIsFastSer7;
        public boolean aIsVCP7;
        public boolean ifBIsFifo7;
        public boolean ifBIsFifoTar7;
        public boolean ifBIsFastSer7;
        public boolean bIsVCP7;
        public boolean powerSaveEnable;
        public boolean pullDownEnable8;
        public boolean serNumEnable8;
        public boolean aSlowSlew;
        public boolean aSchmittInput;
        public int aDriveCurrent;
        public boolean bSlowSlew;
        public boolean bSchmittInput;
        public int bDriveCurrent;
        public boolean cSlowSlew;
        public boolean cSchmittInput;
        public int cDriveCurrent;
        public boolean dSlowSlew;
        public boolean dSchmittInput;
        public int dDriveCurrent;
        public boolean aRIIsTXDEN;
        public boolean bRIIsTXDEN;
        public boolean cRIIsTXDEN;
        public boolean dRIIsTXDEN;
        public boolean aIsVCP8;
        public boolean bIsVCP8;
        public boolean cIsVCP8;
        public boolean dIsVCP8;
        public boolean pullDownEnableH;
        public boolean serNumEnableH;
        public boolean acSlowSlewH;
        public boolean acSchmittInputH;
        public int acDriveCurrentH;
        public boolean adSlowSlewH;
        public boolean adSchmittInputH;
        public int adDriveCurrentH;
        public int cbus0H;
        public int cbus1H;
        public int cbus2H;
        public int cbus3H;
        public int cbus4H;
        public int cbus5H;
        public int cbus6H;
        public int cbus7H;
        public int cbus8H;
        public int cbus9H;
        public boolean isFifoH;
        public boolean isFifoTarH;
        public boolean isFastSerH;
        public boolean isFt1248H;
        public boolean ft1248CpolH;
        public boolean ft1248LsbH;
        public boolean ft1248FlowControlH;
        public boolean isVCPH;
        public boolean powerSaveEnableH;
        public boolean acSlowSlew;
        public boolean acSchmittInput;
        public int acDriveCurrent;
        public boolean adSlowSlew;
        public boolean adSchmittInput;
        public int adDriveCurrent;
        public int cbus5;
        public int cbus6;
        public boolean bcdEnable;
        public boolean bcdForceCbusPWREN;
        public boolean bcdDisableSleep;
        public int i2cSlaveAddress;
        public long i2cDeviceId;
        public boolean i2cDisableSchmitt;
        public boolean ft1248Cpol;
        public boolean ft1248Lsb;
        public boolean ft1248FlowControl;
        public boolean rs485EchoSuppress;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("signature1: 0x" + Integer.toHexString(this.signature1));
            stringBuffer.append(", signature2: 0x" + Integer.toHexString(this.signature2));
            stringBuffer.append(", version: 0x" + Integer.toHexString(this.version));
            stringBuffer.append(", vendorID: 0x" + Integer.toHexString(this.vendorID));
            stringBuffer.append(", productID: 0x" + Integer.toHexString(this.productID));
            stringBuffer.append(", manufacturer: " + this.manufacturer);
            stringBuffer.append(", manufacturerID: " + this.manufacturerID);
            stringBuffer.append(", description: " + this.description);
            stringBuffer.append(", serialNumber: " + this.serialNumber);
            stringBuffer.append(", maxPower: " + this.maxPower);
            stringBuffer.append(", pnp: " + this.pnp);
            stringBuffer.append(", selfPowered: " + this.selfPowered);
            stringBuffer.append(", remoteWakeup: " + this.remoteWakeup);
            stringBuffer.append(", rev4: " + this.rev4);
            stringBuffer.append(", isoIn: " + this.isoIn);
            stringBuffer.append(", isoOut: " + this.isoOut);
            stringBuffer.append(", pullDownEnable: " + this.pullDownEnable);
            stringBuffer.append(", serNumEnable: " + this.serNumEnable);
            stringBuffer.append(", usbVersionEnable: " + this.usbVersionEnable);
            stringBuffer.append(", usbVersion: 0x" + Integer.toHexString(this.usbVersion));
            stringBuffer.append(", rev5: " + this.rev5);
            stringBuffer.append(", isoInA: " + this.isoInA);
            stringBuffer.append(", isoInB: " + this.isoInB);
            stringBuffer.append(", isoOutA: " + this.isoOutA);
            stringBuffer.append(", isoOutB: " + this.isoOutB);
            stringBuffer.append(", pullDownEnable5: " + this.pullDownEnable5);
            stringBuffer.append(", serNumEnable5: " + this.serNumEnable5);
            stringBuffer.append(", usbVersionEnable5: " + this.usbVersionEnable5);
            stringBuffer.append(", usbVersion5: 0x" + Integer.toHexString(this.usbVersion5));
            stringBuffer.append(", aIsHighCurrent: " + this.aIsHighCurrent);
            stringBuffer.append(", bIsHighCurrent: " + this.bIsHighCurrent);
            stringBuffer.append(", ifAIsFifo: " + this.ifAIsFifo);
            stringBuffer.append(", ifAIsFifoTar: " + this.ifAIsFifoTar);
            stringBuffer.append(", ifAIsFastSer: " + this.ifAIsFastSer);
            stringBuffer.append(", aIsVCP: " + this.aIsVCP);
            stringBuffer.append(", ifBIsFifo: " + this.ifBIsFifo);
            stringBuffer.append(", ifBIsFifoTar: " + this.ifBIsFifoTar);
            stringBuffer.append(", ifBIsFastSer: " + this.ifBIsFastSer);
            stringBuffer.append(", bIsVCP: " + this.bIsVCP);
            stringBuffer.append(", useExtOsc: " + this.useExtOsc);
            stringBuffer.append(", highDriveIOs: " + this.highDriveIOs);
            stringBuffer.append(", endpointSize: " + this.endpointSize);
            stringBuffer.append(", pullDownEnableR: " + this.pullDownEnableR);
            stringBuffer.append(", serNumEnableR: " + this.serNumEnableR);
            stringBuffer.append(", invertTXD: " + this.invertTXD);
            stringBuffer.append(", invertRXD: " + this.invertRXD);
            stringBuffer.append(", invertRTS: " + this.invertRTS);
            stringBuffer.append(", invertCTS: " + this.invertCTS);
            stringBuffer.append(", invertDTR: " + this.invertDTR);
            stringBuffer.append(", invertDSR: " + this.invertDSR);
            stringBuffer.append(", invertDCD: " + this.invertDCD);
            stringBuffer.append(", invertRI: " + this.invertRI);
            stringBuffer.append(", cbus0: 0x" + Integer.toHexString(this.cbus0));
            stringBuffer.append(", cbus1: 0x" + Integer.toHexString(this.cbus1));
            stringBuffer.append(", cbus2: 0x" + Integer.toHexString(this.cbus2));
            stringBuffer.append(", cbus3: 0x" + Integer.toHexString(this.cbus3));
            stringBuffer.append(", cbus4: 0x" + Integer.toHexString(this.cbus4));
            stringBuffer.append(", cbus5: 0x" + Integer.toHexString(this.cbus5));
            stringBuffer.append(", cbus6: 0x" + Integer.toHexString(this.cbus6));
            stringBuffer.append(", rIsD2XX: " + this.rIsD2XX);
            stringBuffer.append(", acSlowSlew: " + this.acSlowSlew);
            stringBuffer.append(", acSchmittInput: " + this.acSchmittInput);
            stringBuffer.append(", acDriveCurrent: " + this.acDriveCurrent);
            stringBuffer.append(", adSlowSlew: " + this.adSlowSlew);
            stringBuffer.append(", adSchmittInput: " + this.adSchmittInput);
            stringBuffer.append(", adDriveCurrent: " + this.adDriveCurrent);
            stringBuffer.append(", bcdEnable: " + this.bcdEnable);
            stringBuffer.append(", bcdForceCbusPWREN: " + this.bcdForceCbusPWREN);
            stringBuffer.append(", bcdDisableSleep: " + this.bcdDisableSleep);
            stringBuffer.append(", i2cSlaveAddress: " + Integer.toHexString(this.i2cSlaveAddress));
            stringBuffer.append(", i2cDeviceId: " + Long.toHexString(this.i2cDeviceId));
            stringBuffer.append(", i2cDisableSchmitt: " + this.i2cDisableSchmitt);
            stringBuffer.append(", ft1248Cpol: " + this.ft1248Cpol);
            stringBuffer.append(", ft1248Lsb: " + this.ft1248Lsb);
            stringBuffer.append(", ft1248FlowControl: " + this.ft1248FlowControl);
            stringBuffer.append(", rs485EchoSuppress: " + this.rs485EchoSuppress);
            return stringBuffer.toString();
        }
    }
}

