/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx.utils;

import com.google.common.base.Predicate;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.Window;

public class WindowUtils {
    public static final Predicate<Window> isFocusedPopup = new Predicate<Window>(){

        public boolean apply(Window window) {
            return window instanceof PopupWindow && window.isFocused();
        }
    };

    public static Predicate<Window> isDecendant(final Window window) {
        return new Predicate<Window>(){

            public boolean apply(Window input) {
                Window parent = null;
                if (input instanceof Stage) {
                    parent = ((Stage)input).getOwner();
                } else if (input instanceof PopupWindow) {
                    parent = ((PopupWindow)input).getOwnerWindow();
                }
                return parent == window || parent != null && this.apply(parent);
            }
        };
    }
}

