/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.tuc.update;

import com.metratec.lib.tuc.update.CallbackInterface;
import com.metratec.lib.tuc.update.FlashException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TFTPServer {
    private static Logger logger = LoggerFactory.getLogger(TFTPServer.class);
    private static final int MAX_TRANSFER_SIZE = 512;
    protected String firmware;
    private int totalBytes;
    private int sentBytes;
    private final int firmwareHeaderLength = 40;
    private InetAddress localHost;
    private InetAddress expectedDeviceAddress;
    private CallbackInterface callbackInterface;

    public TFTPServer(InetAddress localHost, InetAddress expectedDeviceAddress, CallbackInterface callbackInterface) throws SocketException {
        this.localHost = localHost;
        this.expectedDeviceAddress = expectedDeviceAddress;
        this.callbackInterface = callbackInterface;
        DatagramSocket socket = new DatagramSocket(69, localHost);
        Throwable throwable = null;
        if (socket != null) {
            if (throwable != null) {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                socket.close();
            }
        }
    }

    public void setFirmwarePath(String path) {
        this.firmware = path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SocketAddress accept() throws IOException {
        byte[] buf = new byte[5];
        try (DatagramSocket socket = new DatagramSocket(69, this.localHost);){
            socket.setSoTimeout(5000);
            DatagramPacket packet = new DatagramPacket(new byte[0], 0, this.expectedDeviceAddress, 13633);
            if (logger.isTraceEnabled()) {
                logger.trace("accept send from " + this.localHost.getHostAddress() + ":69 - " + TFTPServer.toHexString(packet.getData()));
            }
            socket.send(packet);
            packet = new DatagramPacket(buf, buf.length);
            socket.receive(packet);
            if (logger.isTraceEnabled()) {
                logger.trace("accept recv from  " + packet.getAddress().getHostAddress() + ":" + packet.getPort() + " - " + TFTPServer.toHexString(packet.getData()));
            }
            if (buf[0] == 0) {
                if (buf[1] == 1) return packet.getSocketAddress();
            }
            buf[0] = 0;
            buf[1] = 5;
            buf[2] = 0;
            buf[3] = 4;
            buf[4] = 0;
            if (logger.isTraceEnabled()) {
                logger.trace("accept send bad request response from " + this.localHost.getHostAddress() + ":69 - " + TFTPServer.toHexString(packet.getData()));
            }
            socket.send(packet);
            SocketAddress socketAddress = null;
            return socketAddress;
        }
        catch (SocketTimeoutException e) {
            return null;
        }
    }

    private boolean sendBlock(DatagramPacket blockPacket, DatagramSocket socket) throws IOException {
        byte[] ackData = new byte[4];
        DatagramPacket ackPacket = new DatagramPacket(ackData, ackData.length);
        socket.setSoTimeout(1000);
        byte[] blockData = blockPacket.getData();
        socket.send(blockPacket);
        try {
            socket.receive(ackPacket);
        }
        catch (SocketTimeoutException e) {
            return false;
        }
        return ackData[0] == 0 && ackData[1] == 4 && ackData[2] == blockData[2] && ackData[3] == blockData[3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendFile(String filename, SocketAddress client) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace("sendFile " + filename + " to " + client.toString());
        }
        FileInputStream isfile = null;
        DatagramSocket socket = null;
        File file = new File(filename);
        if (!file.canRead()) {
            return false;
        }
        try {
            isfile = new FileInputStream(file);
            this.totalBytes = isfile.available();
            this.sentBytes = 0;
            socket = new DatagramSocket(33333, this.localHost);
            socket.setSoTimeout(1000);
            if (isfile.available() >= 40) {
                isfile.skip(40L);
                this.totalBytes -= 40;
            }
            int readSize = 512;
            int block = 1;
            while (readSize == 512) {
                byte[] buf = new byte[516];
                readSize = isfile.read(buf, 4, 512);
                buf[0] = 0;
                buf[1] = 3;
                buf[2] = (byte)(block >> 8 & 0xFF);
                buf[3] = (byte)(block & 0xFF);
                DatagramPacket blockPacket = readSize > 0 ? new DatagramPacket(buf, 4 + readSize, client) : new DatagramPacket(buf, 4, client);
                for (int blockTry = 0; blockTry < 5; ++blockTry) {
                    if (this.callbackInterface.gotCancelled()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.sendBlock(blockPacket, socket)) {
                        this.sentBytes += readSize;
                        this.callbackInterface.showProgress(100 * this.sentBytes / this.totalBytes);
                        break;
                    }
                    if (blockTry != 4) continue;
                    boolean bl = false;
                    return bl;
                }
                ++block;
            }
        }
        finally {
            if (isfile != null) {
                isfile.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
        return true;
    }

    public void run() throws FlashException {
        SocketAddress addr = null;
        try {
            while (!this.callbackInterface.gotCancelled() && (addr = this.accept()) == null) {
            }
            this.callbackInterface.showMessage("Updating Firmware...");
            this.callbackInterface.showProgress(0);
            if (!this.sendFile(this.firmware, addr)) {
                throw new FlashException("Failed to upgrade the firmware");
            }
        }
        catch (IOException e) {
            throw new FlashException(e.getMessage(), e);
        }
    }

    private static String toHexString(byte[] data) {
        StringBuilder strbuf = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            if ((data[i] & 0xFF) < 16) {
                strbuf.append('0');
            }
            strbuf.append(Integer.toHexString(data[i] & 0xFF).toUpperCase());
        }
        return strbuf.toString();
    }
}

