/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.tuc.update;

import com.metratec.lib.tuc.update.BOOTPServer;
import com.metratec.lib.tuc.update.CallbackInterface;
import com.metratec.lib.tuc.update.FlashException;
import com.metratec.lib.tuc.update.IdleInterface;
import com.metratec.lib.tuc.update.StellarisMagicPacket;
import com.metratec.lib.tuc.update.TFTPServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Flash
implements IdleInterface {
    BOOTPServer bootp;
    TFTPServer tftp;
    protected String ownIp;
    protected String remoteIp;
    protected String mac;
    protected String path;
    protected CallbackInterface callbackInterface;

    public Flash(CallbackInterface ui, String ri, String m, String oi, String p) throws FlashException {
        if (ri.length() == 0) {
            throw new FlashException("No remote IP given.");
        }
        if (m.length() == 0) {
            throw new FlashException("No MAC given.");
        }
        if (p.length() == 0) {
            throw new FlashException("No firmware given.");
        }
        if (oi.length() == 0) {
            throw new FlashException("No own IP given");
        }
        this.callbackInterface = ui;
        this.ownIp = oi;
        this.remoteIp = ri;
        this.mac = m;
        this.path = p;
        try {
            this.bootp = new BOOTPServer(InetAddress.getByName(this.ownIp), this.mac, this, ui);
        }
        catch (SocketException e) {
            throw new FlashException("Cannot establish BOOTP server. Maybe you are not running this program with superuser rights.", e);
        }
        catch (UnknownHostException e) {
            throw new FlashException("Host unknown.", e);
        }
        try {
            this.tftp = new TFTPServer(InetAddress.getByName(this.ownIp), InetAddress.getByName(this.remoteIp), ui);
        }
        catch (SocketException e) {
            throw new FlashException("Cannot establish TFTP server. Maybe you are not running this program with superuser rights.", e);
        }
        catch (UnknownHostException e) {
            throw new FlashException("Host unknown.", e);
        }
    }

    @Override
    public void idleHandler() {
        try {
            StellarisMagicPacket.sendTo(this.mac, InetAddress.getByName(this.ownIp));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void flashFirmware() throws FlashException {
        this.callbackInterface.showMessage("Running BOOTP server...");
        this.callbackInterface.showProgress(-1);
        if (!this.bootp.addMAC(this.mac, this.remoteIp)) {
            throw new FlashException("Cannot set IP/MAC pair of stellaris device");
        }
        if (!this.bootp.setOwnIp(this.ownIp)) {
            throw new FlashException("Cannot set own IP");
        }
        this.bootp.run();
        if (!this.callbackInterface.gotCancelled()) {
            this.callbackInterface.showMessage("Running TFTP server...");
            this.tftp.setFirmwarePath(this.path);
            this.tftp.run();
        }
    }

    public static List<String[]> netifs() throws SocketException {
        ArrayList<String[]> retval = new ArrayList<String[]>();
        Enumeration<NetworkInterface> ifs = null;
        ifs = NetworkInterface.getNetworkInterfaces();
        while (ifs.hasMoreElements()) {
            NetworkInterface netif = ifs.nextElement();
            Enumeration<InetAddress> addresses = netif.getInetAddresses();
            String[] entry = new String[2];
            entry[0] = netif.getDisplayName();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.getAddress().length != 4) continue;
                entry[1] = String.format("%d.%d.%d.%d", (long)address.getAddress()[0] & 0xFFL, (long)address.getAddress()[1] & 0xFFL, (long)address.getAddress()[2] & 0xFFL, (long)address.getAddress()[3] & 0xFFL);
            }
            retval.add(entry);
        }
        return retval;
    }
}

