/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.tuc.update;

import com.metratec.lib.tuc.TUCException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class FirmwareInformation {
    private String hardwareReqName = null;
    private String hardwareReqRevision = null;
    private String firmwareName = null;
    private String firmwareRevision = null;

    public FirmwareInformation(String hardwareReqName, String hardwareReqRevision, String firmwareName, String firmwareRevision) {
        this.hardwareReqName = hardwareReqName;
        this.hardwareReqRevision = hardwareReqRevision;
        this.firmwareName = firmwareName;
        this.firmwareRevision = firmwareRevision;
    }

    public String getHardwareReqName() {
        return this.hardwareReqName;
    }

    public String getHardwareReqRevision() {
        return this.hardwareReqRevision;
    }

    public String getFirmwareName() {
        return this.firmwareName;
    }

    public String getFirmwareRevision() {
        return this.firmwareRevision;
    }

    public static FirmwareInformation getFirmwareFileInformation(File firmwareFile) throws IOException, TUCException {
        if (!firmwareFile.isFile()) {
            throw new TUCException(4, "The selected firmware file not a file");
        }
        if (!firmwareFile.canRead()) {
            throw new TUCException(4, "The selected firmware file can not read");
        }
        FileReader reader = new FileReader(firmwareFile);
        char[] buffer = new char[40];
        reader.read(buffer);
        reader.close();
        for (int i = 0; i < buffer.length; ++i) {
            if (' ' <= buffer[i] && '\u007f' >= buffer[i]) continue;
            throw new TUCException(4, "The selected firmware file is not valid");
        }
        FirmwareInformation info = new FirmwareInformation(new String(buffer, 20, 16), new String(buffer, 36, 4), new String(buffer, 0, 16), new String(buffer, 16, 4));
        return info;
    }
}

