/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.tuc.update;

import com.metratec.lib.connection.UdpBroadcastHandlerInterface;
import com.metratec.lib.connection.UdpConnection;
import com.metratec.lib.tuc.update.CallbackInterface;
import com.metratec.lib.tuc.update.IdleInterface;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BOOTPServer
implements UdpBroadcastHandlerInterface {
    private static Logger logger = LoggerFactory.getLogger(BOOTPServer.class);
    protected ArrayList<String[]> macTable;
    protected String ownIP;
    public boolean verbose;
    private InetAddress localHost;
    private String mac;
    private IdleInterface ii;
    private CallbackInterface callbackInterface;

    public BOOTPServer(InetAddress localHost, String mac, IdleInterface ii, CallbackInterface callbackInterface) throws SocketException {
        this.localHost = localHost;
        this.mac = mac;
        this.ii = ii;
        this.callbackInterface = callbackInterface;
        this.macTable = new ArrayList();
        this.verbose = false;
        DatagramSocket socket = new DatagramSocket(67, localHost);
        socket.close();
    }

    public boolean addMAC(String mac, String ip) {
        mac = mac.replace('.', ':');
        mac = mac.replace('-', ':');
        if ((mac = mac.toLowerCase()).split(":").length != 6 || ip.split("\\p{Punct}").length != 4) {
            return false;
        }
        String[] tmp = new String[]{mac, ip, "no"};
        this.macTable.add(tmp);
        return true;
    }

    public boolean setOwnIp(String ip) {
        if (ip.split("\\p{Punct}").length != 4) {
            return false;
        }
        this.ownIP = ip;
        return true;
    }

    public boolean hasIp(String mac) {
        mac = mac.toLowerCase();
        for (int i = 0; i < this.macTable.size(); ++i) {
            if (this.macTable.get(i)[0].compareTo(mac) != 0 || this.macTable.get(i)[2].compareTo("yes") != 0) continue;
            return true;
        }
        return false;
    }

    public boolean handle(InetAddress localAddress, DatagramPacket request, DatagramSocket socket) throws IOException {
        byte[] buf = request.getData();
        String name = new String(buf, 44, 9);
        if (logger.isTraceEnabled()) {
            logger.trace("handle " + request.getAddress().getHostAddress() + ":" + request.getPort() + " - " + BOOTPServer.toHexString(request.getData()));
        }
        if (this.verbose) {
            System.out.println("BOOTP: Receiving BOOTP request");
        }
        if (buf[0] != 1) {
            if (this.verbose) {
                System.out.println("BOOTP: This was not a BOOTP request");
            }
            return true;
        }
        if (buf[1] != 1) {
            if (this.verbose) {
                System.out.println("BOOTP: Type is not Ethernet");
            }
            return true;
        }
        if (buf[2] != 6) {
            if (this.verbose) {
                System.out.println("BOOTP: Length of hardware address is not accepted");
            }
            return true;
        }
        if (!name.equals("stellaris")) {
            if (this.verbose) {
                System.out.println("BOOTP: Server name does not match \"stelaris\"");
            }
            return true;
        }
        if (this.verbose) {
            System.out.println("BOOTP: Valid BOOTP request");
        }
        boolean hasIp = false;
        StringBuffer tmp = new StringBuffer();
        for (int i = 28; i < 34; ++i) {
            tmp.append(String.format(":%02X", buf[i]));
        }
        String mac = tmp.toString().substring(1).toLowerCase();
        for (int i = 0; i < this.macTable.size(); ++i) {
            if (this.macTable.get(i)[0].compareTo(mac) != 0) continue;
            String[] ip = this.macTable.get(i)[1].split("\\p{Punct}");
            buf[16] = (byte)Integer.parseInt(ip[0], 10);
            buf[17] = (byte)Integer.parseInt(ip[1], 10);
            buf[18] = (byte)Integer.parseInt(ip[2], 10);
            buf[19] = (byte)Integer.parseInt(ip[3], 10);
            this.macTable.get((int)i)[2] = "yes";
            if (this.verbose) {
                System.out.printf("BOOTP: Assign IP %s to %s\n", this.macTable.get(i)[1], mac);
            }
            hasIp = true;
        }
        String[] ip = this.ownIP.split("\\p{Punct}");
        buf[20] = (byte)Integer.parseInt(ip[0], 10);
        buf[21] = (byte)Integer.parseInt(ip[1], 10);
        buf[22] = (byte)Integer.parseInt(ip[2], 10);
        buf[23] = (byte)Integer.parseInt(ip[3], 10);
        buf[0] = 2;
        buf[108] = 102;
        buf[109] = 105;
        buf[110] = 114;
        buf[111] = 109;
        buf[112] = 119;
        buf[113] = 97;
        buf[114] = 114;
        buf[115] = 101;
        buf[116] = 46;
        buf[117] = 98;
        buf[118] = 105;
        buf[119] = 110;
        if (!hasIp) {
            return true;
        }
        if (this.verbose) {
            System.out.println("BOOTP: Sending BOOTP reply");
        }
        DatagramPacket response = new DatagramPacket(buf, buf.length, InetAddress.getByName("255.255.255.255"), request.getPort());
        socket.send(response);
        return true;
    }

    public void run() {
        DatagramPacket fwPacket = new DatagramPacket(new byte[0], 0, null, 68);
        while (!this.callbackInterface.gotCancelled() && !this.hasIp(this.mac)) {
            try {
                this.ii.idleHandler();
                if (logger.isTraceEnabled()) {
                    logger.trace("Send bogus");
                }
                UdpConnection.sendRecvBroadcast((DatagramPacket)fwPacket, (int)67, (int)300, (int)1000, (InetAddress)this.localHost, (UdpBroadcastHandlerInterface)this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private static String toHexString(byte[] data) {
        StringBuilder strbuf = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            if ((data[i] & 0xFF) < 16) {
                strbuf.append('0');
            }
            strbuf.append(Integer.toHexString(data[i] & 0xFF).toUpperCase());
        }
        return strbuf.toString();
    }
}

