/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.tuc.types;

import java.net.InetAddress;

public class TUCDevice
implements Comparable<TUCDevice> {
    private InetAddress inetAddress = null;
    private byte[] macAddress = null;
    private String name = null;
    private boolean isReachable = false;
    private boolean isRemoteConfiguration = false;
    private byte[] subnetMask = null;
    private byte[] gateway = null;
    private byte[] ip = null;
    private int firmwareRevision = 0;
    private int hardwareRevision = 0;
    private String hardwareName = null;
    private boolean isDHCP = false;
    private boolean isBootloader = false;
    private InetAddress localHost;

    @Deprecated
    public TUCDevice() {
    }

    public TUCDevice(InetAddress inetAddress, byte[] macAddress, String name, InetAddress localhost) {
        this.inetAddress = inetAddress;
        this.macAddress = macAddress;
        this.name = name;
        this.localHost = localhost;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public void setMacAddress(byte[] macAddress) {
        this.macAddress = macAddress;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public byte[] getMacAddress() {
        return this.macAddress;
    }

    public String getMacAddressString() {
        if (null != this.macAddress) {
            StringBuilder sBuilder = new StringBuilder(this.macAddress.length * 2);
            for (int i = 0; i < this.macAddress.length; ++i) {
                if ((this.macAddress[i] & 0xFF) < 16) {
                    sBuilder.append(":0");
                } else {
                    sBuilder.append(':');
                }
                sBuilder.append(Integer.toHexString(this.macAddress[i] & 0xFF).toUpperCase());
            }
            return sBuilder.toString().substring(1);
        }
        return "";
    }

    public String getName() {
        return this.name;
    }

    public boolean isReachable() {
        return this.isReachable;
    }

    public void setReachable(boolean isReachable) {
        this.isReachable = isReachable;
    }

    public boolean isRemoteConfiguration() {
        return this.isRemoteConfiguration;
    }

    public void setRemoteConfiguration(boolean isRemoteConfiguration) {
        this.isRemoteConfiguration = isRemoteConfiguration;
    }

    public byte[] getSubnetMask() {
        return this.subnetMask;
    }

    public String getSubnetMaskAddress() {
        return this.addressToString(this.subnetMask);
    }

    public void setSubnetMask(byte[] subnetMask) {
        this.subnetMask = subnetMask;
    }

    public byte[] getGateway() {
        return this.gateway;
    }

    public String getGatewayAddress() {
        return this.addressToString(this.gateway);
    }

    public void setGateway(byte[] gateway) {
        this.gateway = gateway;
    }

    public byte[] getIP() {
        return this.ip;
    }

    public String getIPAddress() {
        return this.addressToString(this.ip);
    }

    public void setIP(byte[] ip) {
        this.ip = ip;
    }

    public int getFirmwareRevision() {
        return this.firmwareRevision;
    }

    public void setFirmwareRevision(int firmwareRevision) {
        this.firmwareRevision = firmwareRevision;
    }

    public int getHardwareRevision() {
        return this.hardwareRevision;
    }

    public void setHardwareRevision(int hardwareRevision) {
        this.hardwareRevision = hardwareRevision;
    }

    public boolean isDHCP() {
        return this.isDHCP;
    }

    public void setDHCP(boolean isDHCP) {
        this.isDHCP = isDHCP;
    }

    public boolean isBootloader() {
        return this.isBootloader;
    }

    public void setBootloader(boolean isBootloader) {
        this.isBootloader = isBootloader;
    }

    public String getHardwareName() {
        return this.hardwareName;
    }

    public void setHardwareName(String hardwareName) {
        this.hardwareName = hardwareName;
    }

    public String addressToString(byte[] address) {
        if (address != null) {
            StringBuilder strbuf = new StringBuilder(address.length);
            for (int i = 0; i < address.length; ++i) {
                strbuf.append(Integer.toString(address[i] & 0xFF));
                strbuf.append('.');
            }
            if (strbuf.length() != 0) {
                strbuf.setLength(strbuf.length() - 1);
            }
            return strbuf.toString();
        }
        return "";
    }

    public InetAddress getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(InetAddress localHost) {
        this.localHost = localHost;
    }

    public String getConfiguration() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(this.getName());
        sBuilder.append("\nMAC: ");
        sBuilder.append(this.getMacAddressString());
        sBuilder.append("\nFirmwareRevision: ");
        sBuilder.append(this.getFirmwareRevision());
        sBuilder.append("\nHardwareRevision: ");
        sBuilder.append(this.getHardwareRevision());
        sBuilder.append("\nHardwareName: ");
        sBuilder.append(this.getHardwareName());
        sBuilder.append("\nisReachable: ");
        sBuilder.append(this.isReachable());
        sBuilder.append("\nisRemoteConfiguration: ");
        sBuilder.append(this.isRemoteConfiguration());
        sBuilder.append("\nisDHCP: ");
        sBuilder.append(this.isDHCP());
        sBuilder.append("\nIPAddress: ");
        sBuilder.append(this.getIPAddress());
        sBuilder.append("\nSubnetMask: ");
        sBuilder.append(this.getSubnetMaskAddress());
        sBuilder.append("\nGateway: ");
        sBuilder.append(this.getGatewayAddress());
        return sBuilder.toString();
    }

    public String toString() {
        String address = this.inetAddress.isAnyLocalAddress() ? "Unassigned IP" : this.inetAddress.getHostAddress();
        return address + " (" + this.getName() + ")";
    }

    private static int compareBytes(byte[] b1, byte[] b2) {
        int i;
        for (i = 0; i < b1.length && b1[i] == b2[i]; ++i) {
        }
        return i >= b1.length ? 0 : (b1[i] & 0xFF) - (b2[i] & 0xFF);
    }

    @Override
    public int compareTo(TUCDevice obj) {
        int cmp = TUCDevice.compareBytes(this.inetAddress.getAddress(), obj.getInetAddress().getAddress());
        if (cmp == 0) {
            cmp = TUCDevice.compareBytes(this.macAddress, obj.getMacAddress());
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        return obj instanceof TUCDevice && this.compareTo((TUCDevice)obj) == 0;
    }
}

