/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.tuc.types;

import com.metratec.lib.tuc.types.TUCPortConfiguration;
import java.util.ArrayList;

public class TUCConfiguration {
    private String ipAddress = null;
    private String macAddress = null;
    private boolean isReachable;
    private boolean isRemoteConfiguration;
    private String name = null;
    private String subnetMask = null;
    private String gateway = null;
    private String revision = null;
    private String firmwareRevision = null;
    private String hardwareRevision = null;
    private String hardwareName = null;
    private boolean isDHCP = false;
    private int upnpPort = 0;
    private ArrayList<TUCPortConfiguration> portConfiguration = new ArrayList();

    public String getIPAddress() {
        return this.ipAddress;
    }

    public void setIPAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public boolean isReachable() {
        return this.isReachable;
    }

    public void setReachable(boolean isReachable) {
        this.isReachable = isReachable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubnetMask() {
        return this.subnetMask;
    }

    public void setSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getFirmwareRevision() {
        return this.firmwareRevision;
    }

    public void setFirmwareRevision(String firmwareRevision) {
        this.firmwareRevision = firmwareRevision;
    }

    public String getHardwareRevision() {
        return this.hardwareRevision;
    }

    public void setHardwareRevision(String hardwareRevision) {
        this.hardwareRevision = hardwareRevision;
    }

    public String getHardwareName() {
        return this.hardwareName;
    }

    public void setHardwareName(String hardwareName) {
        this.hardwareName = hardwareName;
    }

    public boolean isSTATIC() {
        return !this.isDHCP;
    }

    public boolean isDHCP() {
        return this.isDHCP;
    }

    public void setDHCP(boolean isDHCP) {
        this.isDHCP = isDHCP;
    }

    public int getUpnpPort() {
        return this.upnpPort;
    }

    public void setUpnpPort(int upnpPort) {
        this.upnpPort = upnpPort;
    }

    public ArrayList<TUCPortConfiguration> getPortConfiguration() {
        return this.portConfiguration;
    }

    public void setPortConfiguration(ArrayList<TUCPortConfiguration> portConfiguration) {
        this.portConfiguration = portConfiguration;
    }

    public void addPortConfiguration(TUCPortConfiguration portConfiguration) {
        this.portConfiguration.add(portConfiguration);
    }

    public boolean isRemoteConfiguration() {
        return this.isRemoteConfiguration;
    }

    public void setRemoteConfiguration(boolean isRemoteConfiguration) {
        this.isRemoteConfiguration = isRemoteConfiguration;
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(this.getName());
        sBuilder.append("\nReachable: ");
        sBuilder.append(this.isReachable());
        sBuilder.append("\nIPAddress: ");
        sBuilder.append(this.getIPAddress());
        sBuilder.append("\nMacAddress: ");
        sBuilder.append(this.getMacAddress());
        sBuilder.append("\nRevision: ");
        sBuilder.append(this.getRevision());
        sBuilder.append("\nFirmwareRevision: ");
        sBuilder.append(this.getFirmwareRevision());
        sBuilder.append("\nHardwareName: ");
        sBuilder.append(this.getHardwareName());
        sBuilder.append("\nHardwareRevision: ");
        sBuilder.append(this.getHardwareRevision());
        sBuilder.append("\nIP MODE: ");
        sBuilder.append(this.isDHCP() ? "DHCP" : "STATIC");
        sBuilder.append("\nSubnetMask: ");
        sBuilder.append(this.getSubnetMask());
        sBuilder.append("\nGateway: ");
        sBuilder.append(this.getGateway());
        sBuilder.append("\nUpnpPort: ");
        sBuilder.append(this.getUpnpPort());
        for (TUCPortConfiguration port : this.getPortConfiguration()) {
            sBuilder.append("\nPortConfiguration: Port ");
            sBuilder.append(port.getPortNumber());
            sBuilder.append("\n\tPinType: ");
            sBuilder.append(port.getPinType());
            if (!port.getPinType().equals("UART")) continue;
            sBuilder.append("\n\tPortBaudrate: ");
            sBuilder.append(port.getPortBaudrate());
            sBuilder.append("\n\tPortStopbits: ");
            sBuilder.append(port.getPortStopbits());
            sBuilder.append("\n\tPortDatasize: ");
            sBuilder.append(port.getPortDatasize());
            sBuilder.append("\n\tPortFlowcontrol: ");
            sBuilder.append(port.getPortFlowcontrol());
            sBuilder.append("\n\tPortParity: ");
            sBuilder.append(port.getPortParity());
            sBuilder.append("\n\tTcpProtocol: ");
            sBuilder.append(port.getTcpProtocol());
            sBuilder.append("\n\tTcpMode: ");
            sBuilder.append(port.getTcpMode());
            sBuilder.append("\n\tTcpPort: ");
            sBuilder.append(port.getTcpPort());
            sBuilder.append("\n\tTcpTimeout: ");
            sBuilder.append(port.getTcpTimeout());
            sBuilder.append("\n\tRemoteServerIP: ");
            sBuilder.append(port.getTcpRemoteServerIP());
            sBuilder.append("\n\tRemoteServerPort: ");
            sBuilder.append(port.getTcpRemoteServerPort());
        }
        return sBuilder.toString();
    }
}

