/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.tuc.handler;

import com.metratec.lib.connection.UdpBroadcastHandlerInterface;
import com.metratec.lib.connection.UdpConnection;
import com.metratec.lib.tuc.TUCException;
import com.metratec.lib.tuc.handler.TUCSecurity;
import com.metratec.lib.tuc.handler.UdpControlResponseValidator;
import com.metratec.lib.tuc.handler.UdpResponseValidator;
import com.metratec.lib.tuc.types.TUCDevice;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TUCUDPControl {
    private static Logger logger = LoggerFactory.getLogger(TUCUDPControl.class);
    private TUCDevice device;
    private static final int UDPMessageLength = 52;
    private int timeout = 2000;
    private String password = "";
    private int minVersionWithPassword = 300;

    public TUCUDPControl(TUCDevice device) {
        this.device = device;
    }

    public TUCUDPControl(TUCDevice device, int timeout) {
        this.device = device;
        this.timeout = timeout;
    }

    public static List<TUCDevice> scanDevices(int timeout) throws IOException {
        byte[] sendData = new byte[52];
        sendData[0] = 1;
        sendData[1] = 19;
        sendData[2] = 55;
        sendData[3] = 10;
        sendData[4] = -1;
        sendData[5] = -1;
        sendData[6] = -1;
        sendData[7] = -1;
        sendData[8] = -1;
        sendData[9] = -1;
        sendData[16] = 1;
        final DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, null, 42000);
        final TreeSet deviceSet = new TreeSet();
        if (logger.isTraceEnabled()) {
            logger.trace("scanDevices send " + TUCUDPControl.toHexString(sendData));
        }
        UdpConnection.sendRecvBroadcast((DatagramPacket)sendPacket, (int)41000, (int)52, (int)timeout, (UdpBroadcastHandlerInterface)new UdpBroadcastHandlerInterface(){

            public boolean handle(InetAddress localAddr, DatagramPacket recvPacket, DatagramSocket socket) {
                byte[] sendData = sendPacket.getData();
                byte[] recvData = recvPacket.getData();
                if (logger.isTraceEnabled()) {
                    logger.trace("scanDevices recv " + TUCUDPControl.toHexString(recvData));
                }
                for (int i = 0; i < 4; ++i) {
                    if (recvData[i] == sendData[i]) continue;
                    logger.warn("Error: Wrong magic code: " + Arrays.toString(recvData));
                    return true;
                }
                if (recvData[16] != sendData[16]) {
                    logger.warn("Error: Non-ping response: " + Arrays.toString(recvData));
                    return true;
                }
                TUCDevice dev = new TUCDevice(recvPacket.getAddress(), Arrays.copyOfRange(recvData, 10, 16), new String(recvData, 17, 32).trim(), localAddr);
                dev.setBootloader(dev.getName().equals("TUC Bootloader"));
                deviceSet.add(dev);
                return true;
            }
        });
        return new ArrayList<TUCDevice>(deviceSet);
    }

    private DatagramPacket sendRecvBroadcastPacket(DatagramPacket sendPacket, final UdpResponseValidator responseValidator) throws IOException, TUCException {
        int i;
        byte[] sendData = sendPacket.getData();
        byte[] mac = this.device.getMacAddress();
        final ArrayList recvPackets = new ArrayList(1);
        if (mac == null) {
            throw new TUCException(4, "MAC Address is null");
        }
        if (mac.length != 6) {
            throw new TUCException(4, "Wrong MAC Address");
        }
        for (i = 0; i < mac.length; ++i) {
            sendData[4 + i] = mac[i];
        }
        if (logger.isTraceEnabled()) {
            logger.trace("send " + TUCUDPControl.toHexString(sendData));
        }
        UdpConnection.sendRecvBroadcast((DatagramPacket)sendPacket, (int)41000, (int)52, (int)this.timeout, (InetAddress)this.device.getLocalHost(), (UdpBroadcastHandlerInterface)new UdpBroadcastHandlerInterface(){

            public boolean handle(InetAddress localAddr, DatagramPacket packet, DatagramSocket socket) {
                if (logger.isTraceEnabled()) {
                    logger.trace("recv " + TUCUDPControl.toHexString(packet.getData()));
                }
                if (null != responseValidator) {
                    if (responseValidator.isResponseValid(packet)) {
                        recvPackets.add(packet);
                        return false;
                    }
                    return true;
                }
                recvPackets.add(packet);
                return false;
            }
        });
        if (recvPackets.isEmpty()) {
            throw new TUCException(2, "TUC did not respond to request");
        }
        byte[] recvData = ((DatagramPacket)recvPackets.get(0)).getData();
        for (i = 0; i < 4; ++i) {
            if (recvData[i] == sendData[i]) continue;
            throw new TUCException(3, TUCUDPControl.toHexString(recvData));
        }
        return (DatagramPacket)recvPackets.get(0);
    }

    public void configIPAddressStatic(String newIPAddress, String newSubnetmask, String newGateway) throws IOException, TUCException {
        String ip_pattern = "(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])";
        if (null == newIPAddress) {
            throw new TUCException(4, "IP Address is null");
        }
        if (!Pattern.matches(ip_pattern, newIPAddress)) {
            throw new TUCException(4, "Wrong IP Address");
        }
        if (null == newSubnetmask) {
            throw new TUCException(4, "Subnetmask is null");
        }
        if (!Pattern.matches(ip_pattern, newSubnetmask)) {
            throw new TUCException(4, "Wrong Subnetmask");
        }
        if (null == newGateway) {
            throw new TUCException(4, "Gateway Address is null");
        }
        if (!Pattern.matches(ip_pattern, newGateway)) {
            throw new TUCException(4, "Wrong Gateway Address");
        }
        byte[] ipAddress = new byte[4];
        byte[] subnetMask = new byte[4];
        byte[] gateway = new byte[4];
        String[] ip = newIPAddress.split("\\p{Punct}");
        ipAddress[0] = (byte)Integer.parseInt(ip[0]);
        ipAddress[1] = (byte)Integer.parseInt(ip[1]);
        ipAddress[2] = (byte)Integer.parseInt(ip[2]);
        ipAddress[3] = (byte)Integer.parseInt(ip[3]);
        String[] mask = newSubnetmask.split("\\p{Punct}");
        subnetMask[0] = (byte)Integer.parseInt(mask[0]);
        subnetMask[1] = (byte)Integer.parseInt(mask[1]);
        subnetMask[2] = (byte)Integer.parseInt(mask[2]);
        subnetMask[3] = (byte)Integer.parseInt(mask[3]);
        String[] gway = newGateway.split("\\p{Punct}");
        gateway[0] = (byte)Integer.parseInt(gway[0]);
        gateway[1] = (byte)Integer.parseInt(gway[1]);
        gateway[2] = (byte)Integer.parseInt(gway[2]);
        gateway[3] = (byte)Integer.parseInt(gway[3]);
        this.configIPAddressStatic(ipAddress, subnetMask, gateway);
    }

    public void configIPAddressStatic(byte[] newIPAddress, byte[] newSubnetmask, byte[] newGateway) throws IOException, TUCException {
        DatagramPacket sendPacket;
        DatagramPacket recvPacket;
        byte[] recvData;
        if (null == newIPAddress) {
            throw new TUCException(4, "IP Address is null");
        }
        if (newIPAddress.length != 4) {
            throw new TUCException(4, "Wrong IP Address");
        }
        if (null == newSubnetmask) {
            throw new TUCException(4, "Subnetmask is null");
        }
        if (newSubnetmask.length != 4) {
            throw new TUCException(4, "Wrong Subnetmask");
        }
        if (null == newGateway) {
            throw new TUCException(4, "Gateway Address is null");
        }
        if (newGateway.length != 4) {
            throw new TUCException(4, "Wrong Gateway Address");
        }
        byte[] sendData = this.createUDPMessage();
        sendData[16] = 2;
        sendData[17] = 0;
        System.arraycopy(newIPAddress, 0, sendData, 18, 4);
        System.arraycopy(newSubnetmask, 0, sendData, 22, 4);
        System.arraycopy(newGateway, 0, sendData, 26, 4);
        if (this.minVersionWithPassword <= this.device.getFirmwareRevision()) {
            byte[] seed = this.getSeed();
            if (null == this.password) {
                throw new TUCException(4, "Password not set");
            }
            byte[] password = this.password.getBytes();
            byte[] rawData = new byte[seed.length + password.length + 13];
            System.arraycopy(seed, 0, rawData, 0, seed.length);
            System.arraycopy(password, 0, rawData, seed.length, password.length);
            System.arraycopy(sendData, 17, rawData, seed.length + password.length, 13);
            try {
                byte[] hash = TUCSecurity.getSHA1sum(rawData);
                System.arraycopy(hash, 0, sendData, 30, hash.length);
            }
            catch (NoSuchAlgorithmException e) {
                throw new TUCException(1, e.getMessage());
            }
        }
        if (sendData[16] != (recvData = (recvPacket = this.sendRecvBroadcastPacket(sendPacket = new DatagramPacket(sendData, sendData.length, null, 42000), new UdpControlResponseValidator(16, sendData[16], 255))).getData())[16] || sendData[17] != recvData[17]) {
            if (255 == (recvData[16] & 0xFF)) {
                throw new TUCException(6, TUCUDPControl.toHexString(recvData));
            }
            throw new TUCException(3, TUCUDPControl.toHexString(recvData));
        }
    }

    public byte[] getSeed() throws TUCException, IOException {
        if (null == this.device.getInetAddress()) {
            throw new TUCException(4, "Inet Address is null");
        }
        byte[] sendData = this.createUDPMessage();
        sendData[16] = 4;
        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, null, 42000);
        DatagramPacket recvPacket = this.sendRecvBroadcastPacket(sendPacket, new UdpControlResponseValidator(16, sendData[16], 255));
        byte[] recvData = recvPacket.getData();
        if (sendData[16] != recvData[16]) {
            throw new TUCException(3, TUCUDPControl.toHexString(recvData));
        }
        return Arrays.copyOfRange(recvData, 17, 21);
    }

    public void configIPAddressDHCP() throws TUCException, IOException {
        DatagramPacket sendPacket;
        DatagramPacket recvPacket;
        byte[] recvData;
        byte[] sendData = this.createUDPMessage();
        sendData[16] = 2;
        sendData[17] = 1;
        if (this.minVersionWithPassword <= this.device.getFirmwareRevision()) {
            byte[] seed = this.getSeed();
            if (null == this.password) {
                throw new TUCException(4, "Password not set");
            }
            byte[] password = this.password.getBytes();
            byte[] rawData = new byte[seed.length + password.length + 13];
            System.arraycopy(seed, 0, rawData, 0, seed.length);
            System.arraycopy(password, 0, rawData, seed.length, password.length);
            System.arraycopy(sendData, 17, rawData, seed.length + password.length, 13);
            try {
                byte[] hash = TUCSecurity.getSHA1sum(rawData);
                System.arraycopy(hash, 0, sendData, 30, hash.length);
            }
            catch (NoSuchAlgorithmException e) {
                throw new TUCException(1, e.getMessage());
            }
        }
        if (sendData[16] != (recvData = (recvPacket = this.sendRecvBroadcastPacket(sendPacket = new DatagramPacket(sendData, sendData.length, null, 42000), new UdpControlResponseValidator(16, sendData[16], 255))).getData())[16] || sendData[17] != recvData[17]) {
            if (255 == (recvData[16] & 0xFF)) {
                throw new TUCException(6, TUCUDPControl.toHexString(recvData));
            }
            throw new TUCException(3, TUCUDPControl.toHexString(recvData));
        }
    }

    public void updateTUCDevice() throws IOException, TUCException {
        byte[] sendData = this.createUDPMessage();
        sendData[16] = 1;
        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, null, 42000);
        DatagramPacket recvPacket = this.sendRecvBroadcastPacket(sendPacket, new UdpControlResponseValidator(16, sendData[16], 255));
        byte[] recvData = recvPacket.getData();
        if (sendData[16] != recvData[16]) {
            if (0 == recvData[16]) {
                throw new TUCException(5, TUCUDPControl.toHexString(recvData));
            }
            throw new TUCException(3, TUCUDPControl.toHexString(recvData));
        }
        this.device.setInetAddress(recvPacket.getAddress());
        this.device.setMacAddress(Arrays.copyOfRange(recvData, 10, 16));
        this.device.setName(new String(recvData, 17, 32).trim());
    }

    public void addTUCSetting() throws IOException, TUCException {
        byte[] sendData = this.createUDPMessage();
        sendData[16] = 3;
        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, null, 42000);
        DatagramPacket recvPacket = this.sendRecvBroadcastPacket(sendPacket, new UdpControlResponseValidator(16, sendData[16], 255));
        byte[] recvData = recvPacket.getData();
        if (sendData[16] != recvData[16]) {
            if (0 == recvData[16]) {
                throw new TUCException(5, TUCUDPControl.toHexString(recvData));
            }
            throw new TUCException(3, TUCUDPControl.toHexString(recvData));
        }
        this.device.setBootloader(0 != (0x20 & (recvData[17] & 0xFF)));
        this.device.setRemoteConfiguration(0 != (0x40 & (recvData[17] & 0xFF)));
        this.device.setDHCP(0 == (0x80 & (recvData[17] & 0xFF)));
        this.device.setIP(Arrays.copyOfRange(recvData, 18, 22));
        if (this.device.isBootloader() && InetAddress.getByAddress(this.device.getIP()).isMCGlobal()) {
            this.device.setIP(new byte[]{0, 0, 0, 0});
        }
        this.device.setSubnetMask(Arrays.copyOfRange(recvData, 22, 26));
        this.device.setGateway(Arrays.copyOfRange(recvData, 26, 30));
        this.device.setFirmwareRevision((recvData[30] & 0xFF) << 8 | recvData[31] & 0xFF);
        this.device.setHardwareRevision((recvData[32] & 0xFF) << 8 | recvData[33] & 0xFF);
        if (0 != recvData[34]) {
            StringBuilder sBuilder = new StringBuilder();
            for (int i = 34; i < 50; ++i) {
                sBuilder.append((char)(recvData[i] & 0xFF));
            }
            this.device.setHardwareName(sBuilder.toString());
        }
    }

    public void identify() throws IOException, TUCException {
        if (this.minVersionWithPassword <= this.device.getFirmwareRevision()) {
            byte[] sendData = this.createUDPMessage();
            sendData[16] = 6;
            DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, null, 42000);
            DatagramPacket recvPacket = this.sendRecvBroadcastPacket(sendPacket, new UdpControlResponseValidator(16, sendData[16], 255));
            byte[] recvData = recvPacket.getData();
            if (sendData[16] != recvData[16]) {
                throw new TUCException(3, TUCUDPControl.toHexString(recvData));
            }
        } else {
            throw new TUCException(5, "This command needs minimum firmware revision " + String.format("%04d", this.minVersionWithPassword));
        }
    }

    public void allowFirmwareUpdate(boolean state) throws IOException, TUCException {
        if (this.minVersionWithPassword <= this.device.getFirmwareRevision()) {
            byte[] sendData = this.createUDPMessage();
            sendData[16] = 5;
            sendData[17] = (byte)(state ? 1 : 0);
            byte[] seed = this.getSeed();
            byte[] password = this.password.getBytes();
            byte[] rawData = new byte[seed.length + password.length + 1];
            System.arraycopy(seed, 0, rawData, 0, seed.length);
            System.arraycopy(password, 0, rawData, seed.length, password.length);
            rawData[rawData.length - 1] = sendData[17];
            try {
                byte[] hash = TUCSecurity.getSHA1sum(rawData);
                System.arraycopy(hash, 0, sendData, 18, hash.length);
            }
            catch (NoSuchAlgorithmException e) {
                throw new TUCException(1, e.getMessage());
            }
            DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, null, 42000);
            DatagramPacket recvPacket = this.sendRecvBroadcastPacket(sendPacket, new UdpControlResponseValidator(16, sendData[16], 255));
            byte[] recvData = recvPacket.getData();
            if (sendData[16] != recvData[16] || sendData[17] != recvData[17]) {
                if (255 == (recvData[16] & 0xFF)) {
                    throw new TUCException(6, TUCUDPControl.toHexString(recvData));
                }
                throw new TUCException(3, TUCUDPControl.toHexString(recvData));
            }
        } else {
            throw new TUCException(5, "This command needs minimum firmware revision " + String.format("%04d", this.minVersionWithPassword));
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public TUCDevice getDevice() {
        return this.device;
    }

    private byte[] createUDPMessage() {
        byte[] data = new byte[52];
        data[0] = 1;
        data[1] = 19;
        data[2] = 55;
        data[3] = 10;
        return data;
    }

    private static String toHexString(byte[] data) {
        StringBuilder strbuf = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            if ((data[i] & 0xFF) < 16) {
                strbuf.append('0');
            }
            strbuf.append(Integer.toHexString(data[i] & 0xFF).toUpperCase());
        }
        return strbuf.toString();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

