/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.tuc.handler;

import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.TcpConnection;
import com.metratec.lib.tuc.TUCException;
import com.metratec.lib.tuc.handler.TUCSecurity;
import com.metratec.lib.tuc.types.TUCConfiguration;
import com.metratec.lib.tuc.types.TUCDevice;
import com.metratec.lib.tuc.types.TUCPortConfiguration;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;

public class TUCTCPControl {
    private TcpConnection connection;
    private String seed = "";

    public TUCTCPControl(TcpConnection connection) {
        if (null == connection) {
            throw new NullPointerException();
        }
        this.connection = connection;
    }

    public TUCTCPControl(String ipAddress, int port) {
        if (null == ipAddress) {
            throw new NullPointerException();
        }
        this.connection = new TcpConnection(ipAddress, port);
    }

    public TUCTCPControl(TUCDevice device, int port) {
        if (null == device) {
            throw new NullPointerException();
        }
        this.connection = new TcpConnection(device.getInetAddress().getHostAddress(), port);
    }

    public TUCTCPControl(TUCDevice device) {
        if (null == device) {
            throw new NullPointerException();
        }
        this.connection = new TcpConnection(device.getInetAddress().getHostAddress(), 40000);
    }

    public void connect() throws CommConnectionException, TUCException {
        block3: {
            if (!this.connection.isConnected()) {
                try {
                    this.connection.connect();
                }
                catch (CommConnectionException e) {
                    if (49 != e.getErrorCode()) break block3;
                    throw new TUCException(7, "Connection not available, is configuration port available?");
                }
            }
        }
    }

    public boolean isLoginNeeded() throws CommConnectionException, TUCException {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (0 < this.connection.dataAvailable()) {
            String recv = this.connection.recv(new int[]{13});
            if (recv.startsWith("SEED: ")) {
                this.seed = recv.substring(6, recv.length() - 1);
                return true;
            }
            throw new TUCException(2, recv);
        }
        return false;
    }

    public boolean login(String password) throws CommConnectionException, TUCException {
        try {
            String command = "LOGIN " + TUCSecurity.getSHA1sum(this.seed + password) + "\r";
            this.connection.send(command);
            try {
                String recv = this.connection.recv(new int[]{13});
                if (recv.equals("OK!\r")) {
                    return true;
                }
                throw new TUCException(3, "Wrong TUC Answer to login");
            }
            catch (CommConnectionException e) {
                if (6 == e.getErrorCode()) {
                    return false;
                }
                throw e;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new TUCException(1, e.getMessage());
        }
    }

    public void setFirmwareUpdateAvailable(boolean state) throws CommConnectionException, TUCException {
        this.connection.send("FWUPDATE " + (state ? "1" : "0") + "\r");
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            throw new TUCException(3, recv);
        }
    }

    public void changeConnectionIPAddress(String ipAddress) throws CommConnectionException, TUCException {
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.connection.setIPAddress(ipAddress);
        this.connect();
    }

    public void changeConnectionPort(int port) throws CommConnectionException, TUCException {
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.connection.setPort(port);
        this.connect();
    }

    public void changeConnectionIPAddress(String ipAddress, int port) throws CommConnectionException, TUCException {
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.connection.setIPAddress(ipAddress);
        this.connection.setPort(port);
        this.connect();
    }

    public void disconnect() throws CommConnectionException {
        this.connection.disconnect();
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    public String getRevision() throws CommConnectionException {
        this.connection.send("REV\r");
        try {
            String recv = this.connection.recv(new int[]{13});
            return recv.substring(0, recv.length() - 1);
        }
        catch (CommConnectionException e) {
            if (8 == e.getErrorCode() && 24 == e.getMessage().length()) {
                return e.getMessage();
            }
            throw e;
        }
    }

    @Deprecated
    public String getHardwareRevisionRequirement() throws CommConnectionException {
        String rev = this.getRevision();
        if (rev.length() >= 20) {
            return rev.substring(16, 18) + "." + rev.substring(18, 20);
        }
        return "";
    }

    public String getFirmwareRevision() throws CommConnectionException {
        String rev = this.getRevision();
        if (rev.length() >= 24) {
            return rev.substring(20, 22) + "." + rev.substring(22, 24);
        }
        return "";
    }

    public String getHardwareRevision() throws CommConnectionException {
        this.connection.send("RHR\r");
        String recv = this.connection.recv(new int[]{13});
        if (recv.equals("0100\r")) {
            return "01.02";
        }
        if (5 == recv.length()) {
            return recv.substring(0, 2) + "." + recv.substring(2, 4);
        }
        return recv.substring(0, recv.length() - 1);
    }

    public String getHardwareNameRequirement() throws CommConnectionException {
        this.connection.send("RHQ\r");
        String recv = this.connection.recv(new int[]{13});
        return recv.substring(0, recv.length() - 1).trim();
    }

    public String getHardwareName() throws CommConnectionException {
        this.connection.send("RHN\r");
        String recv = this.connection.recv(new int[]{13});
        if (recv.equals("TUC_r1-2        \r")) {
            return "TUC             ";
        }
        return recv.substring(0, recv.length() - 1);
    }

    public TUCConfiguration getDeviceConfiguration() throws CommConnectionException {
        TUCConfiguration config = new TUCConfiguration();
        this.connection.send("DUMP\r");
        TUCPortConfiguration portconfiguration = null;
        String recv = "";
        do {
            if ((recv = this.connection.recv(new int[]{13})).startsWith("MAC")) {
                config.setMacAddress(recv.substring(5, recv.length() - 1));
                continue;
            }
            if (recv.startsWith("Module name")) {
                config.setName(recv.substring(13, recv.length() - 1));
                continue;
            }
            if (recv.startsWith("Firmware")) {
                config.setFirmwareRevision(recv.substring(19, recv.length() - 1));
                continue;
            }
            if (recv.startsWith("Current IP")) {
                config.setIPAddress(recv.substring(12, recv.length() - 1));
                continue;
            }
            if (recv.startsWith("Current subnet")) {
                config.setSubnetMask(recv.substring(21, recv.length() - 1));
                continue;
            }
            if (recv.startsWith("Current gateway")) {
                config.setGateway(recv.substring(17, recv.length() - 1));
                continue;
            }
            if (recv.startsWith("No IP")) continue;
            if (recv.startsWith("Using static")) {
                config.setDHCP(false);
                continue;
            }
            if (recv.startsWith("Using DHCP")) {
                config.setDHCP(true);
                continue;
            }
            if (recv.startsWith("UPnP")) {
                config.setUpnpPort(Integer.parseInt(recv.substring(11, recv.length() - 1), 10));
                continue;
            }
            if (recv.startsWith("Port")) {
                portconfiguration = new TUCPortConfiguration();
                portconfiguration.setPortNumber(Integer.parseInt(recv.substring(5, 7).trim(), 10));
                portconfiguration.setPinType(recv.substring(recv.length() - 5, recv.length() - 1));
                config.addPortConfiguration(portconfiguration);
                continue;
            }
            if (!recv.startsWith("  ")) continue;
            if ((recv = recv.substring(2)).startsWith("Baud")) {
                portconfiguration.setPortBaudrate(Integer.parseInt(recv.substring(11, recv.length() - 1), 10));
                continue;
            }
            if (recv.startsWith("Stop")) {
                portconfiguration.setPortStopbits(Integer.parseInt(recv.substring(11, recv.length() - 1), 10));
                continue;
            }
            if (recv.startsWith("Data")) {
                portconfiguration.setPortDatasize(Integer.parseInt(recv.substring(11, recv.length() - 1), 10));
                continue;
            }
            if (recv.startsWith("Flow")) {
                portconfiguration.setPortFlowcontrol(recv.substring(14, recv.length() - 1));
                continue;
            }
            if (recv.startsWith("Parity")) {
                portconfiguration.setPortParity(recv.substring(8, recv.length() - 1));
                continue;
            }
            if (recv.startsWith("I/O")) {
                portconfiguration.setTcpProtocol(recv.substring(8, recv.length() - 1));
                continue;
            }
            if (recv.startsWith("SERVER")) {
                portconfiguration.setTcpMode("SERVER");
                continue;
            }
            if (recv.startsWith("CLIENT")) {
                portconfiguration.setTcpMode("CLIENT");
                continue;
            }
            if (!recv.startsWith("  ")) continue;
            if ((recv = recv.substring(2)).startsWith("Local")) {
                portconfiguration.setTcpPort(Integer.parseInt(recv.substring(12, recv.length() - 1), 10));
                continue;
            }
            if (recv.startsWith("Timeout")) {
                portconfiguration.setTcpTimeout(Integer.parseInt(recv.substring(12, recv.length() - 9), 10));
                continue;
            }
            if (!recv.startsWith("Connecting")) continue;
            recv = recv.substring(14);
            String[] tmp = recv.split(":");
            portconfiguration.setTcpRemoteServerIP(tmp[0].substring(1, tmp[0].length() - 1));
            portconfiguration.setTcpRemoteServerPort(Integer.parseInt(tmp[1].substring(1, tmp[1].length() - 1), 10));
        } while (0 != this.connection.dataAvailable());
        config.setReachable(true);
        config.setRevision(this.getRevision());
        config.setFirmwareRevision(config.getRevision().substring(20, 22) + "." + config.getRevision().substring(22, 24));
        config.setHardwareName(this.getHardwareName());
        config.setHardwareRevision(this.getHardwareRevision());
        config.setRemoteConfiguration(true);
        return config;
    }

    public void setDeviceConfiguration(TUCConfiguration configuration) throws CommConnectionException, TUCException {
        try {
            this.setUPNPPort(configuration.getUpnpPort());
            this.setDeviceName(configuration.getName());
            if (configuration.isDHCP()) {
                this.setDHCP();
            } else {
                this.setStaticIP(configuration.getIPAddress(), configuration.getSubnetMask(), configuration.getGateway());
            }
            for (TUCPortConfiguration portConfig : configuration.getPortConfiguration()) {
                this.setPinType(portConfig.getPortNumber(), portConfig.getPinType());
                if (!portConfig.getPinType().equals("UART")) continue;
                this.setPortUARTConfiguration(portConfig.getPortNumber(), portConfig.getPortBaudrate(), portConfig.getPortStopbits(), portConfig.getPortDatasize(), portConfig.getPortFlowcontrol(), portConfig.getPortParity());
                this.setPortTCPConfiguration(portConfig.getPortNumber(), portConfig.getTcpProtocol(), portConfig.getTcpMode(), portConfig.getTcpPort(), portConfig.getTcpTimeout(), portConfig.getTcpRemoteServerIP(), portConfig.getTcpRemoteServerPort());
            }
        }
        catch (TUCException e) {
            if (4 == e.getErrorCode()) {
                this.discardSettings();
            }
            throw e;
        }
    }

    public void setUPNPPort(int upnpPort) throws CommConnectionException, TUCException {
        StringBuilder command = new StringBuilder("UPNP ");
        command.append(upnpPort);
        command.append('\r');
        this.connection.send(command.toString());
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            throw new TUCException(3, recv);
        }
    }

    public void setDeviceName(String name) throws CommConnectionException, TUCException {
        StringBuilder command = new StringBuilder("NAME ");
        command.append(name);
        command.append('\r');
        this.connection.send(command.toString());
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            throw new TUCException(3, recv);
        }
    }

    public void setUserPassword(String password) throws CommConnectionException, TUCException {
        StringBuilder command = new StringBuilder("SPW ");
        command.append(password);
        command.append('\r');
        this.connection.send(command.toString());
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            throw new TUCException(3, recv);
        }
    }

    public void allowFirmwareUpdate(boolean state) throws CommConnectionException, TUCException {
        StringBuilder command = new StringBuilder("FWUPDATE ");
        command.append(state ? (char)'1' : '0');
        command.append('\r');
        this.connection.send(command.toString());
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            throw new TUCException(3, recv);
        }
    }

    public void identify() throws CommConnectionException, TUCException {
        this.connection.send("IDENTIFY\r");
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            throw new TUCException(3, recv);
        }
    }

    public void setTCPTimeout(int milliseconds) throws CommConnectionException, TUCException {
        StringBuilder command = new StringBuilder("TCPTIMEOUT ");
        command.append(milliseconds);
        command.append('\r');
        this.connection.send(command.toString());
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            throw new TUCException(3, recv);
        }
    }

    public void applySettings() throws CommConnectionException, TUCException {
        this.connection.send("APPLY\r");
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            throw new TUCException(3, recv);
        }
        this.disconnect();
    }

    public void discardSettings() throws CommConnectionException, TUCException {
        this.connection.send("DISCARD\r");
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            throw new TUCException(3, recv);
        }
    }

    public void setDHCP() throws CommConnectionException, TUCException {
        this.connection.send("SIP DHCP\r");
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            throw new TUCException(3, recv);
        }
    }

    public void setStaticIP(String ipAddress, String subnetmask, String gateway) throws CommConnectionException, TUCException {
        Pattern pattern = Pattern.compile("(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])");
        if (null == ipAddress) {
            throw new TUCException(4, "IP Address is null");
        }
        if (!pattern.matcher(ipAddress).matches()) {
            throw new TUCException(4, "Wrong IP Address");
        }
        if (null == subnetmask) {
            throw new TUCException(4, "Subnetmask is null");
        }
        if (!pattern.matcher(subnetmask).matches()) {
            throw new TUCException(4, "Wrong Subnetmask");
        }
        if (null == gateway) {
            throw new TUCException(4, "Gateway Address is null");
        }
        if (!pattern.matcher(gateway).matches()) {
            throw new TUCException(4, "Wrong Gateway Address");
        }
        StringBuilder command = new StringBuilder();
        command.append("SIP STATIC ");
        command.append(ipAddress);
        command.append(' ');
        command.append(subnetmask);
        command.append(' ');
        command.append(gateway);
        command.append('\r');
        this.connection.send(command.toString());
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            throw new TUCException(3, recv);
        }
    }

    public void setPinType(int port, String pintype) throws CommConnectionException, TUCException {
        StringBuilder command = new StringBuilder();
        command.append("SPT ");
        command.append(port);
        command.append(' ');
        command.append(pintype);
        command.append('\r');
        this.connection.send(command.toString());
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            if (recv.equals("UPA\r")) {
                throw new TUCException(4, "wrong port number or pin type");
            }
            throw new TUCException(3, recv);
        }
    }

    public void setPortUARTConfiguration(int port, int baudrate, int stopbit, int datasize, String flowcontrol, String parity) throws CommConnectionException, TUCException {
        StringBuilder command = new StringBuilder();
        command.append("UART ");
        command.append(port);
        command.append(' ');
        command.append(baudrate);
        command.append(' ');
        command.append(stopbit);
        command.append(' ');
        command.append(datasize);
        command.append(' ');
        command.append(flowcontrol);
        command.append(' ');
        command.append(parity);
        command.append('\r');
        this.connection.send(command.toString());
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            if (recv.equals("UPA\r")) {
                throw new TUCException(4, "wrong parameter");
            }
            throw new TUCException(3, recv);
        }
    }

    public void setPortTCPConfiguration(int port, String protocol, String mode, int localport, int timeout, String remoteIPAddress, int remotePort) throws CommConnectionException, TUCException {
        StringBuilder command = new StringBuilder();
        command.append("MODE ");
        command.append(port);
        command.append(' ');
        command.append(protocol);
        command.append(' ');
        command.append(mode);
        command.append(' ');
        if (mode.equals("SERVER")) {
            command.append(localport);
            command.append(' ');
            command.append(timeout);
        } else if (mode.equals("CLIENT")) {
            command.append(remoteIPAddress);
            command.append(' ');
            command.append(remotePort);
            command.append(' ');
            command.append(localport);
            command.append(' ');
            command.append(timeout);
        } else {
            throw new TUCException(4, "mode must be 'SERVER' or 'CLIENT'");
        }
        command.append('\r');
        this.connection.send(command.toString());
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            if (recv.equals("UPA\r")) {
                throw new TUCException(4, "wrong parameter");
            }
            throw new TUCException(3, recv);
        }
    }

    public void restoreToFactoryDefaults() throws CommConnectionException, TUCException {
        this.connection.send("FACTORY\r");
        String recv = this.connection.recv(new int[]{13});
        if (!recv.equals("OK!\r")) {
            throw new TUCException(3, recv);
        }
        this.disconnect();
    }
}

