/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.tuc;

import com.metratec.lib.tuc.handler.TUCTCPControl;
import com.metratec.lib.tuc.handler.TUCUDPControl;
import com.metratec.lib.tuc.types.TUCDevice;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class TUCManager {
    private static final String LIBRARY_PROPERTY_FILENAME = "tuc-library.properties";
    private static Properties libraryProperties = null;

    public static Properties getBuildProperties() {
        return libraryProperties;
    }

    public static List<TUCDevice> scanDevices(int timeout) throws IOException {
        return TUCUDPControl.scanDevices(timeout);
    }

    public TUCUDPControl getUDPControl(TUCDevice device) {
        return new TUCUDPControl(device);
    }

    public TUCTCPControl getTCPControl(TUCDevice device) {
        return new TUCTCPControl(device);
    }

    static {
        libraryProperties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = TUCManager.class.getResourceAsStream(LIBRARY_PROPERTY_FILENAME);
            libraryProperties.load(inputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

