/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class NetworkHelper {
    private static int getFreeLocalPort() throws IOException {
        ServerSocket testSocket = new ServerSocket(0);
        int port = testSocket.getLocalPort();
        testSocket.close();
        return port;
    }

    public static NetworkInterface getNetworkInterfaceForRemoteConnection(String ip, int port) throws IOException {
        int localPort = NetworkHelper.getFreeLocalPort();
        List<NetworkInterface> netList = NetworkHelper.getStartedNetworkInterfaces();
        for (NetworkInterface netif : netList) {
            for (InterfaceAddress addr : netif.getInterfaceAddresses()) {
                try {
                    Socket socket = new Socket(ip, port, addr.getAddress(), localPort);
                    socket.close();
                    return netif;
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    public static InterfaceAddress getInterfaceAddressForRemoteConnection(String ip, int port) throws IOException {
        int localPort = NetworkHelper.getFreeLocalPort();
        List<NetworkInterface> netList = NetworkHelper.getStartedNetworkInterfaces();
        for (NetworkInterface netif : netList) {
            for (InterfaceAddress addr : netif.getInterfaceAddresses()) {
                try {
                    Socket socket = new Socket(ip, port, addr.getAddress(), localPort);
                    socket.close();
                    return addr;
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    public static InetAddress getInetAddressForRemoteConnection(String ip, int port) throws IOException {
        int localPort = NetworkHelper.getFreeLocalPort();
        List<NetworkInterface> netList = NetworkHelper.getStartedNetworkInterfaces();
        for (NetworkInterface netif : netList) {
            Enumeration<InetAddress> eAddr = netif.getInetAddresses();
            while (eAddr.hasMoreElements()) {
                InetAddress addr = eAddr.nextElement();
                try {
                    Socket socket = new Socket(ip, port, addr, localPort);
                    socket.close();
                    return addr;
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    public static List<NetworkInterface> getStartedNetworkInterfaces() throws SocketException {
        ArrayList<NetworkInterface> netList = new ArrayList<NetworkInterface>();
        for (NetworkInterface netIf : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            if (!netIf.isUp() || netIf.isLoopback() || null == netIf.getInetAddresses().nextElement() || null == netIf.getHardwareAddress() || 6 != netIf.getHardwareAddress().length || netIf.isVirtual()) continue;
            netList.add(netIf);
        }
        return netList;
    }

    public static void displayInterfaceInformation(NetworkInterface netint) throws SocketException {
        System.out.printf("Display name: %s%n", netint.getDisplayName());
        System.out.printf("Name: %s%n", netint.getName());
        Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
        for (InetAddress inetAddress : Collections.list(inetAddresses)) {
            System.out.printf("InetAddress: %s%n", inetAddress);
        }
        System.out.printf("Up? %s%n", netint.isUp());
        System.out.printf("Loopback? %s%n", netint.isLoopback());
        System.out.printf("PointToPoint? %s%n", netint.isPointToPoint());
        System.out.printf("Supports multicast? %s%n", netint.supportsMulticast());
        System.out.printf("Virtual? %s%n", netint.isVirtual());
        if (netint.getHardwareAddress() != null) {
            String mac = "";
            for (int i = 0; i < netint.getHardwareAddress().length; ++i) {
                mac = mac + String.format((i == 0 ? "" : "-") + "%02X", netint.getHardwareAddress()[i]);
            }
            System.out.println("Hardware address: " + mac);
        } else {
            System.out.println("Hardware address: none");
        }
        System.out.printf("MTU: %s%n", netint.getMTU());
        System.out.printf("%n", new Object[0]);
    }
}

