/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.firmware;

import com.metratec.lib.bootloader.ATMELBootloader;
import com.metratec.lib.bootloader.Bootloader;
import com.metratec.lib.bootloader.CC253XBootloader;
import com.metratec.lib.bootloader.MKUBootloader;
import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import com.metratec.lib.connection.Rs232Connection;
import com.metratec.lib.connection.UsbConnection;
import com.metratec.lib.firmware.CRC;
import com.metratec.lib.firmware.DeviceFirmwareException;
import com.metratec.lib.firmware.DeviceInfo;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.ArrayList;
import jd2xx.JD2XX;

public class DeviceFirmware {
    private ICommConnection connection;

    public DeviceFirmware(ICommConnection connection) {
        this.connection = connection;
    }

    public ICommConnection getConnection() {
        return this.connection;
    }

    public void setBaudrate(int baudrate) throws CommConnectionException {
        if (this.connection instanceof Rs232Connection) {
            Rs232Connection c = (Rs232Connection)this.connection;
            SerialPort port = c.getSerialPort();
            c.setBaudrate(baudrate);
            if (port == null) {
                return;
            }
            try {
                port.setSerialPortParams(c.getBaudrate(), c.getDataBit(), c.getStopBit(), c.getParity());
            }
            catch (UnsupportedCommOperationException e) {
                throw new CommConnectionException(18, "Could not set baudrate: " + e.getMessage());
            }
        }
        if (this.connection instanceof UsbConnection) {
            UsbConnection c = (UsbConnection)this.connection;
            JD2XX jd = c.getJD2XX();
            c.setBaudrate(baudrate);
            if (jd == null) {
                return;
            }
            try {
                jd.setBaudRate(c.getBaudrate());
            }
            catch (IOException e) {
                throw new CommConnectionException(34, e.getMessage());
            }
        }
    }

    private void flushRecvBuffer(int hardTimeout) throws CommConnectionException {
        long startTime = System.nanoTime();
        while (this.connection.recv() >= 0 && (System.nanoTime() - startTime) / 1000000L < (long)hardTimeout) {
        }
    }

    private void flushRecvBuffer() throws CommConnectionException {
        this.flushRecvBuffer(1000);
    }

    private static boolean isValidData(int c) {
        return c == 32 || c == 33 || c == 95 || c == 45 || c == 46 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 255;
    }

    private static boolean isValidData(byte[] data) {
        for (byte b : data) {
            if (DeviceFirmware.isValidData(b & 0xFF)) continue;
            return false;
        }
        return true;
    }

    private static String normalizeField(String str) {
        return (str.charAt(0) & 0xFF) != 255 ? str : null;
    }

    public void dispatch(String command, boolean crcMode) throws CommConnectionException {
        if (crcMode) {
            command = (String)command + " ";
            command = (String)command + String.format("%04X", CRC.get((String)command));
        }
        this.connection.send((String)command + "\r");
    }

    public void dispatch(String command) throws CommConnectionException {
        this.dispatch(command, false);
    }

    public String evaluate(String command, boolean crcMode) throws CommConnectionException {
        this.dispatch(command, crcMode);
        String ret = this.connection.recv(new int[]{13});
        ret = ret.substring(0, ret.length() - 1);
        if (crcMode) {
            ret = ret.substring(0, ret.lastIndexOf(32));
        }
        return ret;
    }

    public String evaluate(String command) throws CommConnectionException {
        return this.evaluate(command, false);
    }

    private boolean checkBaudrate(int baudrate) throws CommConnectionException {
        this.setBaudrate(baudrate);
        block0: for (int i = 0; i < 2; ++i) {
            this.connection.send("k\rV\r");
            this.dispatch("WAK", false);
            this.dispatch("WAK", true);
            this.dispatch("BRK", false);
            this.dispatch("BRK", true);
            this.dispatch("#C0#", false);
            this.dispatch("#C0#", true);
            this.dispatch("#P#", false);
            this.dispatch("#P#", true);
            int c = this.connection.recv();
            if (c == 235) {
                this.flushRecvBuffer();
                return true;
            }
            long startTime = System.nanoTime();
            do {
                if (!DeviceFirmware.isValidData(c)) {
                    this.flushRecvBuffer();
                    continue block0;
                }
                c = this.connection.recv();
                if (c < 0) continue block0;
                if (c != 13) continue;
                this.flushRecvBuffer();
                return true;
            } while ((System.nanoTime() - startTime) / 1000000L < 1000L);
        }
        return false;
    }

    public void guessBaudrate(int ... hintBaudrates) throws CommConnectionException, DeviceFirmwareException {
        int[] defaultBaudrates = new int[]{115200, 19200, 57600, 460800, 9600};
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        if (!(this.connection instanceof Rs232Connection) && !(this.connection instanceof UsbConnection)) {
            this.initialize();
            return;
        }
        this.connection.setRecvTimeout(300);
        ArrayList<Integer> candidateBaudrates = new ArrayList<Integer>(hintBaudrates.length + defaultBaudrates.length);
        for (int baudrate : hintBaudrates) {
            if (candidateBaudrates.contains(baudrate)) continue;
            candidateBaudrates.add(baudrate);
        }
        for (int baudrate : defaultBaudrates) {
            if (candidateBaudrates.contains(baudrate)) continue;
            candidateBaudrates.add(baudrate);
        }
        Object object = candidateBaudrates.iterator();
        while (object.hasNext()) {
            int baudrate = (Integer)object.next();
            if (!this.checkBaudrate(baudrate)) continue;
            return;
        }
        throw new DeviceFirmwareException("Unable to guess baudrate");
    }

    public void initialize() throws CommConnectionException {
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.connection.setRecvTimeout(1000);
        this.dispatch("WAK", false);
        this.dispatch("WAK", true);
        this.dispatch("BRK", false);
        this.dispatch("BRK", true);
        this.dispatch("#C0#", false);
        this.dispatch("#C0#", true);
        this.dispatch("#P#", false);
        this.dispatch("#P#", true);
        this.dispatch("k");
        this.flushRecvBuffer();
    }

    public DeviceInfo getInfo() throws CommConnectionException {
        DeviceInfo info;
        byte[] buffer = new byte[1];
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.connection.setRecvTimeout(1000);
        this.connection.send("k\rV\r");
        this.connection.recv(buffer);
        if (buffer[0] == -21) {
            this.flushRecvBuffer();
            MKUBootloader btl = new MKUBootloader(this.connection);
            return ((Bootloader)btl).getInfo();
        }
        Object resp = new String(buffer) + this.connection.recv(new int[]{13});
        for (int i = 0; i < 100; ++i) {
            switch (resp) {
                case "ERR\r": 
                case "CONFIG MODE\r": {
                    info = new DeviceInfo(DeviceInfo.State.FIRMWARE);
                    resp = this.evaluateCC253X("REV", 20);
                    if (resp == null) break;
                    info.firmwareName = ((String)resp).substring(0, 16).trim();
                    info.firmwareRevision = ((String)resp).substring(16, 20);
                    resp = this.evaluateCC253X("HWR", 20);
                    if (resp == null) break;
                    info.hardwareName = DeviceFirmware.normalizeField(((String)resp).substring(0, 16).trim());
                    info.hardwareRevision = DeviceFirmware.normalizeField(((String)resp).substring(16, 20));
                    resp = this.evaluateCC253X("RSN", 16);
                    if (resp == null) break;
                    info.serialNumber = DeviceFirmware.normalizeField((String)resp);
                    return info;
                }
                case "IPS_BTL\r": {
                    CC253XBootloader btl = new CC253XBootloader(this.connection);
                    return ((Bootloader)btl).getInfo();
                }
            }
            if (resp != null && ((String)resp).length() == 16) {
                this.connection.setRecvTimeout(300);
                this.flushRecvBuffer();
                ATMELBootloader btl = new ATMELBootloader(this.connection);
                return ((Bootloader)btl).getInfo();
            }
            try {
                resp = this.connection.recv(new int[]{13});
                continue;
            }
            catch (CommConnectionException e) {
                if (e.getErrorCode() == 8) break;
                throw e;
            }
        }
        this.connection.setRecvTimeout(300);
        info = this.getInfoFirmware(false);
        if (info == null) {
            info = this.getInfoFirmware(true);
        }
        return info;
    }

    private String evaluateCC253X(String command, int expectedLength) throws CommConnectionException {
        block4: {
            String resp;
            this.dispatch(command);
            do {
                try {
                    resp = this.connection.recv(new int[]{13});
                }
                catch (CommConnectionException e) {
                    if (e.getErrorCode() != 8) {
                        throw e;
                    }
                    break block4;
                }
                resp = resp.substring(0, resp.length() - 1);
                if (!resp.startsWith(command + " ")) continue;
                resp = resp.substring(command.length() + 1);
            } while (resp.length() != expectedLength);
            return resp;
        }
        return null;
    }

    private DeviceInfo getInfoFirmware(boolean crcMode) throws CommConnectionException {
        DeviceInfo info = new DeviceInfo(DeviceInfo.State.FIRMWARE);
        String resp = this.evaluate("RSN", crcMode);
        this.flushRecvBuffer();
        if (resp.length() == 16) {
            info.serialNumber = DeviceFirmware.normalizeField(resp);
        }
        resp = this.evaluate("RFW", crcMode);
        this.flushRecvBuffer();
        if (resp.length() == 20 || resp.length() == 21) {
            info.firmwareName = resp.substring(0, 16).trim();
            info.firmwareRevision = resp.substring(resp.length() - 4);
            resp = this.evaluate("RHW", crcMode);
            this.flushRecvBuffer();
            info.hardwareName = DeviceFirmware.normalizeField(resp.substring(0, 16).trim());
            info.hardwareRevision = DeviceFirmware.normalizeField(resp.substring(resp.length() - 4));
            return info;
        }
        resp = this.evaluate("REV", crcMode);
        this.flushRecvBuffer();
        if (resp.length() == 23) {
            info.hardwareName = resp.substring(0, 15);
            if (info.hardwareName.matches(".*F[0-9]{2}$")) {
                info.hardwareName = info.hardwareName.substring(0, 12);
            }
            info.hardwareName = info.hardwareName.trim();
            info.hardwareRevision = resp.substring(15, 19);
            info.firmwareName = resp.substring(0, 15).trim();
            info.firmwareRevision = resp.substring(19, 23);
            return info;
        }
        if (resp.length() == 24) {
            info.hardwareName = DeviceFirmware.normalizeField(resp.substring(0, 13).trim());
            info.hardwareRevision = DeviceFirmware.normalizeField(resp.substring(16, 20));
            info.firmwareName = resp.substring(0, 16).trim();
            info.firmwareRevision = resp.substring(20, 24);
            return info;
        }
        return null;
    }
}

