/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.bootloader;

import com.metratec.lib.bootloader.Bootloader;
import com.metratec.lib.bootloader.BootloaderException;
import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import com.metratec.lib.firmware.CRC;
import com.metratec.lib.firmware.DeviceInfo;
import java.util.Arrays;

public abstract class UnifiedBootloader
extends Bootloader {
    protected UnifiedBootloader(ICommConnection connection) {
        super(connection);
    }

    protected byte[] encodeCommand(CommandCode cmd, byte[] payload) {
        byte[] ret = new byte[1 + payload.length + 2];
        ret[0] = (byte)cmd.getCode();
        for (int i = 0; i < payload.length; ++i) {
            ret[1 + i] = payload[i];
        }
        int crc = CRC.get(ret, 0, ret.length - 2);
        ret[ret.length - 2] = (byte)(crc & 0xFF);
        ret[ret.length - 1] = (byte)(crc >> 8);
        return ret;
    }

    protected byte[] encodeCommand(CommandCode cmd, String payload) {
        return this.encodeCommand(cmd, payload.getBytes());
    }

    protected byte[] encodeCommand(CommandCode cmd) {
        return this.encodeCommand(cmd, new byte[0]);
    }

    protected Response decodeResponse(byte[] data) {
        Response ret = new Response();
        int crc = CRC.get(data, 0, data.length - 2);
        if (data[data.length - 2] != (byte)(crc & 0xFF) || data[data.length - 1] != (byte)(crc >> 8)) {
            return null;
        }
        ret.command = data[0] & 0xFF & 0xFFFFFF7F;
        ret.rc = ReturnCode.getFromCode(data[1]);
        if (ret.rc == null) {
            return null;
        }
        ret.payload = Arrays.copyOfRange(data, 2, data.length - 2);
        return ret;
    }

    @Override
    public DeviceInfo getInfo() throws CommConnectionException {
        DeviceInfo info = new DeviceInfo(DeviceInfo.State.BOOTLOADER);
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.setTimeouts(1000, 300);
        byte[] buffer = new byte[20];
        this.connection.send(this.encodeCommand(CommandCode.READ_HW_NAME));
        this.connection.recv(buffer);
        Response response = this.decodeResponse(buffer);
        if (response == null || response.rc != ReturnCode.SUCCESS) {
            return null;
        }
        if (this.isInfoValid(response.payload)) {
            info.hardwareName = new String(response.payload).trim();
        }
        this.connection.send(this.encodeCommand(CommandCode.READ_FW_NAME));
        this.connection.recv(buffer);
        response = this.decodeResponse(buffer);
        if (response == null || response.rc != ReturnCode.SUCCESS) {
            return null;
        }
        if (this.isInfoValid(response.payload)) {
            info.firmwareName = new String(response.payload).trim();
        }
        buffer = new byte[8];
        this.connection.send(this.encodeCommand(CommandCode.READ_HW_REV));
        this.connection.recv(buffer);
        response = this.decodeResponse(buffer);
        if (response == null || response.rc != ReturnCode.SUCCESS) {
            return null;
        }
        if (this.isInfoValid(response.payload)) {
            info.hardwareRevision = new String(response.payload);
        }
        this.connection.send(this.encodeCommand(CommandCode.READ_FW_REV));
        this.connection.recv(buffer);
        response = this.decodeResponse(buffer);
        if (response == null || response.rc != ReturnCode.SUCCESS) {
            return null;
        }
        if (this.isInfoValid(response.payload)) {
            info.firmwareRevision = new String(response.payload);
        }
        try {
            info.serialNumber = this.getSerialNumber();
        }
        catch (BootloaderException e) {
            return null;
        }
        return info;
    }

    @Override
    public String getBootloaderRevision() throws CommConnectionException {
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.setTimeouts(1000, 300);
        byte[] buffer = new byte[8];
        this.connection.send(this.encodeCommand(CommandCode.READ_BTL_REV));
        this.connection.recv(buffer);
        Response response = this.decodeResponse(buffer);
        if (response == null || response.rc != ReturnCode.SUCCESS) {
            return null;
        }
        return new String(response.payload);
    }

    public String getSerialNumber() throws CommConnectionException, BootloaderException {
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.setTimeouts(1000, 300);
        byte[] buffer = new byte[20];
        this.connection.send(this.encodeCommand(CommandCode.READ_SN));
        this.connection.recv(buffer);
        Response response = this.decodeResponse(buffer);
        if (response == null) {
            throw new BootloaderException("Invalid bootloader response");
        }
        if (response.rc != ReturnCode.SUCCESS) {
            throw new BootloaderException("Invalid bootloader response: " + response.rc);
        }
        return (response.payload[0] & 0xFF) == 255 ? null : new String(response.payload);
    }

    public void setSerialNumber(String serialNumber) throws CommConnectionException, BootloaderException, IllegalArgumentException {
        if (serialNumber.length() != 16) {
            throw new IllegalArgumentException("Serial number must be 16 characters");
        }
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.setTimeouts(1000, 300);
        byte[] buffer = new byte[4];
        this.connection.send(this.encodeCommand(CommandCode.WRITE_SN, serialNumber));
        this.connection.recv(buffer);
        Response response = this.decodeResponse(buffer);
        if (response == null) {
            throw new BootloaderException("Invalid bootloader response");
        }
        if (response.rc != ReturnCode.SUCCESS) {
            throw new BootloaderException("Invalid bootloader response: " + response.rc);
        }
    }

    public void setHardwareName(String hardwareName) throws CommConnectionException, BootloaderException, IllegalArgumentException {
        if (hardwareName.length() > 16) {
            throw new IllegalArgumentException("Hardware name too long");
        }
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.setTimeouts(1000, 300);
        hardwareName = String.format("%-16s", hardwareName);
        this.connection.send(this.encodeCommand(CommandCode.WRITE_HW_NAME, hardwareName));
        byte[] buffer = new byte[4];
        this.connection.recv(buffer);
        Response response = this.decodeResponse(buffer);
        if (response == null || response.rc != ReturnCode.SUCCESS) {
            this.connection.send(this.encodeCommand(CommandCode.READ_HW_NAME));
            buffer = new byte[20];
            this.connection.recv(buffer);
            response = this.decodeResponse(buffer);
            if (response == null) {
                throw new BootloaderException("Invalid bootloader response");
            }
            if (response.rc != ReturnCode.SUCCESS) {
                throw new BootloaderException("Invalid bootloader response: " + response.rc);
            }
            if (!hardwareName.equals(new String(response.payload))) {
                throw new BootloaderException("Hardware name already set to a different value");
            }
        }
    }

    public void setHardwareRevision(String hardwareRevision) throws CommConnectionException, BootloaderException, IllegalArgumentException {
        if (hardwareRevision.length() != 4) {
            throw new IllegalArgumentException("Hardware revision must be 4 characters");
        }
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.setTimeouts(1000, 300);
        this.connection.send(this.encodeCommand(CommandCode.WRITE_HW_REV, hardwareRevision));
        byte[] buffer = new byte[4];
        this.connection.recv(buffer);
        Response response = this.decodeResponse(buffer);
        if (response == null || response.rc != ReturnCode.SUCCESS) {
            this.connection.send(this.encodeCommand(CommandCode.READ_HW_REV));
            buffer = new byte[8];
            this.connection.recv(buffer);
            response = this.decodeResponse(buffer);
            if (response == null) {
                throw new BootloaderException("Invalid bootloader response");
            }
            if (response.rc != ReturnCode.SUCCESS) {
                throw new BootloaderException("Invalid bootloader response: " + response.rc);
            }
            if (!hardwareRevision.equals(new String(response.payload))) {
                throw new BootloaderException("Hardware revision already set to a different value");
            }
        }
    }

    @Override
    public void startFirmware() throws CommConnectionException, BootloaderException {
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.setTimeouts(1000, 300);
        byte[] buffer = new byte[4];
        this.connection.send(this.encodeCommand(CommandCode.RESET));
        this.connection.recv(buffer);
        Response response = this.decodeResponse(buffer);
        if (response == null) {
            throw new BootloaderException("Invalid bootloader response");
        }
        if (response.rc != ReturnCode.SUCCESS) {
            throw new BootloaderException("Invalid bootloader response: " + response.rc);
        }
    }

    protected class Response {
        int command;
        ReturnCode rc;
        byte[] payload;

        protected Response() {
        }
    }

    protected static enum ReturnCode {
        SUCCESS(0, "Success"),
        FAILURE(1, "Failure"),
        INVALID_COMMAND(2, "Invalid command"),
        CRC(3, "CRC error"),
        BLOCK_ID(4, "Invalid block number"),
        INVALID_CODE(5, "Invalid code"),
        HW_MATCH(6, "Invalid hardware"),
        FLASH_NOT_ERASED(7, "Flash not erased"),
        FLASH_TOO_SMALL(8, "Flash too small"),
        INVALID_CHAR(9, "Invalid character"),
        UART_TIMEOUT(10, "UART timeout"),
        INVALID_CHIP(11, "Invalid chip ID");

        private int code;
        private String description;

        private ReturnCode(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public String toString() {
            return String.format("%s (0x%02X)", this.description, this.code);
        }

        public static ReturnCode getFromCode(int code) {
            for (ReturnCode rc : ReturnCode.values()) {
                if (rc.code != code) continue;
                return rc;
            }
            return null;
        }
    }

    protected static enum CommandCode {
        HANDSHAKE(1),
        WRITE(2),
        READ_SN(3),
        READ_HW_NAME(4),
        READ_HW_REV(5),
        READ_FW_NAME(6),
        READ_FW_REV(7),
        READ_FLASH_SIZE(8),
        ERASE(10),
        READ_BTL_REV(12),
        READ_BTL_NAME(13),
        VALIDATE(11),
        RESET(65),
        WRITE_FORCE(66),
        WRITE_SN(67),
        WRITE_HW_NAME(68),
        WRITE_HW_REV(69),
        HANDSHAKE_FORCE(79),
        I(105);

        private int code;

        private CommandCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

