/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.bootloader;

import com.metratec.lib.bootloader.BootloaderException;
import com.metratec.lib.bootloader.UnifiedBootloader;
import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import com.metratec.lib.firmware.DeviceFirmware;
import com.metratec.lib.firmware.DeviceFirmwareException;
import java.util.Arrays;

public class MKUBootloader
extends UnifiedBootloader {
    public MKUBootloader(ICommConnection connection) {
        super(connection);
    }

    @Override
    public void initializeAfterReset(int bootloaderBaudrate) throws CommConnectionException, BootloaderException {
        DeviceFirmware fw = new DeviceFirmware(this.connection);
        byte[] iCommand = this.encodeCommand(UnifiedBootloader.CommandCode.I);
        byte[] buffer = new byte[4];
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.setTcpNoDelay(true);
        fw.setBaudrate(bootloaderBaudrate);
        while (true) {
            this.setTimeouts(5, 300);
            this.connection.send(iCommand);
            try {
                this.connection.recv(buffer);
            }
            catch (CommConnectionException e) {
                continue;
            }
            UnifiedBootloader.Response resp = this.decodeResponse(buffer);
            if (resp != null && resp.command == 105 && resp.rc == UnifiedBootloader.ReturnCode.SUCCESS && resp.payload.length == 0) {
                this.setTcpNoDelay(false);
                this.setTimeouts(20, 300);
                this.flushRecvBuffer();
                return;
            }
            this.setTimeouts(20, 300);
            this.flushRecvBuffer();
        }
    }

    @Override
    public void initialize(int firmwareBaudrate, int bootloaderBaudrate) throws CommConnectionException, BootloaderException {
        DeviceFirmware fw = new DeviceFirmware(this.connection);
        byte[] buffer = new byte[4];
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        try {
            fw.guessBaudrate(firmwareBaudrate, bootloaderBaudrate);
        }
        catch (DeviceFirmwareException e) {
            throw new BootloaderException(e.getMessage());
        }
        this.setTimeouts(1000, 300);
        fw.dispatch("BTL", false);
        this.connection.recv(buffer);
        this.flushRecvBuffer();
        if (Arrays.equals(buffer, "OK!\r".getBytes())) {
            try {
                fw.guessBaudrate(bootloaderBaudrate);
            }
            catch (DeviceFirmwareException e) {
                throw new BootloaderException(e.getMessage());
            }
            return;
        }
        UnifiedBootloader.Response resp = this.decodeResponse(buffer);
        if (resp != null && resp.command == 66 && resp.rc == UnifiedBootloader.ReturnCode.INVALID_COMMAND && resp.payload.length == 0) {
            return;
        }
        fw.dispatch("BTL", true);
        this.connection.recv(buffer);
        this.flushRecvBuffer();
        if (Arrays.equals(buffer, "OK! ".getBytes())) {
            try {
                fw.guessBaudrate(bootloaderBaudrate);
            }
            catch (DeviceFirmwareException e) {
                throw new BootloaderException(e.getMessage());
            }
            return;
        }
        throw new BootloaderException("Unexpected firmware/bootloader responses!");
    }
}

