/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.bootloader;

import com.metratec.lib.bootloader.BootloaderException;
import com.metratec.lib.bootloader.UnifiedBootloader;
import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import com.metratec.lib.firmware.DeviceFirmware;
import com.metratec.lib.firmware.DeviceFirmwareException;

public class CC253XBootloader
extends UnifiedBootloader {
    public CC253XBootloader(ICommConnection connection) {
        super(connection);
    }

    @Override
    public void initialize(int firmwareBaudrate, int bootloaderBaudrate) throws CommConnectionException, BootloaderException {
        DeviceFirmware fw = new DeviceFirmware(this.connection);
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        try {
            fw.guessBaudrate(firmwareBaudrate, bootloaderBaudrate);
        }
        catch (DeviceFirmwareException e) {
            throw new BootloaderException(e.getMessage());
        }
        this.setTimeouts(1000, 300);
        this.flushRecvBuffer();
        this.connection.send("k\r");
        for (int i = 0; i < 1000; ++i) {
            int last = -1;
            switch (this.connection.recv(new int[]{13})) {
                case "ERR\r": 
                case "CONFIG MODE\r": {
                    this.connection.send("BTL\r");
                    this.setTimeouts(20, 300);
                    this.flushRecvBuffer();
                    try {
                        fw.guessBaudrate(bootloaderBaudrate);
                    }
                    catch (DeviceFirmwareException e) {
                        throw new BootloaderException(e.getMessage());
                    }
                    this.connection.send("k\r");
                    if (!this.connection.recv(new int[]{13}).equals("IPS_BTL\r")) {
                        throw new BootloaderException("Invalid bootloader response!");
                    }
                    return;
                }
                case "IPS_BTL\r": {
                    this.flushRecvBuffer();
                    return;
                }
            }
        }
        throw new BootloaderException("Unexpected firmware/bootloader response!");
    }
}

