/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.bootloader;

import com.metratec.lib.bootloader.BootloaderException;
import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import com.metratec.lib.connection.TcpConnection;
import com.metratec.lib.connection.UsbConnection;
import com.metratec.lib.firmware.DeviceFirmware;
import com.metratec.lib.firmware.DeviceInfo;
import java.net.SocketException;

public abstract class Bootloader {
    protected ICommConnection connection;

    protected Bootloader(ICommConnection connection) {
        this.connection = connection;
    }

    public ICommConnection getConnection() {
        return this.connection;
    }

    protected void setTimeouts(int readTimeout, int writeTimeout) throws CommConnectionException {
        this.connection.setRecvTimeout(readTimeout);
        if (this.connection instanceof UsbConnection) {
            ((UsbConnection)this.connection).setSendTimeout(writeTimeout);
        }
    }

    protected void setTcpNoDelay(boolean on) {
        if (this.connection instanceof TcpConnection) {
            TcpConnection c = (TcpConnection)this.connection;
            try {
                if (c.getSocket() != null) {
                    c.getSocket().setTcpNoDelay(on);
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    protected void flushRecvBuffer(int hardTimeout) throws CommConnectionException {
        long startTime = System.nanoTime();
        while (this.connection.recv() >= 0 && (System.nanoTime() - startTime) / 1000000L < (long)hardTimeout) {
        }
    }

    protected void flushRecvBuffer() throws CommConnectionException {
        this.flushRecvBuffer(1000);
    }

    protected boolean isInfoValid(byte[] data, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            if (data[i] != -1) continue;
            return false;
        }
        return true;
    }

    protected boolean isInfoValid(byte[] data) {
        return this.isInfoValid(data, 0, data.length);
    }

    public void initializeAfterReset(int bootloaderBaudrate) throws CommConnectionException, BootloaderException {
        int c;
        DeviceFirmware fw = new DeviceFirmware(this.connection);
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.setTcpNoDelay(true);
        fw.setBaudrate(bootloaderBaudrate);
        this.setTimeouts(5, 300);
        do {
            this.connection.send("i");
        } while ((c = this.connection.recv()) < 0 || c != 76 || (c = this.connection.recv()) >= 0 && c != 13);
        this.setTcpNoDelay(false);
    }

    public abstract void initialize(int var1, int var2) throws CommConnectionException, BootloaderException;

    public void initializeNormallyAfterReset(int firmwareBaudrate, int bootloaderBaudrate) throws CommConnectionException, BootloaderException {
        this.setTimeouts(500, 300);
        this.flushRecvBuffer(500);
        this.initialize(firmwareBaudrate, bootloaderBaudrate);
    }

    public abstract DeviceInfo getInfo() throws CommConnectionException;

    public abstract String getBootloaderRevision() throws CommConnectionException;

    public abstract void startFirmware() throws CommConnectionException, BootloaderException;
}

