/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.bootloader;

import com.metratec.lib.bootloader.Bootloader;
import com.metratec.lib.bootloader.BootloaderException;
import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import com.metratec.lib.connection.MpsTunnelConnection;
import com.metratec.lib.connection.SerialConnection;
import com.metratec.lib.firmware.DeviceFirmware;
import com.metratec.lib.firmware.DeviceFirmwareException;
import com.metratec.lib.firmware.DeviceInfo;
import java.util.Arrays;

public class ATMELBootloader
extends Bootloader {
    public ATMELBootloader(ICommConnection connection) {
        super(connection);
    }

    private void initializeSimple(int firmwareBaudrate, int bootloaderBaudrate) throws CommConnectionException, BootloaderException {
        byte[] buffer;
        DeviceFirmware fw;
        block8: {
            fw = new DeviceFirmware(this.connection);
            buffer = new byte[4];
            if (!this.connection.isConnected()) {
                this.connection.connect();
            }
            try {
                fw.guessBaudrate(firmwareBaudrate, bootloaderBaudrate);
            }
            catch (DeviceFirmwareException e) {
                throw new BootloaderException(e.getMessage());
            }
            try {
                if (this.getInfo() != null) {
                    return;
                }
            }
            catch (CommConnectionException e) {
                if (e.getErrorCode() == 8) break block8;
                throw e;
            }
        }
        fw.dispatch("BTL", false);
        this.connection.recv(buffer);
        this.flushRecvBuffer();
        if (Arrays.equals(buffer, "OK!\r".getBytes())) {
            return;
        }
        fw.dispatch("BTL", true);
        this.connection.recv(buffer);
        this.flushRecvBuffer();
        if (Arrays.equals(buffer, "OK! ".getBytes())) {
            return;
        }
        throw new BootloaderException("Unexpected firmware responses!");
    }

    private void initializeCompatible(int firmwareBaudrate, int bootloaderBaudrate) throws CommConnectionException, BootloaderException {
        DeviceFirmware fw = new DeviceFirmware(this.connection);
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        for (int i = 0; i < 10; ++i) {
            block13: {
                this.setTcpNoDelay(false);
                try {
                    fw.guessBaudrate(firmwareBaudrate, bootloaderBaudrate);
                }
                catch (DeviceFirmwareException e) {
                    throw new BootloaderException(e.getMessage());
                }
                try {
                    if (this.getInfo() != null) {
                        return;
                    }
                }
                catch (CommConnectionException e) {
                    if (e.getErrorCode() == 8) break block13;
                    throw e;
                }
            }
            this.setTcpNoDelay(true);
            this.setTimeouts(5, 300);
            fw.dispatch("BTL", false);
            fw.dispatch("BTL", true);
            if (this.connection instanceof SerialConnection && ((SerialConnection)this.connection).getBaudrate() != bootloaderBaudrate) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                fw.setBaudrate(bootloaderBaudrate);
            }
            for (int j = 0; j < 160; ++j) {
                String line;
                this.connection.send("i");
                try {
                    line = this.connection.recv(new int[]{13});
                }
                catch (CommConnectionException e) {
                    if (e.getErrorCode() == 8) continue;
                    this.setTcpNoDelay(false);
                    throw e;
                }
                if (!line.equals("L\r")) continue;
                this.setTcpNoDelay(false);
                this.setTimeouts(500, 300);
                this.flushRecvBuffer();
                return;
            }
            this.setTimeouts(500, 300);
            this.flushRecvBuffer();
        }
        throw new BootloaderException("Too many unsuccessful attempts to enter bootloader!");
    }

    @Override
    public void initialize(int firmwareBaudrate, int bootloaderBaudrate) throws CommConnectionException, BootloaderException {
        if (this.connection instanceof MpsTunnelConnection) {
            this.initializeSimple(firmwareBaudrate, bootloaderBaudrate);
        } else {
            this.initializeCompatible(firmwareBaudrate, bootloaderBaudrate);
        }
    }

    @Override
    public void initializeNormallyAfterReset(int firmwareBaudrate, int bootloaderBaudrate) throws CommConnectionException, BootloaderException {
        this.setTimeouts(200, 300);
        this.flushRecvBuffer(200);
        this.initialize(firmwareBaudrate, bootloaderBaudrate);
    }

    @Override
    public DeviceInfo getInfo() throws CommConnectionException {
        DeviceInfo info = new DeviceInfo(DeviceInfo.State.BOOTLOADER);
        byte[] buffer = new byte[31];
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.setTimeouts(1000, 300);
        this.connection.send("V\r");
        this.connection.recv(buffer);
        if (this.isInfoValid(buffer, 0, 15)) {
            info.hardwareName = new String(buffer, 0, 15);
            if (info.hardwareName.matches(".*F[0-9]{2}$")) {
                info.hardwareName = info.hardwareName.substring(0, 12);
            }
            info.hardwareName = info.hardwareName.trim();
            info.firmwareName = new String(buffer, 0, 15).trim();
        }
        if (this.isInfoValid(buffer, 16, 4)) {
            info.hardwareRevision = new String(buffer, 16, 4);
        }
        if (this.isInfoValid(buffer, 20, 4)) {
            info.firmwareRevision = new String(buffer, 20, 4);
        }
        return info;
    }

    @Override
    public String getBootloaderRevision() throws CommConnectionException {
        byte[] buffer = new byte[31];
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.setTimeouts(1000, 300);
        this.connection.send("V\r");
        this.connection.recv(buffer);
        return new String(buffer, 25, 2) + new String(buffer, 28, 2);
    }

    @Override
    public void startFirmware() throws CommConnectionException, BootloaderException {
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.setTimeouts(1000, 300);
        this.connection.send("g");
        if (this.connection.recv() != 103) {
            throw new BootloaderException("Unexpected bootloader response or timeout");
        }
    }
}

