/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.METJFlash;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Signature;
import java.security.SignatureException;

class UpdateSignatureInputStream
extends FilterInputStream {
    private Signature signature;
    private int keepBytes;

    public UpdateSignatureInputStream(InputStream in, Signature signature, int keepBytes) {
        super(in);
        this.signature = signature;
        this.keepBytes = keepBytes;
    }

    @Override
    public int available() throws IOException {
        return super.available() - this.keepBytes;
    }

    @Override
    public int read() throws IOException {
        if (this.available() < 1) {
            return -1;
        }
        int ret = super.read();
        try {
            if (ret >= 0) {
                this.signature.update((byte)ret);
            }
        }
        catch (SignatureException signatureException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        len = Math.min(this.available(), len);
        int ret = super.read(b, off, len);
        try {
            if (ret >= 0) {
                this.signature.update(b, off, ret);
            }
        }
        catch (SignatureException signatureException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        return Math.max(this.read(new byte[(int)n]), 0);
    }
}

