/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.METJFlash;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ReleaseArchive
extends ZipFile {
    private static final String CHANGELOG_NAME = "ChangeLog.txt";
    private ZipEntry metjEntry = null;
    private ZipEntry changeLogEntry = null;

    public ReleaseArchive(File file) throws IOException {
        super(file);
        Enumeration<? extends ZipEntry> entries = this.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.getName().endsWith(".metj")) {
                this.metjEntry = entry;
                continue;
            }
            if (!entry.getName().equals(CHANGELOG_NAME)) continue;
            this.changeLogEntry = entry;
        }
        if (this.metjEntry == null) {
            throw new ZipException("Missing metj file");
        }
        if (this.changeLogEntry == null) {
            throw new ZipException("Missing entry \"ChangeLog.txt\"");
        }
    }

    public ReleaseArchive(InputStream stream) throws IOException {
        this(ReleaseArchive.saveStream(stream));
    }

    private static File saveStream(InputStream stream) throws IOException {
        Path tempPath = Files.createTempFile("metj-archive", "zip", new FileAttribute[0]);
        File tempFile = tempPath.toFile();
        tempFile.deleteOnExit();
        Files.copy(stream, tempPath, new CopyOption[0]);
        return tempFile;
    }

    public InputStream getChangeLog() throws IOException {
        return this.getInputStream(this.changeLogEntry);
    }

    public InputStream getMetj() throws IOException {
        return this.getInputStream(this.metjEntry);
    }
}

