/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.METJFlash;

import com.metratec.lib.METJFlash.METJFlashException;
import com.metratec.lib.METJFlash.UpdateSignatureInputStream;
import com.metratec.lib.METJFlash.UserInterface;
import com.metratec.lib.bootloader.ATMELBootloader;
import com.metratec.lib.bootloader.Bootloader;
import com.metratec.lib.bootloader.BootloaderException;
import com.metratec.lib.bootloader.CC253XBootloader;
import com.metratec.lib.bootloader.MKUBootloader;
import com.metratec.lib.connection.CommConnectionException;
import com.metratec.lib.connection.ICommConnection;
import com.metratec.lib.connection.UsbConnection;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.X509EncodedKeySpec;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.xml.bind.DatatypeConverter;

public class METJFlash {
    private static final int METJ_FORMAT_VERSION = 2;
    private static final int METJ_CRC_RETRIES = 3;
    private static final int METJ_SIG_SIZE = 348;
    private JsonObject metjObj = null;
    private boolean verifySignature;
    private boolean initializeAfterReset = false;
    private boolean skipOptionalMetlets = false;
    private int firmwareBaudrate = 0;
    private int bootloaderBaudrate = 0;
    private int responseFlushTime = 0;
    private ICommConnection connection = null;

    public METJFlash(boolean verifySignature) {
        this.verifySignature = verifySignature;
    }

    public METJFlash() {
        this(true);
    }

    public boolean getVerifySignature() {
        return this.verifySignature;
    }

    public void setInitializeAfterReset(boolean initializeAfterReset) {
        this.initializeAfterReset = initializeAfterReset;
    }

    public boolean getInitializeAfterReset() {
        return this.initializeAfterReset;
    }

    public void setSkipOptionalMetlets(boolean skipOptionalMetlets) {
        this.skipOptionalMetlets = skipOptionalMetlets;
    }

    public boolean getSkipOptionalMetlets() {
        return this.skipOptionalMetlets;
    }

    public void setFirmwareBaudrate(int baudrate) {
        this.firmwareBaudrate = baudrate;
    }

    public int getFirmwareBaudrate() {
        return this.firmwareBaudrate;
    }

    public void setBootloaderBaudrate(int baudrate) {
        this.bootloaderBaudrate = baudrate;
    }

    public int getBootloaderBaudrate() {
        return this.bootloaderBaudrate;
    }

    public void setResponseFlushTime(int responseFlushTime) {
        this.responseFlushTime = responseFlushTime;
    }

    public int getResponseFlushTime() {
        return this.responseFlushTime;
    }

    private PublicKey getPublicKey() {
        try {
            InputStream keyIS = this.getClass().getResourceAsStream("public-key.der");
            byte[] encKey = new byte[keyIS.available()];
            DataInputStream dataIS = new DataInputStream(keyIS);
            dataIS.readFully(encKey);
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while reading public key", e);
        }
    }

    private JsonObject loadAndVerify(InputStream file) throws METJFlashException {
        byte[] metjSig;
        byte[] metjSigBase64;
        JsonObject obj;
        Signature signature;
        try {
            signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(this.getPublicKey());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected error while initializing signature object", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected error while reading public key", e);
        }
        try {
            JsonReader reader = Json.createReader((InputStream)new UpdateSignatureInputStream(file, signature, 348));
            obj = reader.readObject();
        }
        catch (JsonException e) {
            throw new METJFlashException("Error reading METJ JSON object: " + e.getMessage());
        }
        try {
            file.skip(2L);
            metjSigBase64 = new byte[file.available() - 2];
            DataInputStream dataIS = new DataInputStream(file);
            dataIS.readFully(metjSigBase64);
            dataIS.close();
        }
        catch (IOException e) {
            throw new METJFlashException("Error reading signature from METJ file: " + e.getMessage());
        }
        try {
            metjSig = DatatypeConverter.parseBase64Binary((String)new String(metjSigBase64));
        }
        catch (IllegalArgumentException e) {
            throw new METJFlashException("Invalid METJ signature (invalid Base64)");
        }
        try {
            if (!signature.verify(metjSig)) {
                throw new METJFlashException("METJ signature cannot be verified");
            }
        }
        catch (SignatureException e) {
            throw new METJFlashException("Invalid METJ signature: " + e.getMessage());
        }
        return obj;
    }

    private JsonObject loadWithoutVerify(InputStream file) throws METJFlashException {
        JsonObject obj;
        try {
            JsonReader reader = Json.createReader((InputStream)file);
            obj = reader.readObject();
        }
        catch (JsonException e) {
            throw new METJFlashException("Error reading METJ JSON object: " + e.getMessage());
        }
        return obj;
    }

    public void load(InputStream file) throws METJFlashException {
        JsonObject obj = this.verifySignature ? this.loadAndVerify(file) : this.loadWithoutVerify(file);
        int version = obj.getInt("metj-version");
        if (version < 1 || version > 2) {
            throw new METJFlashException("Unsupported METJ version " + version);
        }
        this.metjObj = obj;
    }

    public void load(File file) throws FileNotFoundException, METJFlashException {
        this.load(new FileInputStream(file));
    }

    public void unload() {
        this.metjObj = null;
    }

    public boolean isLoaded() {
        return this.metjObj != null;
    }

    public String getHardwareName() {
        return this.metjObj.getString("hardware-name");
    }

    public String getHardwareRevision() {
        return this.metjObj.getString("hardware-revision");
    }

    public String getFirmwareName() {
        return this.metjObj.getString("firmware-name");
    }

    public String getFirmwareRevision() {
        return this.metjObj.getString("firmware-revision");
    }

    public void setConnection(ICommConnection connection) {
        this.connection = connection;
    }

    public ICommConnection getConnection() {
        return this.connection;
    }

    private void prepareFlashing(UserInterface ui, boolean afterReset) throws CommConnectionException, METJFlashException {
        Bootloader btl;
        JsonObject connObj = this.metjObj.getJsonObject("connection");
        int fwBaudrate = this.firmwareBaudrate != 0 ? this.firmwareBaudrate : connObj.getInt("firmware-baudrate");
        int btlBaudrate = this.bootloaderBaudrate != 0 ? this.bootloaderBaudrate : connObj.getInt("bootloader-baudrate");
        switch (this.metjObj.getString("bootloader")) {
            case "MKU": {
                btl = new MKUBootloader(this.connection);
                break;
            }
            case "CC253X": {
                btl = new CC253XBootloader(this.connection);
                break;
            }
            case "ATMEL": {
                btl = new ATMELBootloader(this.connection);
                break;
            }
            default: {
                throw new METJFlashException("Unsupported bootloader required by METJ image.");
            }
        }
        ui.initializingBootloader();
        try {
            if (this.initializeAfterReset) {
                btl.initializeAfterReset(btlBaudrate);
            } else if (afterReset) {
                btl.initializeNormallyAfterReset(fwBaudrate, btlBaudrate);
            } else {
                btl.initialize(fwBaudrate, btlBaudrate);
            }
        }
        catch (BootloaderException e) {
            throw new METJFlashException(e.getMessage());
        }
        ui.initializedBootloader();
        if (this.connection instanceof UsbConnection) {
            UsbConnection usbConn = (UsbConnection)this.connection;
            usbConn.setSendTimeout(connObj.getInt("write-timeout"));
        }
    }

    private void prepareFlashing(UserInterface ui) throws CommConnectionException, METJFlashException {
        this.prepareFlashing(ui, false);
    }

    public void flash(UserInterface ui) throws CommConnectionException, METJFlashException {
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        this.prepareFlashing(ui);
        for (JsonValue metletGroup : this.metjObj.getJsonArray("metlets")) {
            if (!this.flashMetletGroup(ui, (JsonArray)metletGroup)) continue;
            return;
        }
        throw new METJFlashException("METJ file does not contain any image accepted by the bootloader.");
    }

    private boolean flashMetletGroup(UserInterface ui, JsonArray metletGroup) throws CommConnectionException, METJFlashException {
        for (int i = 1; i <= metletGroup.size(); ++i) {
            if (ui.sendingMetlet(i, metletGroup.size())) {
                return true;
            }
            try {
                if (this.flashMetlet(ui, metletGroup.getJsonObject(i - 1))) continue;
                return false;
            }
            catch (CommConnectionException e) {
                throw new METJFlashException("Error sending metlet #" + i + " to device: " + e.getErrorDescription());
            }
            catch (METJFlashException e) {
                throw new METJFlashException("Error sending metlet #" + i + " to device: " + e.getMessage());
            }
        }
        return true;
    }

    private boolean flashMetlet(UserInterface ui, JsonObject metlet) throws CommConnectionException, METJFlashException {
        int lastResponseLen;
        if (this.skipOptionalMetlets && !metlet.getBoolean("required", true)) {
            return true;
        }
        int readTimeout = this.metjObj.getJsonObject("connection").getInt("read-timeout");
        JsonArray responseArr = metlet.getJsonArray("responses");
        JsonObject lastResponse = responseArr.getJsonObject(responseArr.size() - 1);
        byte[] data = DatatypeConverter.parseBase64Binary((String)metlet.getString("data"));
        try {
            lastResponseLen = lastResponse.getInt("length");
        }
        catch (Exception e) {
            lastResponseLen = DatatypeConverter.parseBase64Binary((String)lastResponse.getString("data")).length;
        }
        byte[] recvBuffer = new byte[lastResponseLen];
        block8: for (int retry = 0; retry <= 3; ++retry) {
            int recvBufferOff = 0;
            Enum responseCode = null;
            this.connection.setRecvTimeout(readTimeout);
            this.connection.send(data);
            for (JsonValue responseVal : responseArr) {
                JsonObject response = (JsonObject)responseVal;
                byte[] responseData = DatatypeConverter.parseBase64Binary((String)response.getString("data"));
                int responseReadLen = response.getInt("length", responseData.length);
                int code = response.getInt("code", ResponseCode.SUCCESS.code);
                this.connection.recv(recvBuffer, recvBufferOff, responseReadLen - recvBufferOff);
                recvBufferOff = responseReadLen;
                if (!this.isByteArrayPrefix(recvBuffer, responseData)) continue;
                responseCode = ResponseCode.fromCode(code);
                break;
            }
            if (responseCode == null) {
                this.connection.setRecvTimeout(readTimeout);
                String buffer = this.formatByteArray(recvBuffer) + this.flushRecvBuffer(ui);
                throw new METJFlashException("Unknown bootloader response (" + buffer + ")");
            }
            if (this.responseFlushTime != 0) {
                this.connection.setRecvTimeout(this.responseFlushTime);
                this.flushRecvBuffer();
            }
            switch (1.$SwitchMap$com$metratec$lib$METJFlash$METJFlash$ResponseCode[responseCode.ordinal()]) {
                case 1: {
                    return true;
                }
                case 2: {
                    this.connection.setRecvTimeout(readTimeout);
                    this.flushRecvBuffer(ui);
                    ui.retryingMetlet();
                    continue block8;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    this.prepareFlashing(ui, true);
                    return true;
                }
                default: {
                    throw new METJFlashException(((ResponseCode)responseCode).description);
                }
            }
        }
        throw new METJFlashException("Giving up after 3 retries");
    }

    private String flushRecvBuffer() throws CommConnectionException {
        int b;
        long hardTimeout = this.connection.getRecvTimeout() * 2;
        StringBuilder ret = new StringBuilder();
        long startTime = System.nanoTime();
        while ((b = this.connection.recv()) >= 0 && (System.nanoTime() - startTime) / 1000000L < hardTimeout) {
            ret.append(String.format(" %02X", b));
        }
        return ret.toString();
    }

    private String flushRecvBuffer(UserInterface ui) throws CommConnectionException {
        ui.flushingRecvBuffer();
        String ret = this.flushRecvBuffer();
        ui.flushedRecvBuffer();
        return ret;
    }

    private boolean isByteArrayPrefix(byte[] arr, byte[] prefix) {
        if (arr.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (arr[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    private String formatByteArray(byte[] arr) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                ret.append(" ");
            }
            ret.append(String.format("%02X", arr[i]));
        }
        return ret.toString();
    }

    private static enum ResponseCode {
        SUCCESS(0, "Success"),
        CRC(1, "CRC error"),
        WRONG_HW(2, "Wrong hardware"),
        FULL(3, "Flash full"),
        SKIP_GROUP(4, "Group failure"),
        INIT_BTL(5, "Bootloader must be reinitialized");

        final int code;
        final String description;

        private ResponseCode(int code, String description) {
            this.code = code;
            this.description = description;
        }

        static ResponseCode fromCode(int code) {
            switch (code) {
                case 0: {
                    return SUCCESS;
                }
                case 1: {
                    return CRC;
                }
                case 2: {
                    return WRONG_HW;
                }
                case 3: {
                    return FULL;
                }
                case 4: {
                    return SKIP_GROUP;
                }
                case 5: {
                    return INIT_BTL;
                }
            }
            return null;
        }
    }
}

