/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.upnp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpnpLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpnpLibrary.class);
    private static final String PLUGIN_PROPERTY_FILENAME = "/library.properties";
    private static final Properties PLUGIN_PROPERTIES = new Properties();

    public static Logger getLogger() {
        return LOGGER;
    }

    public static String getBuildProperty(String key) {
        return PLUGIN_PROPERTIES.getProperty(key);
    }

    public static String getName() {
        return UpnpLibrary.getBuildProperty("name");
    }

    public static String getVersion() {
        return UpnpLibrary.getBuildProperty("version");
    }

    static {
        InputStream inputStream = null;
        try {
            inputStream = UpnpLibrary.class.getResourceAsStream(PLUGIN_PROPERTY_FILENAME);
            PLUGIN_PROPERTIES.load(inputStream);
        }
        catch (IOException e) {
            UpnpLibrary.getLogger().warn("Can not load library properties - " + e.getMessage());
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    UpnpLibrary.getLogger().debug(e.toString());
                }
            }
        }
    }
}

