/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.upnp;

import com.metratec.lib.upnp.Action;
import com.metratec.lib.upnp.Argument;
import com.metratec.lib.upnp.UpnpLibrary;
import com.metratec.lib.upnp.Utils;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Service {
    private final String serviceType;
    private final String serviceId;
    private final String scpdUrl;
    private final String controlURL;
    private final String eventSubURL;
    private final URL baseURL;
    private LoadServiceActionsThread thread = null;
    private List<Action> actions = null;

    public Service(URL baseURL, String serviceType, String serviceId, String scpdUrl, String controlURL, String eventSubURL) {
        this.baseURL = baseURL;
        this.serviceType = serviceType;
        this.serviceId = serviceId;
        this.scpdUrl = scpdUrl;
        this.controlURL = controlURL;
        this.eventSubURL = eventSubURL;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getControlURL() {
        return this.controlURL;
    }

    public String getEventSubURL() {
        return this.eventSubURL;
    }

    public List<Action> getActions() {
        return this.getActions(true);
    }

    public List<Action> getActions(boolean block) {
        if (this.actions != null) {
            return this.actions;
        }
        if (this.thread == null) {
            this.thread = new LoadServiceActionsThread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }
        if (!block) {
            return null;
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return this.actions;
    }

    public Action getActionByName(String name) {
        for (Action action : this.actions) {
            if (!name.equals(action.getName())) continue;
            return action;
        }
        return null;
    }

    private class LoadServiceActionsThread
    extends Thread {
        private final Service service;

        LoadServiceActionsThread(Service service2) {
            this.service = service2;
        }

        @Override
        public void run() {
            try {
                Service.this.actions = new ArrayList();
                URL url = new URL(Service.this.baseURL, Service.this.scpdUrl);
                URLConnection connection = url.openConnection();
                Document doc = Utils.parseXML(connection.getInputStream());
                NodeList actionsList = doc.getElementsByTagName("action");
                for (int i = 0; i < actionsList.getLength(); ++i) {
                    Element actionEl = (Element)actionsList.item(i);
                    String name = actionEl.getElementsByTagName("name").item(0).getTextContent();
                    NodeList arguments = actionEl.getElementsByTagName("argument");
                    Action action = new Action(name, this.service);
                    ArrayList<Argument> inputArguments = new ArrayList<Argument>();
                    ArrayList<Argument> outputArguments = new ArrayList<Argument>();
                    for (int j = 0; j < arguments.getLength(); ++j) {
                        Element argumentEl = (Element)arguments.item(j);
                        String argName = argumentEl.getElementsByTagName("name").item(0).getTextContent();
                        String argDirection = argumentEl.getElementsByTagName("direction").item(0).getTextContent();
                        Argument argument = new Argument(argName);
                        if ("in".equals(argDirection)) {
                            inputArguments.add(argument);
                            continue;
                        }
                        outputArguments.add(argument);
                    }
                    action.setInputArguments(inputArguments);
                    action.setOutputArguments(outputArguments);
                    Service.this.actions.add(action);
                }
                Service.this.actions = Collections.unmodifiableList(Service.this.actions);
            }
            catch (Exception ex) {
                UpnpLibrary.getLogger().error("Failed to get service actions from: " + Service.this.scpdUrl, (Throwable)ex);
            }
        }
    }
}

