/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.upnp;

import com.metratec.lib.upnp.Device;
import com.metratec.lib.upnp.UpnpLibrary;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Discovery {
    private static final String IPV4_MULTICAST_ADDRESS = "239.255.255.250";
    private static final String IPV6_MULTICAST_ADDRESS = "FF02::C";
    private static final int PORT = 1900;
    private final int timeout;
    private final String[] searchTargets;
    private final Set<Device> deviceSet = new TreeSet<Device>();
    private boolean ipv6Enabled = false;

    public Discovery() {
        this(3000);
    }

    public Discovery(int timeout) {
        this(timeout, "upnp:rootdevice");
    }

    public Discovery(int timeout, String ... searchTargets) {
        this.timeout = timeout;
        this.searchTargets = searchTargets;
    }

    public boolean isIpv6Enabled() {
        return this.ipv6Enabled;
    }

    public void setIpv6Enabled(boolean ipv6Enabled) {
        this.ipv6Enabled = ipv6Enabled;
    }

    private List<InetAddress> getLocalInetAddresses(boolean getIPv4, boolean sortIPv4BeforeIPv6) {
        Enumeration<NetworkInterface> networkInterfaces;
        ArrayList<InetAddress> arrayIPAddress = new ArrayList<InetAddress>();
        int lastIPv4Index = 0;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return arrayIPAddress;
        }
        if (networkInterfaces == null) {
            return arrayIPAddress;
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface card = networkInterfaces.nextElement();
            try {
                if (card.isLoopback() || card.isPointToPoint() || card.isVirtual()) continue;
                if (!card.isUp()) {
                }
            }
            catch (SocketException e) {}
            continue;
            Enumeration<InetAddress> addresses = card.getInetAddresses();
            if (addresses == null) continue;
            while (addresses.hasMoreElements()) {
                InetAddress inetAddress = addresses.nextElement();
                int index = arrayIPAddress.size();
                if (!getIPv4 || !this.ipv6Enabled) {
                    if (getIPv4 && !Inet4Address.class.isInstance(inetAddress) || this.ipv6Enabled && !Inet6Address.class.isInstance(inetAddress)) {
                        continue;
                    }
                } else if (sortIPv4BeforeIPv6 && Inet4Address.class.isInstance(inetAddress)) {
                    index = lastIPv4Index++;
                }
                arrayIPAddress.add(index, inetAddress);
            }
        }
        return arrayIPAddress;
    }

    public List<Device> discover() throws SocketException, UnknownHostException, IOException, SAXException, ParserConfigurationException {
        List<InetAddress> ips = this.getLocalInetAddresses(true, false);
        int mx = this.timeout / 1000;
        mx = mx < 1 ? 1 : mx;
        for (String searchTarget : this.searchTargets) {
            String searchMessage = "M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:1900\r\nST: " + searchTarget + "\r\nMAN: \"ssdp:discover\"\r\nMX: " + mx + "\r\n\r\n";
            String searchMessageIpv6 = "M-SEARCH * HTTP/1.1\r\nHOST: [FF02::C]:1900\r\nST: " + searchTarget + "\r\nMAN: \"ssdp:discover\"\r\nMX: " + mx + "\r\n\r\n";
            ArrayList<SendDiscoveryThread> threads = new ArrayList<SendDiscoveryThread>();
            for (InetAddress ip : ips) {
                SendDiscoveryThread thread = ip instanceof Inet4Address ? new SendDiscoveryThread(ip, searchMessage) : new SendDiscoveryThread(ip, searchMessageIpv6);
                threads.add(thread);
                thread.start();
            }
            for (SendDiscoveryThread thread : threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return new ArrayList<Device>(this.deviceSet);
    }

    private Device parseResponse(DatagramPacket receivePacket) {
        byte[] receivedData = new byte[receivePacket.getLength()];
        System.arraycopy(receivePacket.getData(), 0, receivedData, 0, receivePacket.getLength());
        Device device = new Device(receivePacket.getAddress());
        String replyString = new String(receivedData);
        StringTokenizer st = new StringTokenizer(replyString, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            if (line.isEmpty() || line.startsWith("HTTP/1.") || line.startsWith("NOTIFY *")) continue;
            String key = line.substring(0, line.indexOf(58));
            String value = line.length() > key.length() + 1 ? line.substring(key.length() + 1).trim() : null;
            if ((key = key.trim()).compareToIgnoreCase("location") == 0) {
                device.setLocation(value);
                continue;
            }
            if (key.compareToIgnoreCase("st") == 0) {
                device.setSt(value);
                continue;
            }
            if (key.compareToIgnoreCase("nls") == 0) {
                device.setNls(value);
                continue;
            }
            if (key.compareToIgnoreCase("usn") != 0) continue;
            device.setUsn(value);
        }
        return device;
    }

    private class SendDiscoveryThread
    extends Thread {
        InetAddress ip;
        String searchMessage;

        SendDiscoveryThread(InetAddress localIP, String searchMessage) {
            this.ip = localIP;
            this.searchMessage = searchMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DatagramSocket ssdp = null;
            try {
                ssdp = new DatagramSocket(new InetSocketAddress(this.ip, 0));
                byte[] searchMessageBytes = this.searchMessage.getBytes();
                DatagramPacket ssdpDiscoverPacket = new DatagramPacket(searchMessageBytes, searchMessageBytes.length);
                if (this.ip instanceof Inet4Address) {
                    ssdpDiscoverPacket.setAddress(InetAddress.getByName(Discovery.IPV4_MULTICAST_ADDRESS));
                } else {
                    ssdpDiscoverPacket.setAddress(InetAddress.getByName(Discovery.IPV6_MULTICAST_ADDRESS));
                }
                ssdpDiscoverPacket.setPort(1900);
                ssdp.send(ssdpDiscoverPacket);
                ssdp.setSoTimeout(Discovery.this.timeout);
                boolean waitingPacket = true;
                while (waitingPacket) {
                    DatagramPacket receivePacket = new DatagramPacket(new byte[1536], 1536);
                    try {
                        ssdp.receive(receivePacket);
                        Device device = Discovery.this.parseResponse(receivePacket);
                        device.setLocalAddress(this.ip);
                        Set set = Discovery.this.deviceSet;
                        synchronized (set) {
                            if (!Discovery.this.deviceSet.contains(device)) {
                                Discovery.this.deviceSet.add(device);
                                device.getDescription(false);
                            }
                        }
                    }
                    catch (SocketTimeoutException ex) {
                        waitingPacket = false;
                    }
                }
            }
            catch (Exception ex) {
                UpnpLibrary.getLogger().error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (null != ssdp) {
                    ssdp.close();
                }
            }
        }
    }
}

