/*
 * Decompiled with CFR 0.152.
 */
package com.metratec.lib.upnp;

import com.metratec.lib.upnp.Service;
import com.metratec.lib.upnp.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeviceDescription {
    private final String deviceType;
    private final String friendlyName;
    private final String manufacturer;
    private final String manufacturerURL;
    private final String modelDescription;
    private final String modelName;
    private final String modelNumber;
    private final String modelURL;
    private final String serialNumber;
    private final String udn;
    private final String presentationURL;
    private final URL descriptionUrl;
    private List<Service> serviceList = new ArrayList<Service>();

    public DeviceDescription(String descriptionUrl) throws IOException, MalformedURLException, ParserConfigurationException, SAXException {
        this.descriptionUrl = new URL(descriptionUrl);
        URLConnection connection = this.descriptionUrl.openConnection();
        Document doc = Utils.parseXML(connection.getInputStream());
        Element device = (Element)doc.getElementsByTagName("device").item(0);
        this.deviceType = Utils.getElementsText(device, "deviceType");
        this.friendlyName = Utils.getElementsText(device, "friendlyName");
        this.manufacturer = Utils.getElementsText(device, "manufacturer");
        this.manufacturerURL = Utils.getElementsText(device, "manufacturerURL");
        this.modelDescription = Utils.getElementsText(device, "modelDescription");
        this.modelName = Utils.getElementsText(device, "modelName");
        this.modelNumber = Utils.getElementsText(device, "modelNumber");
        this.modelURL = Utils.getElementsText(device, "modelURL");
        this.serialNumber = Utils.getElementsText(device, "serialNumber");
        this.udn = Utils.getElementsText(device, "UDN");
        this.presentationURL = Utils.getElementsText(device, "presentationURL");
        NodeList services = doc.getElementsByTagName("service");
        for (int i = 0; i < services.getLength(); ++i) {
            Element serviceEl = (Element)services.item(i);
            String serviceType = Utils.getElementsText(serviceEl, "serviceType");
            String serviceId = Utils.getElementsText(serviceEl, "serviceId");
            String scpdUrl = Utils.getElementsText(serviceEl, "SCPDURL");
            String controlURL = Utils.getElementsText(serviceEl, "controlURL");
            String eventSubURL = Utils.getElementsText(serviceEl, "eventSubURL");
            Service service = new Service(this.descriptionUrl, serviceType, serviceId, scpdUrl, controlURL, eventSubURL);
            service.getActions(false);
            this.serviceList.add(service);
        }
        this.serviceList = Collections.unmodifiableList(this.serviceList);
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getManufacturerURL() {
        return this.manufacturerURL;
    }

    public String getModelDescription() {
        return this.modelDescription;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public String getModelURL() {
        return this.modelURL;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getUdn() {
        return this.udn;
    }

    public String getPresentationURL() {
        return this.presentationURL;
    }

    public List<Service> getServices() {
        return this.serviceList;
    }

    public Service getServiceByType(String type) {
        for (Service service : this.serviceList) {
            if (!type.equals(service.getServiceType())) continue;
            return service;
        }
        return null;
    }

    public Service getServiceById(String id) {
        for (Service service : this.serviceList) {
            if (!id.equals(service.getServiceId())) continue;
            return service;
        }
        return null;
    }

    public String toString() {
        return this.friendlyName + " (" + this.presentationURL + ")";
    }
}

